/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class IntSelector
extends JPanel
implements ItemListener {
    private final JComboBox cbox_;
    private int selected_;

    public IntSelector(int[] options) {
        super(new BorderLayout());
        if (options != null) {
            int nopt = options.length;
            Object[] items = new Object[nopt];
            for (int i = 0; i < nopt; ++i) {
                items[i] = new Integer(options[i]);
            }
            this.cbox_ = new JComboBox<Object>(items);
        } else {
            this.cbox_ = new JComboBox();
        }
        this.cbox_.setEditable(true);
        this.cbox_.addItemListener(this);
        this.cbox_.setPreferredSize(new Dimension(64, this.cbox_.getPreferredSize().height));
        this.add(this.cbox_);
    }

    public int getValue() {
        return this.selected_;
    }

    public void setValue(int value) {
        this.cbox_.setSelectedItem(new Integer(value));
    }

    public void setEnabled(boolean enabled) {
        this.cbox_.setEnabled(enabled);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            Object item = evt.getItem();
            if (item instanceof Integer) {
                this.selected_ = (Integer)item;
            } else if (item instanceof String) {
                try {
                    this.selected_ = Integer.parseInt((String)item);
                }
                catch (NumberFormatException e) {
                    Toolkit.getDefaultToolkit().beep();
                    this.cbox_.setSelectedItem(new Integer(this.selected_));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.cbox_.setSelectedItem(new Integer(this.selected_));
            }
        }
    }
}

