/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.topcat.AbstractSubsetQueryWindow;
import uk.ac.starlink.topcat.TopcatModel;

public abstract class IntegerSubsetQueryWindow
extends AbstractSubsetQueryWindow {
    private final JTextField numField_ = new JTextField();
    private String lastNum_;

    public IntegerSubsetQueryWindow(TopcatModel tcModel, Component parent, String title, String numLabel) {
        super(tcModel, parent, title);
        this.numField_.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                IntegerSubsetQueryWindow.this.configureFields();
            }
        });
        this.lastNum_ = "";
        LabelledComponentStack stack = this.getStack();
        stack.addLine(numLabel, (Component)this.numField_);
        stack.addLine("Subset Name", (Component)this.getNameField());
        stack.addLine("Expression", (Component)this.getExpressionField());
    }

    private void configureFields() {
        String tnum = this.numField_.getText().trim();
        if (tnum.length() > 0) {
            int inum;
            try {
                inum = Integer.parseInt(tnum);
            }
            catch (NumberFormatException e) {
                inum = -1;
            }
            if (inum > 0) {
                this.lastNum_ = tnum;
                this.configureFields(inum);
            } else {
                IntegerSubsetQueryWindow.beep();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IntegerSubsetQueryWindow.this.numField_.setText(IntegerSubsetQueryWindow.this.lastNum_);
                    }
                });
            }
        } else {
            this.lastNum_ = "";
            this.setSelectedName(null);
            this.getExpressionField().setText("");
        }
    }

    protected abstract void configureFields(int var1);
}

