/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import gnu.jel.Parser;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatJELRowReader;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.ttools.jel.JELRowReader;

public class JELActivator
implements Activator {
    private final TopcatModel tcModel_;
    private final String expression_;
    private final TopcatJELRowReader rowReader_;
    private final CompiledExpression compEx_;
    private final Class resultType;

    public JELActivator(TopcatModel tcModel, String expression) throws CompilationException {
        this.tcModel_ = tcModel;
        this.expression_ = expression;
        RowSubset[] subsetArray = this.tcModel_.getSubsets().toArray(new RowSubset[0]);
        this.rowReader_ = new TopcatJELRowReader((StarTable)this.tcModel_.getDataModel(), subsetArray);
        Library lib = TopcatJELUtils.getLibrary((JELRowReader)this.rowReader_, true);
        this.compEx_ = Evaluator.compile((String)expression, (Library)lib, null);
        Class clazz = new Parser((String)expression, (Library)lib).parse(null).resType;
        if (clazz.isPrimitive()) {
            clazz = TopcatJELUtils.wrapPrimitiveClass(clazz);
        }
        this.resultType = clazz;
    }

    public String activateRow(long lrow) {
        try {
            Object result = this.rowReader_.evaluateAtRow(this.compEx_, lrow);
            if (result != null && !(result instanceof Boolean)) {
                return result.toString();
            }
            return null;
        }
        catch (Throwable th) {
            String msg = th.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = th.getClass().getName();
            }
            return "Error: " + msg;
        }
    }

    public String toString() {
        return this.expression_;
    }
}

