/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogConfig {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.util");
    private static final Pattern ASSIGN_REGEX = Pattern.compile("\\s*(?:(\\w+(?:\\.\\w+)*)\\s*=)?\\s*(\\w+)\\s*");
    public static String CONFIG_PROP = "star.logconfig";

    public static void setConfiguration(String config) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(config, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            Matcher matcher = ASSIGN_REGEX.matcher(token);
            if (matcher.matches()) {
                String domain = matcher.group(1);
                if (domain == null) {
                    domain = "";
                }
                String levid = matcher.group(2);
                Level level = Level.parse(levid.toUpperCase());
                buf.append(domain).append(".level").append(" = ").append(level.toString()).append('\n');
                continue;
            }
            throw new IllegalArgumentException("Invalid log config string: " + config);
        }
        String configProps = buf.toString();
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        try {
            BufferedInputStream propStream = new BufferedInputStream(new ByteArrayInputStream(configProps.getBytes()));
            LogManager.getLogManager().readConfiguration(propStream);
        }
        catch (IOException e) {
            throw new AssertionError();
        }
        for (int i = 0; i < handlers.length; ++i) {
            rootLogger.addHandler(handlers[i]);
        }
        StringTokenizer stok2 = new StringTokenizer(configProps, "\n");
        while (stok2.hasMoreTokens()) {
            logger_.config(stok2.nextToken());
        }
    }

    public static void initFromProperty() {
        String configLine = null;
        try {
            configLine = System.getProperty(CONFIG_PROP);
        }
        catch (SecurityException e) {
            logger_.info("Can't get property " + CONFIG_PROP);
            return;
        }
        if (configLine != null && configLine.trim().length() > 0) {
            try {
                LogConfig.setConfiguration(configLine);
            }
            catch (IllegalArgumentException e) {
                logger_.warning("Illegal logging config string: " + configLine);
            }
        }
    }

    private static InputStream getDefaultPropertyStream() {
        try {
            String fname = System.getProperty("java.util.logging.config.file");
            if (fname == null) {
                fname = System.getProperty("java.home");
                if (fname != null) {
                    File f = new File(fname, "lib");
                    f = new File(f, "logging.properties");
                    fname = f.getCanonicalPath();
                } else {
                    logger_.warning("Can't find java.home ??");
                }
            }
            if (fname != null) {
                return new FileInputStream(fname);
            }
        }
        catch (SecurityException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArrayInputStream(new byte[0]);
    }
}

