/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.SimpleFormatter;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;

public class LogHandler
extends MemoryHandler {
    private final DocHandler docHandler_;
    private Document doc_;
    private LogWindow logWindow_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat");
    private static LogHandler instance_;
    private static boolean configureFailed_;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$LogHandler;

    private LogHandler(DocHandler docHandler) {
        super(docHandler, 1000, Level.OFF);
        this.setLevel(Level.ALL);
        this.docHandler_ = docHandler;
    }

    public void showWindow(Component parent) {
        if (this.logWindow_ == null) {
            this.logWindow_ = new LogWindow(parent);
        }
        this.logWindow_.makeVisible();
    }

    public static LogHandler getInstance() {
        if (instance_ == null && !configureFailed_) {
            try {
                DocHandler target = new DocHandler();
                instance_ = new LogHandler(target);
            }
            catch (SecurityException e) {
                logger_.info("Logging configuration failed - security exception");
                configureFailed_ = true;
            }
        }
        return instance_;
    }

    private class LogWindow
    extends AuxWindow {
        public LogWindow(Component parent) {
            super("Message Log", parent);
            JEditorPane text = new JEditorPane();
            text.setEditable(false);
            JScrollPane scroller = new JScrollPane(text);
            scroller.setPreferredSize(new Dimension(500, 300));
            JPanel main = this.getMainArea();
            main.setLayout(new BorderLayout());
            main.add(scroller);
            LogHandler.this.doc_ = text.getDocument();
            ((LogHandler)LogHandler.this).docHandler_.doc_ = LogHandler.this.doc_;
            LogHandler.this.setPushLevel(Level.ALL);
            LogHandler.this.push();
            BasicAction clearAct = new BasicAction(this, "Clear", ResourceIcon.CLEAR, "Clear log of existing messages"){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ LogWindow this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1, x2);
                }

                public void actionPerformed(ActionEvent evt) {
                    block2: {
                        try {
                            LogHandler.access$000(LogWindow.access$200(this.this$1)).remove(0, LogHandler.access$000(LogWindow.access$200(this.this$1)).getLength());
                        }
                        catch (BadLocationException e) {
                            if ($assertionsDisabled) break block2;
                            throw new AssertionError();
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$uk$ac$starlink$topcat$LogHandler == null ? (class$uk$ac$starlink$topcat$LogHandler = LogHandler.class$("uk.ac.starlink.topcat.LogHandler")) : class$uk$ac$starlink$topcat$LogHandler).desiredAssertionStatus();
                }
            };
            this.getToolBar().add(clearAct);
            this.getToolBar().addSeparator();
            this.addHelp("LogWindow");
        }

        static /* synthetic */ LogHandler access$200(LogWindow x0) {
            return x0.LogHandler.this;
        }
    }

    private static class DocHandler
    extends Handler {
        Document doc_;

        public DocHandler() {
            this.setFormatter(new SimpleFormatter());
        }

        public void publish(LogRecord record) {
            if (this.doc_ != null) {
                String msg = this.getFormatter().format(record);
                SwingUtilities.invokeLater(new Runnable(this, msg){
                    static final /* synthetic */ boolean $assertionsDisabled;
                    private final /* synthetic */ String val$msg;
                    private final /* synthetic */ DocHandler this$0;
                    {
                        this.this$0 = this$0;
                        this.val$msg = val$msg;
                    }

                    public void run() {
                        block2: {
                            try {
                                this.this$0.doc_.insertString(this.this$0.doc_.getLength(), this.val$msg, null);
                            }
                            catch (BadLocationException e) {
                                if ($assertionsDisabled) break block2;
                                throw new AssertionError();
                            }
                        }
                    }

                    static {
                        $assertionsDisabled = !(class$uk$ac$starlink$topcat$LogHandler == null ? (class$uk$ac$starlink$topcat$LogHandler = LogHandler.class$("uk.ac.starlink.topcat.LogHandler")) : class$uk$ac$starlink$topcat$LogHandler).desiredAssertionStatus();
                    }
                });
            }
        }

        public void flush() {
        }

        public void close() {
            this.doc_ = null;
        }
    }
}

