/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.ttools.build.Heading;
import uk.ac.starlink.ttools.gui.MethodBrowser;

public class MethodWindow
extends AuxWindow {
    private static MethodWindow window;
    private final MethodBrowser browser_ = new MethodBrowser();
    private final DefaultMutableTreeNode activNode_;

    public MethodWindow(Component parent) {
        super("Available Functions", parent);
        this.getMainArea().add((Component)this.browser_);
        final DefaultMutableTreeNode root = this.browser_.getRoot();
        Iterator it = TopcatJELUtils.getStaticClasses().iterator();
        while (it.hasNext()) {
            this.browser_.addStaticClass((Class)it.next(), root);
        }
        this.activNode_ = new DefaultMutableTreeNode(Heading.ACTIVATION, true);
        root.add(this.activNode_);
        it = TopcatJELUtils.getActivationStaticClasses().iterator();
        while (it.hasNext()) {
            this.browser_.addStaticClass((Class)it.next(), this.activNode_);
        }
        final MethodWindow subpar = this;
        final String[] message = new String[]{"Enter the fully-qualified path of a", "class on the class path containing", "public static methods to import into", "the expressions namespace"};
        BasicAction addAction = new BasicAction("Add Class", ResourceIcon.ADD, "Add a class containing more methods"){

            public void actionPerformed(ActionEvent evt) {
                String cname = null;
                while (true) {
                    Object c;
                    String string = cname = (c = JOptionPane.showInputDialog(subpar, message, "Add New Class", 3, null, null, cname)) == null ? null : c.toString();
                    if (cname == null) {
                        return;
                    }
                    Class clazz = TopcatJELUtils.classForName(cname);
                    if (clazz != null) {
                        TopcatJELUtils.getStaticClasses().add(clazz);
                        MethodWindow.this.browser_.addStaticClass(clazz, root);
                        return;
                    }
                    JOptionPane.showMessageDialog(subpar, "The class " + cname + " is not on the class path", "Class not found", 0);
                }
            }
        };
        addAction.setEnabled(TopcatUtils.canJel());
        TreePath rootPath = new TreePath(root);
        this.browser_.getTree().expandPath(rootPath);
        this.getToolBar().add(addAction);
        this.getToolBar().addSeparator();
        this.addHelp("MethodWindow");
    }

    private void showActivation(boolean show) {
        TreePath activPath = new TreePath(new Object[]{this.browser_.getRoot(), this.activNode_});
        if (show) {
            this.browser_.getTree().expandPath(activPath);
        } else {
            this.browser_.getTree().collapsePath(activPath);
        }
    }

    public static Action getWindowAction(final Component parent, final boolean activation) {
        return new BasicAction("Available Functions", ResourceIcon.FUNCTION, "Display information about available algebraic functions"){

            public void actionPerformed(ActionEvent evt) {
                if (window == null) {
                    window = new MethodWindow(parent);
                }
                window.showActivation(activation);
                window.makeVisible();
            }
        };
    }

    public MethodBrowser getBrowser() {
        return this.browser_;
    }
}

