/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import uk.ac.starlink.table.StarTable;

class MirageHandler {
    private static Method invokeMethod;

    MirageHandler() {
    }

    public static boolean isMirageAvailable() {
        if (invokeMethod != null) {
            return true;
        }
        try {
            Class.forName("mirage.Mirage", true, Thread.currentThread().getContextClassLoader());
            Class<?> driverClass = Class.forName("uk.ac.starlink.mirage.MirageDriver", true, Thread.currentThread().getContextClassLoader());
            Class[] argTypes = new Class[]{StarTable.class, List.class};
            invokeMethod = driverClass.getMethod("invokeMirage", argTypes);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void invokeMirage(StarTable startab, List margs) throws Exception {
        if (!MirageHandler.isMirageAvailable()) {
            throw new UnsupportedOperationException("No mirage");
        }
        try {
            invokeMethod.invoke(null, startab, margs);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw e;
        }
    }
}

