/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import [Ljava.lang.String;;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class NormaliseTable
extends WrapperStarTable {
    private final Converter[] converters_;

    public NormaliseTable(StarTable base) {
        super(base);
        int ncol = base.getColumnCount();
        this.converters_ = new Converter[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            this.converters_[icol] = NormaliseTable.createConverter(super.getColumnInfo(icol));
        }
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.converters_[icol].getColumnInfo();
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.converters_[icol].convert(super.getCell(irow, icol));
    }

    public Object[] getRow(long irow) throws IOException {
        return this.convertRow(super.getRow(irow));
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){

            public Object getCell(int icol) throws IOException {
                return NormaliseTable.this.converters_[icol].convert(super.getCell(icol));
            }

            public Object[] getRow() throws IOException {
                return NormaliseTable.this.convertRow(super.getRow());
            }
        };
    }

    private Object[] convertRow(Object[] row) {
        for (int icol = 0; icol < this.converters_.length; ++icol) {
            row[icol] = this.converters_[icol].convert(row[icol]);
        }
        return row;
    }

    private static Converter createConverter(final ColumnInfo info) {
        Class clazz = info.getContentClass();
        if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class || clazz == Character.class || clazz == String.class || clazz == [B.class || clazz == [S.class || clazz == [I.class || clazz == [J.class || clazz == [F.class || clazz == [D.class || clazz == String;.class) {
            return new Converter(){

                public ColumnInfo getColumnInfo() {
                    return info;
                }

                public Object convert(Object value) {
                    return value;
                }
            };
        }
        if (clazz == Number.class) {
            final ColumnInfo dubInfo = new ColumnInfo(info);
            dubInfo.setContentClass(Double.class);
            return new Converter(){

                public ColumnInfo getColumnInfo() {
                    return dubInfo;
                }

                public Object convert(Object value) {
                    if (value instanceof Double) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return new Double(((Number)value).doubleValue());
                    }
                    return null;
                }
            };
        }
        final ColumnInfo strInfo = new ColumnInfo(info);
        strInfo.setContentClass(String.class);
        return new Converter(){

            public ColumnInfo getColumnInfo() {
                return strInfo;
            }

            public Object convert(Object value) {
                return value == null ? null : value.toString();
            }
        };
    }

    private static abstract class Converter {
        private Converter() {
        }

        public abstract ColumnInfo getColumnInfo();

        public abstract Object convert(Object var1);
    }
}

