/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.event.ActionEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import uk.ac.starlink.topcat.CheckBoxMenu;
import uk.ac.starlink.topcat.CustomComboBoxRenderer;
import uk.ac.starlink.topcat.RowSubset;

public class OptionsListModel
extends AbstractList
implements ListModel {
    private final List options = new ArrayList();
    private final BasicListModel bmodel = new BasicListModel();

    public Object get(int index) {
        return this.options.get(index);
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    public int size() {
        return this.options.size();
    }

    public int getSize() {
        return this.size();
    }

    public boolean add(Object obj) {
        int index = this.options.size();
        boolean ret = this.options.add(obj);
        this.fireIntervalAdded(index, index);
        return ret;
    }

    public Object set(int irow, Object obj) {
        Object oldval = this.options.set(irow, obj);
        this.bmodel.fireContentsChanged(this.bmodel, irow, irow);
        return oldval;
    }

    public ComboBoxModel makeComboBoxModel() {
        class ListComboBoxModel
        extends BasicListModel
        implements ComboBoxModel,
        ListDataListener {
            private Object selected;

            ListComboBoxModel() {
            }

            public void setSelectedItem(Object item) {
                if (this.selected != null && !this.selected.equals(item) || this.selected == null && item != null) {
                    this.selected = item;
                    this.fireContentsChanged(this, -1, -1);
                }
            }

            public Object getSelectedItem() {
                return this.selected;
            }

            public void contentsChanged(ListDataEvent evt) {
                this.fireContentsChanged(this, evt.getIndex0(), evt.getIndex1());
            }

            public void intervalAdded(ListDataEvent evt) {
                this.fireIntervalAdded(this, evt.getIndex0(), evt.getIndex1());
            }

            public void intervalRemoved(ListDataEvent evt) {
                this.fireIntervalRemoved(this, evt.getIndex0(), evt.getIndex1());
            }
        }
        ListComboBoxModel cbm = new ListComboBoxModel();
        this.addListDataListener(cbm);
        return cbm;
    }

    public JComboBox makeComboBox() {
        final JComboBox box = new JComboBox(this.makeComboBoxModel());
        this.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent evt) {
                box.revalidate();
            }

            public void intervalRemoved(ListDataEvent evt) {
            }

            public void contentsChanged(ListDataEvent evt) {
            }
        });
        box.setRenderer(new CustomComboBoxRenderer(){

            public Object mapValue(Object value) {
                if (value instanceof RowSubset) {
                    return ((RowSubset)value).getName();
                }
                return value;
            }
        });
        return box;
    }

    public JMenu makeJMenu(String menuName, Action menuAction) {
        class ListMenu
        extends JMenu
        implements ListDataListener {
            private final /* synthetic */ Action val$menuAction;

            ListMenu(Action val$menuAction) {
                this.val$menuAction = val$menuAction;
            }

            public void intervalAdded(ListDataEvent evt) {
                int start = evt.getIndex0();
                int nel = evt.getIndex1() - start + 1;
                if (start == this.getItemCount()) {
                    for (int i = start; i < start + nel; ++i) {
                        this.add(OptionsListModel.this.makeJMenuItem(this.val$menuAction, i));
                    }
                } else {
                    throw new UnsupportedOperationException("Can't handle event: " + evt);
                }
            }

            public void intervalRemoved(ListDataEvent evt) {
                this.contentsChanged(evt);
            }

            public void contentsChanged(ListDataEvent evt) {
                this.removeAll();
                for (int i = 0; i < OptionsListModel.this.options.size(); ++i) {
                    this.add(OptionsListModel.this.makeJMenuItem(this.val$menuAction, i));
                }
            }
        }
        ListMenu menu = new ListMenu(menuAction);
        menu.setText(menuName);
        menu.contentsChanged(new ListDataEvent(this, 0, 0, this.options.size() - 1));
        this.addListDataListener(menu);
        return menu;
    }

    private JMenuItem makeJMenuItem(final Action menuAction, final int index) {
        final String text = this.options.get(index).toString();
        AbstractAction act = new AbstractAction(text){

            public void actionPerformed(ActionEvent evt) {
                ActionEvent evt1 = new ActionEvent(this, index, text);
                menuAction.actionPerformed(evt1);
            }
        };
        return new JMenuItem(act);
    }

    public CheckBoxMenu makeCheckBoxMenu(String menuName) {
        class ListMenu
        extends CheckBoxMenu
        implements ListDataListener {
            ListMenu() {
            }

            public void intervalAdded(ListDataEvent evt) {
                int start = evt.getIndex0();
                int nel = evt.getIndex1() - start + 1;
                if (start == this.getItemCount()) {
                    for (int i = start; i < start + nel; ++i) {
                        this.addMenuItem(OptionsListModel.this.options.get(i).toString());
                    }
                } else {
                    throw new UnsupportedOperationException("Can't handle event: " + evt);
                }
            }

            public void intervalRemoved(ListDataEvent evt) {
                this.contentsChanged(evt);
            }

            public void contentsChanged(ListDataEvent evt) {
                this.removeAll();
                int nel = OptionsListModel.this.options.size();
                for (int i = 0; i < nel; ++i) {
                    this.addMenuItem(OptionsListModel.this.options.get(i).toString());
                }
            }
        }
        ListMenu menu = new ListMenu();
        menu.setText(menuName);
        menu.contentsChanged(new ListDataEvent(this, 0, 0, this.options.size() - 1));
        this.addListDataListener(menu);
        return menu;
    }

    public void addListDataListener(ListDataListener l) {
        this.bmodel.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.bmodel.removeListDataListener(l);
    }

    public void fireContentsChanged(int i0, int i1) {
        this.bmodel.fireContentsChanged(this.bmodel, i0, i1);
    }

    public void fireIntervalAdded(int i0, int i1) {
        this.bmodel.fireIntervalAdded(this.bmodel, i0, i1);
    }

    public void fireIntervalRemoved(int i0, int i1) {
        this.bmodel.fireIntervalRemoved(this.bmodel, i0, i1);
    }

    private class BasicListModel
    extends AbstractListModel {
        private BasicListModel() {
        }

        public Object getElementAt(int index) {
            return OptionsListModel.this.get(index);
        }

        public int getSize() {
            return OptionsListModel.this.size();
        }

        protected void fireContentsChanged(Object source, int i0, int i1) {
            super.fireContentsChanged(source, i0, i1);
        }

        protected void fireIntervalAdded(Object source, int i0, int i1) {
            super.fireIntervalAdded(source, i0, i1);
        }

        protected void fireIntervalRemoved(Object source, int i0, int i1) {
            super.fireIntervalRemoved(source, i0, i1);
        }
    }
}

