/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;

public class ParameterDetailPanel
extends JPanel {
    private final TableModel model_;
    private final LineField[] lineFields_;
    private final JComponent valuePanel_;
    private final int iValueCol_;
    private ValueDisplay lineDisplay_;
    private ValueDisplay textDisplay_;
    private ValueDisplay vectorDisplay_;
    private JComponent valueDisplay_;
    private int irow_;
    private DescribedValue dval_;
    private static final ValueInfo DUMMY_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParameterDetailPanel(TableModel model) {
        this.model_ = model;
        this.irow_ = -1;
        this.dval_ = new DescribedValue(DUMMY_INFO, null);
        String[] fieldNames = new String[]{"Name", "Class", "Shape", "Units", "Description", "UCD"};
        this.lineFields_ = new LineField[fieldNames.length];
        for (int ifield = 0; ifield < this.lineFields_.length; ++ifield) {
            int icol = ParameterDetailPanel.findColumn(model, fieldNames[ifield]);
            if (!$assertionsDisabled && !(class$java$lang$String == null ? ParameterDetailPanel.class$("java.lang.String") : class$java$lang$String).equals(model.getColumnClass(icol))) {
                throw new AssertionError();
            }
            this.lineFields_[ifield] = new LineField(icol);
        }
        this.valuePanel_ = Box.createHorizontalBox();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ParameterDetailPanel.layoutForm(this, this.model_, this.lineFields_, this.valuePanel_);
        this.updateValue();
        this.iValueCol_ = ParameterDetailPanel.findColumn(model, "Value");
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                if (evt.getFirstRow() <= ParameterDetailPanel.this.irow_ && evt.getLastRow() >= ParameterDetailPanel.this.irow_) {
                    int icol = evt.getColumn();
                    if (icol == -1) {
                        ParameterDetailPanel.this.updateValue();
                        ParameterDetailPanel.this.updateFields();
                    } else if (icol == ParameterDetailPanel.this.iValueCol_) {
                        ParameterDetailPanel.this.updateValue();
                    } else {
                        ParameterDetailPanel.this.updateFields();
                    }
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        Dimension size = new Dimension(super.getMinimumSize());
        size.height += 24;
        return size;
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension(super.getPreferredSize());
        size.height += 60;
        return size;
    }

    public void setItem(int irow, DescribedValue dval) {
        this.irow_ = irow;
        this.dval_ = dval == null ? new DescribedValue(DUMMY_INFO, null) : dval;
        this.updateFields();
        this.updateValue();
    }

    private void updateFields() {
        for (int i = 0; i < this.lineFields_.length; ++i) {
            String text;
            LineField field = this.lineFields_[i];
            int icol = field.getColumnIndex();
            JTextField textField = field.getTextField();
            Object val = this.irow_ >= 0 ? this.model_.getValueAt(this.irow_, icol) : null;
            String string = text = val instanceof String ? (String)val : "";
            if (!text.equals(textField.getText())) {
                textField.setEditable(false);
                textField.setText(text);
            }
            textField.setEditable(this.irow_ >= 0 && this.model_.isCellEditable(this.irow_, icol));
        }
    }

    private void updateValue() {
        JComponent display = this.getDisplayComponent(this.dval_.getInfo(), this.dval_.getValue());
        if (display != this.valueDisplay_) {
            this.valuePanel_.removeAll();
            this.valuePanel_.add(display);
            this.valueDisplay_ = display;
            this.valuePanel_.repaint();
            this.valuePanel_.revalidate();
        }
        display.revalidate();
    }

    private JComponent getDisplayComponent(ValueInfo info, Object value) {
        ValueDisplay display;
        Class clazz = info.getContentClass();
        boolean editable = this.irow_ >= 0 && this.model_.isCellEditable(this.irow_, this.iValueCol_);
        if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || this.irow_ == 0) {
            display = this.getLineDisplay();
            display.setEditable(editable);
        } else if (String.class.equals(clazz)) {
            display = this.getTextDisplay();
            display.setEditable(editable);
        } else if (clazz.isArray()) {
            display = this.getVectorDisplay();
        } else {
            display = this.getLineDisplay();
            display.setEditable(false);
        }
        display.setValue(info, value);
        return display.getComponent();
    }

    private ValueDisplay getLineDisplay() {
        if (this.lineDisplay_ == null) {
            JTextField field = new JTextField(){

                public Dimension getMaximumSize() {
                    return new Dimension(Integer.MAX_VALUE, super.getPreferredSize().height);
                }
            };
            Box fieldBox = Box.createVerticalBox();
            fieldBox.add(field);
            fieldBox.add(Box.createVerticalGlue());
            this.lineDisplay_ = new TextValueDisplay(fieldBox, field);
        }
        return this.lineDisplay_;
    }

    private ValueDisplay getTextDisplay() {
        if (this.textDisplay_ == null) {
            JEditorPane editor = new JEditorPane();
            editor.setFont(new Font("Monospaced", 0, this.getFont().getSize()));
            this.textDisplay_ = new TextValueDisplay(new JScrollPane(editor), editor);
        }
        return this.textDisplay_;
    }

    private ValueDisplay getVectorDisplay() {
        if (this.vectorDisplay_ == null) {
            final JTable table = new JTable();
            JScrollPane scroller = new JScrollPane(table);
            this.vectorDisplay_ = new ValueDisplay(scroller){

                public void setValue(ValueInfo info, Object value) {
                    String[] array = value != null && value.getClass().isArray() ? value : new String[]{};
                    AbstractTableModel arrayModel = new AbstractTableModel(this, array){
                        private final /* synthetic */ Object val$array;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$array = val$array;
                        }

                        public int getColumnCount() {
                            return 2;
                        }

                        public int getRowCount() {
                            return Array.getLength(this.val$array);
                        }

                        public String getColumnName(int icol) {
                            switch (icol) {
                                case 0: {
                                    return "Index";
                                }
                                case 1: {
                                    return "Value";
                                }
                            }
                            throw new IllegalArgumentException();
                        }

                        public Object getValueAt(int irow, int icol) {
                            switch (icol) {
                                case 0: {
                                    return new Integer(irow + 1);
                                }
                                case 1: {
                                    return Array.get(this.val$array, irow);
                                }
                            }
                            throw new IllegalArgumentException();
                        }
                    };
                    table.setModel(arrayModel);
                    table.getColumnModel().getColumn(0).setMaxWidth(100);
                }

                public void setEditable(boolean editable) {
                }
            };
        }
        return this.vectorDisplay_;
    }

    private static void layoutForm(JComponent form, TableModel model, LineField[] lineFields, JComponent valuePanel) {
        GridBagLayout layer = new GridBagLayout();
        form.setLayout(layer);
        int gridy = 0;
        for (int ifield = 0; ifield < lineFields.length; ++ifield) {
            LineField field = lineFields[ifield];
            GridBagConstraints cl = new GridBagConstraints();
            cl.gridy = gridy;
            cl.gridx = 1;
            cl.anchor = 13;
            JLabel label = new JLabel(model.getColumnName(field.getColumnIndex()) + ":  ");
            layer.setConstraints(label, cl);
            form.add(label);
            GridBagConstraints ct = new GridBagConstraints();
            ct.gridy = gridy++;
            ct.gridx = 2;
            ct.anchor = 17;
            ct.weightx = 1.0;
            ct.fill = 2;
            ct.gridwidth = 0;
            JTextField textField = field.getTextField();
            layer.setConstraints(textField, ct);
            form.add(textField);
            GridBagConstraints cs = new GridBagConstraints();
            cs.gridx = 0;
            cs.gridy = gridy++;
            Component strut = Box.createVerticalStrut(5);
            layer.setConstraints(strut, cs);
            form.add(strut);
        }
        GridBagConstraints cv = new GridBagConstraints();
        cv.gridy = gridy;
        cv.weighty = 1.0;
        cv.gridx = 1;
        cv.anchor = 12;
        JLabel label = new JLabel("Value:  ");
        layer.setConstraints(label, cv);
        form.add(label);
        cv.gridx = 2;
        cv.anchor = 18;
        cv.weightx = 1.0;
        cv.fill = 1;
        cv.gridwidth = 0;
        cv.gridheight = 0;
        layer.setConstraints(valuePanel, cv);
        form.add(valuePanel);
    }

    private static int findColumn(TableModel model, String colName) {
        int ncol = model.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            if (!model.getColumnName(icol).equals(colName)) continue;
            return icol;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !ParameterDetailPanel.class.desiredAssertionStatus();
        DUMMY_INFO = new DefaultValueInfo("", String.class, "");
    }

    private class LineField {
        private final int icol_;
        private final JTextField textField_;

        LineField(int icol) {
            this.icol_ = icol;
            this.textField_ = new JTextField();
            this.textField_.setEditable(false);
            this.textField_.addCaretListener(new CaretListener(this){
                private final /* synthetic */ LineField this$1;
                {
                    this.this$1 = this$1;
                }

                public void caretUpdate(CaretEvent evt) {
                    String text;
                    if (LineField.access$800(this.this$1).isEditable() && (text = LineField.access$800(this.this$1).getText()) != null && !text.equals(ParameterDetailPanel.access$700(LineField.access$900(this.this$1)).getValueAt(ParameterDetailPanel.access$000(LineField.access$900(this.this$1)), LineField.access$1000(this.this$1)))) {
                        ParameterDetailPanel.access$700(LineField.access$900(this.this$1)).setValueAt(text, ParameterDetailPanel.access$000(LineField.access$900(this.this$1)), LineField.access$1000(this.this$1));
                    }
                }
            });
        }

        public int getColumnIndex() {
            return this.icol_;
        }

        public JTextField getTextField() {
            return this.textField_;
        }

        static /* synthetic */ JTextField access$800(LineField x0) {
            return x0.textField_;
        }

        static /* synthetic */ ParameterDetailPanel access$900(LineField x0) {
            return x0.ParameterDetailPanel.this;
        }

        static /* synthetic */ int access$1000(LineField x0) {
            return x0.icol_;
        }
    }

    private class TextValueDisplay
    extends ValueDisplay {
        private final JTextComponent tcomp_;
        private ValueInfo info_;
        private boolean changing_;

        TextValueDisplay(JComponent comp, JTextComponent tcomp) {
            super(comp);
            this.tcomp_ = tcomp;
            this.tcomp_.addCaretListener(new CaretListener(this){
                private final /* synthetic */ TextValueDisplay this$1;
                {
                    this.this$1 = this$1;
                }

                public void caretUpdate(CaretEvent evt) {
                    if (!TextValueDisplay.access$400(this.this$1) && TextValueDisplay.access$500(this.this$1).isEditable()) {
                        TextValueDisplay.access$402(this.this$1, true);
                        TextValueDisplay.access$600(this.this$1);
                        TextValueDisplay.access$402(this.this$1, false);
                    }
                }
            });
        }

        public void setValue(ValueInfo info, Object value) {
            this.info_ = info;
            if (!this.changing_) {
                this.changing_ = true;
                this.tcomp_.setText(this.info_.formatValue(value, Integer.MAX_VALUE));
                this.tcomp_.setCaretPosition(0);
                this.changing_ = false;
            }
        }

        public void setEditable(boolean isEditable) {
            this.tcomp_.setEditable(isEditable);
        }

        private void updateValue() {
            Object val;
            String text = this.tcomp_.getText();
            if (text != null && !(val = this.info_.unformatString(text)).equals(ParameterDetailPanel.this.model_.getValueAt(ParameterDetailPanel.this.irow_, ParameterDetailPanel.this.iValueCol_))) {
                ParameterDetailPanel.this.model_.setValueAt(val, ParameterDetailPanel.this.irow_, ParameterDetailPanel.this.iValueCol_);
            }
        }

        static /* synthetic */ boolean access$400(TextValueDisplay x0) {
            return x0.changing_;
        }

        static /* synthetic */ JTextComponent access$500(TextValueDisplay x0) {
            return x0.tcomp_;
        }

        static /* synthetic */ boolean access$402(TextValueDisplay x0, boolean x1) {
            x0.changing_ = x1;
            return x0.changing_;
        }

        static /* synthetic */ void access$600(TextValueDisplay x0) {
            x0.updateValue();
        }
    }

    private static abstract class ValueDisplay {
        private final JComponent comp_;

        protected ValueDisplay(JComponent comp) {
            this.comp_ = comp;
        }

        public JComponent getComponent() {
            return this.comp_;
        }

        public abstract void setValue(ValueInfo var1, Object var2);

        public abstract void setEditable(boolean var1);
    }
}

