/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.UCDSelector;
import uk.ac.starlink.topcat.ClassComboBoxRenderer;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.TopcatModel;

public class ParameterQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private final JTextField nameField_;
    private final JComboBox typeBox_;
    private final JTextField valueField_;
    private final JTextField unitsField_;
    private final JTextField descField_;
    private final UCDSelector ucdSelector_;

    public ParameterQueryWindow(TopcatModel tcModel, Component parent) {
        super("Add New Parameter", parent);
        this.tcModel_ = tcModel;
        LabelledComponentStack stack = this.getStack();
        this.nameField_ = new JTextField();
        stack.addLine("Parameter Name", (Component)this.nameField_);
        this.typeBox_ = new JComboBox();
        this.typeBox_.addItem(String.class);
        this.typeBox_.addItem(Byte.class);
        this.typeBox_.addItem(Short.class);
        this.typeBox_.addItem(Integer.class);
        this.typeBox_.addItem(Long.class);
        this.typeBox_.addItem(Float.class);
        this.typeBox_.addItem(Double.class);
        this.typeBox_.addItem(Boolean.class);
        this.typeBox_.setRenderer(ClassComboBoxRenderer.getInstance());
        this.typeBox_.setSelectedItem(String.class);
        stack.addLine("Type", (Component)this.typeBox_);
        this.valueField_ = new JTextField();
        stack.addLine("Value", (Component)this.valueField_);
        this.unitsField_ = new JTextField();
        stack.addLine("Units", (Component)this.unitsField_);
        this.descField_ = new JTextField();
        stack.addLine("Description", (Component)this.descField_);
        this.ucdSelector_ = new UCDSelector();
        stack.addLine("UCD", (Component)this.ucdSelector_);
        this.addHelp("ParameterQueryWindow");
    }

    /*
     * WARNING - void declaration
     */
    protected boolean perform() {
        void var8_8;
        Object value;
        String name = ParameterQueryWindow.normalize(this.nameField_.getText());
        Class clazz = (Class)this.typeBox_.getSelectedItem();
        String valueString = ParameterQueryWindow.normalize(this.valueField_.getText());
        String units = ParameterQueryWindow.normalize(this.unitsField_.getText());
        String desc = ParameterQueryWindow.normalize(this.descField_.getText());
        String ucd = this.ucdSelector_.getID();
        if (name == null) {
            return false;
        }
        DefaultValueInfo vinfo = new DefaultValueInfo(name, clazz, desc);
        vinfo.setUnitString(units);
        vinfo.setUCD(ucd);
        if (valueString == null) {
            value = null;
        } else {
            try {
                value = vinfo.unformatString(valueString);
            }
            catch (RuntimeException e) {
                String[] msg = new String[]{"Invalid value \"" + valueString + "\"", "for type " + clazz.getName(), "(" + e.toString() + ")"};
                JOptionPane.showMessageDialog(this, msg, "Invalid Parameter Value", 0);
                return false;
            }
        }
        DescribedValue dval = new DescribedValue((ValueInfo)vinfo, (Object)var8_8);
        this.tcModel_.addParameter(dval);
        return true;
    }

    private static String normalize(String base) {
        return base == null || base.trim().length() == 0 ? null : base;
    }
}

