/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.ParameterDetailPanel;
import uk.ac.starlink.topcat.ParameterQueryWindow;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.TableColumnModelAdapter;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;

public class ParameterWindow
extends AuxWindow
implements TopcatListener,
ListSelectionListener {
    private TopcatModel tcModel;
    private PlasticStarTable dataModel;
    private TableModel viewModel;
    private TableColumnModel columnModel;
    private ParamList params;
    private Collection uneditableParams;
    private DescribedValue ncolParam;
    private DescribedValue nrowParam;
    private MetaColumnTableModel metaTableModel;
    private final ListSelectionModel rowSelectionModel;
    private final Action removeAct;
    private int ncolRowIndex;
    private int nrowRowIndex;
    private final ParameterDetailPanel detailPanel;
    private static final ValueInfo NAME_INFO = new DefaultValueInfo("Name", String.class, "Table name");
    private static final ValueInfo URL_INFO = new DefaultValueInfo("URL", URL.class, "URL of original table");
    private static final ValueInfo NCOL_INFO = new DefaultValueInfo("Column Count", Integer.class, "Number of columns");
    private static final ValueInfo NROW_INFO = new DefaultValueInfo("Row Count", Long.class, "Number of rows");
    public static final String NAME_NAME = "Name";
    public static final String VALUE_NAME = "Value";
    public static final String CLASS_NAME = "Class";
    public static final String SHAPE_NAME = "Shape";
    public static final String ELSIZE_NAME = "Element Size";
    public static final String UNITS_NAME = "Units";
    public static final String DESC_NAME = "Description";
    public static final String UCD_NAME = "UCD";
    public static final String UCDDESC_NAME = "UCD Description";
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.topcat");
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ParameterWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Table Parameters", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.viewModel = tcModel.getViewModel();
        this.columnModel = tcModel.getColumnModel();
        tcModel.addTopcatListener(this);
        this.params = new ParamList(this.dataModel.getParameters());
        this.uneditableParams = new HashSet();
        DescribedValue nameParam = new DescribedValue(NAME_INFO){

            public Object getValue() {
                return ParameterWindow.this.dataModel.getName();
            }

            public void setValue(Object value) {
                String name;
                String string = name = value == null ? null : value.toString();
                if (name.trim().length() == 0) {
                    name = null;
                }
                ParameterWindow.this.dataModel.setName(name);
            }
        };
        this.params.addPseudoParameter(nameParam);
        URL url = this.dataModel.getBaseTable().getURL();
        if (url != null) {
            DescribedValue urlParam = new DescribedValue(URL_INFO, (Object)url);
            this.params.addPseudoParameter(urlParam);
            this.uneditableParams.add(urlParam);
        }
        this.ncolParam = new DescribedValue(NCOL_INFO);
        this.nrowParam = new DescribedValue(NROW_INFO);
        this.params.addPseudoParameter(this.ncolParam);
        this.params.addPseudoParameter(this.nrowParam);
        this.uneditableParams.add(this.ncolParam);
        this.uneditableParams.add(this.nrowParam);
        this.columnModel.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                ParameterWindow.this.configureColumnCount();
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                ParameterWindow.this.configureColumnCount();
            }
        });
        this.viewModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent evt) {
                ParameterWindow.this.configureRowCount();
            }
        });
        this.ncolRowIndex = this.params.indexOf(this.ncolParam);
        this.nrowRowIndex = this.params.indexOf(this.nrowParam);
        ArrayList<MetaColumn> metas = new ArrayList<MetaColumn>();
        metas.add(new MetaColumn(NAME_NAME, String.class){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getName();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParam(irow).getInfo() instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParam(irow).getInfo()).setName(value.toString());
            }
        });
        metas.add(new MetaColumn(VALUE_NAME, Object.class){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParam(irow).getValueAsString(64);
            }

            public boolean isEditable(int irow) {
                if (ParameterWindow.this.isEditableParameter(irow)) {
                    Class clazz;
                    return (class$java$lang$Number == null ? (class$java$lang$Number = ParameterWindow.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz = ParameterWindow.this.getParam(irow).getInfo().getContentClass()) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterWindow.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz) || (class$java$lang$String == null ? (class$java$lang$String = ParameterWindow.class$("java.lang.String")) : class$java$lang$String).equals(clazz);
                }
                return false;
            }

            public void setValue(int irow, Object value) {
                DescribedValue param = ParameterWindow.this.getParam(irow);
                try {
                    if (value == null) {
                        param.setValue(null);
                    } else if (value instanceof String) {
                        param.setValueFromString((String)value);
                    } else if (param.getInfo().getContentClass().isAssignableFrom(value.getClass())) {
                        param.setValue(value);
                    } else {
                        param.setValueFromString(value.toString());
                    }
                }
                catch (RuntimeException e) {
                    String msg = "Invalid value \"" + value + "\"";
                    JOptionPane.showMessageDialog(ParameterWindow.this, msg, "Invalid Parameter Value", 0);
                }
            }
        });
        int classPos = metas.size();
        metas.add(new MetaColumn(CLASS_NAME, String.class){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatClass((Class)ParameterWindow.this.getParamInfo(irow).getContentClass());
            }
        });
        metas.add(new MetaColumn(SHAPE_NAME, String.class){

            public Object getValue(int irow) {
                return DefaultValueInfo.formatShape((int[])ParameterWindow.this.getParamInfo(irow).getShape());
            }
        });
        int sizePos = metas.size();
        metas.add(new MetaColumn(ELSIZE_NAME, Integer.class){

            public Object getValue(int irow) {
                int size = ParameterWindow.this.getParamInfo(irow).getElementSize();
                return size > 0 ? new Integer(size) : null;
            }

            public boolean isEditable(int irow) {
                return ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                int size;
                if (value instanceof Number) {
                    size = ((Number)value).intValue();
                } else if (value instanceof String) {
                    try {
                        size = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        size = -1;
                    }
                } else {
                    size = -1;
                }
                if (size <= 0) {
                    size = -1;
                }
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setElementSize(size);
            }
        });
        metas.add(new MetaColumn(UNITS_NAME, String.class){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getUnitString();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setUnitString(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn(DESC_NAME, String.class){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getDescription();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setDescription(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn(UCD_NAME, String.class){

            public Object getValue(int irow) {
                return ParameterWindow.this.getParamInfo(irow).getUCD();
            }

            public boolean isEditable(int irow) {
                return !ParameterWindow.this.isPseudoParameter(irow) && ParameterWindow.this.getParamInfo(irow) instanceof DefaultValueInfo;
            }

            public void setValue(int irow, Object value) {
                ((DefaultValueInfo)ParameterWindow.this.getParamInfo(irow)).setUCD(value == null ? null : value.toString());
            }
        });
        metas.add(new MetaColumn(UCDDESC_NAME, String.class){

            public Object getValue(int irow) {
                UCD ucd;
                String ucdid = ParameterWindow.this.getParamInfo(irow).getUCD();
                if (ucdid != null && (ucd = UCD.getUCD((String)ucdid)) != null) {
                    return ucd.getDescription();
                }
                return null;
            }
        });
        this.metaTableModel = new MetaColumnTableModel(metas){

            public int getRowCount() {
                return ParameterWindow.this.params.size();
            }
        };
        JTable jtab = new JTable(this.metaTableModel);
        jtab.setAutoResizeMode(0);
        jtab.setColumnSelectionAllowed(false);
        jtab.setRowSelectionAllowed(true);
        this.rowSelectionModel = jtab.getSelectionModel();
        this.rowSelectionModel.setSelectionMode(2);
        this.rowSelectionModel.addListSelectionListener(this);
        StarJTable.configureColumnWidths((JTable)jtab, (int)20000, (int)100);
        MetaColumnModel metaColumnModel = new MetaColumnModel(jtab.getColumnModel(), this.metaTableModel);
        metaColumnModel.purgeEmptyColumns();
        jtab.setColumnModel(metaColumnModel);
        metaColumnModel.removeColumn(classPos);
        metaColumnModel.removeColumn(sizePos);
        this.configureColumnCount();
        this.configureRowCount();
        JSplitPane splitter = new JSplitPane(0);
        splitter.setOneTouchExpandable(true);
        this.getMainArea().add(splitter);
        splitter.setTopComponent(new SizingScrollPane(jtab));
        this.detailPanel = new ParameterDetailPanel(this.metaTableModel);
        splitter.setBottomComponent(this.detailPanel);
        BasicAction addAct = new BasicAction("New Parameter", ResourceIcon.ADD, "Add a new parameter"){

            public void actionPerformed(ActionEvent evt) {
                ParameterWindow paramWindow = ParameterWindow.this;
                new ParameterQueryWindow(paramWindow.tcModel, (Component)paramWindow).setVisible(true);
            }
        };
        this.getToolBar().add(addAct);
        this.removeAct = new BasicAction("Remove Parameter", ResourceIcon.DELETE, "Delete the selected parameter"){

            public void actionPerformed(ActionEvent evt) {
                TopcatModel tcm = ParameterWindow.this.tcModel;
                ArrayList<DescribedValue> removals = new ArrayList<DescribedValue>();
                for (int irow = ParameterWindow.this.rowSelectionModel.getMinSelectionIndex(); irow <= ParameterWindow.this.rowSelectionModel.getMaxSelectionIndex(); ++irow) {
                    if (!ParameterWindow.this.rowSelectionModel.isSelectedIndex(irow)) continue;
                    DescribedValue dval = ParameterWindow.this.getParam(irow);
                    if (tcm.getDataModel().getParameters().contains(dval)) {
                        removals.add(dval);
                        continue;
                    }
                    logger.warning("Parameter \"" + dval + "\" missing from model??");
                }
                Iterator it = removals.iterator();
                while (it.hasNext()) {
                    tcm.removeParameter((DescribedValue)it.next());
                }
            }
        };
        this.removeAct.setEnabled(false);
        this.getToolBar().add(this.removeAct);
        this.getToolBar().addSeparator();
        JMenu paramMenu = new JMenu("Parameters");
        paramMenu.setMnemonic(80);
        paramMenu.add(addAct);
        paramMenu.add(this.removeAct);
        this.getJMenuBar().add(paramMenu);
        JMenu displayMenu = metaColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        this.addHelp("ParameterWindow");
    }

    private DescribedValue getParam(int irow) {
        return (DescribedValue)this.params.get(irow);
    }

    private ValueInfo getParamInfo(int irow) {
        return this.getParam(irow).getInfo();
    }

    private boolean isPseudoParameter(int irow) {
        return this.params.isPseudoParam(irow);
    }

    private boolean isEditableParameter(int irow) {
        return !this.uneditableParams.contains(this.getParam(irow));
    }

    private void configureColumnCount() {
        this.ncolParam.setValue((Object)new Integer(this.columnModel.getColumnCount()));
        this.metaTableModel.fireTableRowsUpdated(this.ncolRowIndex, this.ncolRowIndex);
    }

    private void configureRowCount() {
        this.nrowParam.setValue((Object)new Long(this.viewModel.getRowCount()));
        this.metaTableModel.fireTableRowsUpdated(this.nrowRowIndex, this.nrowRowIndex);
    }

    public void modelChanged(TopcatEvent evt) {
        if (evt.getCode() == 3) {
            this.metaTableModel.fireTableDataChanged();
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.rowSelectionModel) {
            int index = this.rowSelectionModel.getMinSelectionIndex();
            boolean active = index >= 0;
            for (int i = this.rowSelectionModel.getMinSelectionIndex(); i <= this.rowSelectionModel.getMaxSelectionIndex(); ++i) {
                if (!this.rowSelectionModel.isSelectedIndex(i)) continue;
                active = active && !this.params.isPseudoParam(index);
            }
            this.removeAct.setEnabled(active);
            this.detailPanel.setItem(index, (DescribedValue)(index >= 0 ? this.params.get(index) : null));
        }
    }

    private static class ParamList
    extends AbstractList {
        private final List pseudoParams;
        private final List normalParams;

        ParamList(List normalParams) {
            this.normalParams = normalParams;
            this.pseudoParams = new ArrayList();
        }

        public void addPseudoParameter(DescribedValue dval) {
            this.pseudoParams.add(dval);
        }

        public int size() {
            return this.pseudoParams.size() + this.normalParams.size();
        }

        public Object get(int index) {
            return this.isPseudoParam(index) ? this.pseudoParams.get(index) : this.normalParams.get(index - this.pseudoParams.size());
        }

        public boolean isPseudoParam(int index) {
            return index < this.pseudoParams.size();
        }
    }
}

