/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.IOException;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.TopcatUtils;

public class PlasticStarTable
extends ColumnStarTable {
    private long nrow;
    private final StarTable baseTable;

    public PlasticStarTable(final StarTable baseTable) {
        super(baseTable);
        this.baseTable = baseTable;
        if (!baseTable.isRandom()) {
            throw new IllegalArgumentException("Table " + baseTable + " does not have random access");
        }
        this.nrow = baseTable.getRowCount();
        if (this.nrow < 0L) {
            throw new IllegalArgumentException("Random table has negative number of rows " + this.nrow);
        }
        int icol = 0;
        while (icol < baseTable.getColumnCount()) {
            ColumnInfo colinfo = baseTable.getColumnInfo(icol);
            final int ficol = icol++;
            ColumnData coldat = new ColumnData(colinfo){

                public Object readValue(long lrow) throws IOException {
                    return baseTable.getCell(lrow, ficol);
                }
            };
            this.addColumn(coldat);
        }
    }

    public long getRowCount() {
        return this.nrow;
    }

    public void addColumn(ColumnData coldata) {
        String colid = '$' + Integer.toString(this.getColumnCount() + 1);
        coldata.getColumnInfo().setAuxDatum(new DescribedValue(TopcatUtils.COLID_INFO, (Object)colid));
        super.addColumn(coldata);
    }

    public void setColumn(int icol, ColumnData coldata) {
        String colid = '$' + Integer.toString(icol + 1);
        coldata.getColumnInfo().setAuxDatum(new DescribedValue(TopcatUtils.COLID_INFO, (Object)colid));
        super.setColumn(icol, coldata);
    }

    public StarTable getBaseTable() {
        return this.baseTable;
    }
}

