/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import uk.ac.starlink.topcat.interop.TopcatServer;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.SphereWindow;
import uk.ac.starlink.ttools.plot.ErrorMode;

public class ResourceIcon
implements Icon {
    private static Component dummyComponent_;
    public static final String PREFIX = "images/";
    public static final ImageIcon DO_WHAT;
    public static final ImageIcon TOPCAT;
    public static final ImageIcon STARLINK;
    public static final ImageIcon TABLE;
    public static final ImageIcon TOPCAT_LOGO;
    public static final ImageIcon TOPCAT_LOGO_SMALL;
    public static final ImageIcon STAR_LOGO;
    public static final ImageIcon ASTROGRID_LOGO;
    public static final ImageIcon BRISTOL_LOGO;
    public static final ImageIcon VOTECH_LOGO;
    public static final ImageIcon CLOSE;
    public static final ImageIcon EXIT;
    public static final ImageIcon LOAD;
    public static final ImageIcon SAVE;
    public static final ImageIcon IMPORT;
    public static final ImageIcon PRINT;
    public static final ImageIcon IMAGE;
    public static final ImageIcon FITS;
    public static final ImageIcon COPY;
    public static final ImageIcon REDO;
    public static final ImageIcon ADD;
    public static final ImageIcon SUBTRACT;
    public static final ImageIcon DELETE;
    public static final ImageIcon HELP;
    public static final ImageIcon HELP_BROWSER;
    public static final ImageIcon DEMO;
    public static final ImageIcon HIDE;
    public static final ImageIcon REVEAL;
    public static final ImageIcon HIDE_ALL;
    public static final ImageIcon REVEAL_ALL;
    public static final ImageIcon MODIFY;
    public static final ImageIcon SEARCH;
    public static final ImageIcon LOG;
    public static final ImageIcon CLEAR;
    public static final ImageIcon HIDE_WINDOWS;
    public static final ImageIcon CONTROL;
    public static final ImageIcon COLUMNS;
    public static final ImageIcon STATS;
    public static final ImageIcon HISTOGRAM;
    public static final ImageIcon CUMULATIVE;
    public static final ImageIcon NORMALISE;
    public static final ImageIcon PLOT;
    public static final ImageIcon DENSITY;
    public static final ImageIcon PLOT3D;
    public static final ImageIcon SPHERE;
    public static final ImageIcon STACK;
    public static final ImageIcon PARAMS;
    public static final ImageIcon VIEWER;
    public static final ImageIcon SUBSETS;
    public static final ImageIcon FUNCTION;
    public static final ImageIcon MATCH1;
    public static final ImageIcon MATCH2;
    public static final ImageIcon MATCHN;
    public static final ImageIcon CONCAT;
    public static final ImageIcon SAMP;
    public static final ImageIcon UNSORT;
    public static final ImageIcon DELETE_COLUMN;
    public static final ImageIcon VISIBLE_SUBSET;
    public static final ImageIcon RANGE_SUBSET;
    public static final ImageIcon XRANGE_SUBSET;
    public static final ImageIcon BLOB_SUBSET;
    public static final ImageIcon BLOB_SUBSET_END;
    public static final ImageIcon RESIZE;
    public static final ImageIcon RESIZE_X;
    public static final ImageIcon RESIZE_Y;
    public static final ImageIcon GRID_ON;
    public static final ImageIcon GRID_OFF;
    public static final ImageIcon Y_CURSOR;
    public static final ImageIcon Y0_LINE;
    public static final ImageIcon TO_COLUMN;
    public static final ImageIcon COUNT;
    public static final ImageIcon RECOUNT;
    public static final ImageIcon INVERT;
    public static final ImageIcon HEAD;
    public static final ImageIcon TAIL;
    public static final ImageIcon SAMPLE;
    public static final ImageIcon INCLUDE_ROWS;
    public static final ImageIcon EXCLUDE_ROWS;
    public static final ImageIcon UP;
    public static final ImageIcon DOWN;
    public static final ImageIcon UP_TRIM;
    public static final ImageIcon DOWN_TRIM;
    public static final ImageIcon EQUATION;
    public static final ImageIcon EXPLODE;
    public static final ImageIcon ADDSKY;
    public static final ImageIcon COLOR_LOG;
    public static final ImageIcon XLOG;
    public static final ImageIcon YLOG;
    public static final ImageIcon XFLIP;
    public static final ImageIcon YFLIP;
    public static final ImageIcon XYZ;
    public static final ImageIcon FOG;
    public static final ImageIcon ANTIALIAS;
    public static final ImageIcon COLOR;
    public static final ImageIcon FINE;
    public static final ImageIcon ROUGH;
    public static final ImageIcon AXIS_EDIT;
    public static final ImageIcon BROADCAST;
    public static final ImageIcon SEND;
    public static final ImageIcon ADD_TAB;
    public static final ImageIcon REMOVE_TAB;
    public static final ImageIcon ADD_COLORS;
    public static final ImageIcon REMOVE_COLORS;
    public static final ImageIcon NORTH;
    public static final ImageIcon WEIGHT;
    public static final ImageIcon JPEG;
    public static final ImageIcon SPLIT;
    public static final ImageIcon FORWARD;
    public static final ImageIcon BACKWARD;
    public static final ImageIcon PAGE_SETUP;
    public static final ImageIcon MANUAL;
    public static final ImageIcon MANUAL_BROWSER;
    public static final ImageIcon MANUAL1_BROWSER;
    public static final ImageIcon LEGEND;
    public static final ImageIcon LABEL;
    public static final ImageIcon RADIAL;
    public static final ImageIcon CONNECT;
    public static final ImageIcon DISCONNECT;
    public static final ImageIcon SMALL_DEC;
    public static final ImageIcon SMALL_INC;
    public static final ImageIcon COLLAPSED;
    public static final ImageIcon EXPANDED;
    public static final ImageIcon HOME;
    public static final ImageIcon TV_UP;
    public static final ImageIcon TV_DOWN;
    public static final ImageIcon FOLDER_NODE;
    public static final ImageIcon LIBRARY_NODE;
    public static final ImageIcon FUNCTION_NODE;
    public static final ImageIcon CONSTANT_NODE;
    public static final ImageIcon dummy;
    private String location;
    private Icon baseIcon;
    private Boolean resourceFound;
    static /* synthetic */ Class class$javax$swing$Icon;

    private ResourceIcon(String location) {
        this.location = location;
    }

    private Icon getBaseIcon() {
        if (this.baseIcon == null) {
            this.baseIcon = this.readBaseIcon();
        }
        return this.baseIcon;
    }

    public int getIconHeight() {
        return this.getBaseIcon().getIconHeight();
    }

    public int getIconWidth() {
        return this.getBaseIcon().getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getBaseIcon().paintIcon(c, g, x, y);
    }

    public Image getImage() {
        Icon icon = this.getBaseIcon();
        return icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
    }

    public URL getURL() {
        return this.getClass().getResource(PREFIX + this.location);
    }

    public URL getExternalURL() throws IOException {
        return new URL(TopcatServer.getInstance().getTopcatPackageUrl(), PREFIX + this.location);
    }

    private Icon readBaseIcon() {
        Icon icon = null;
        URL resource = this.getURL();
        if (resource != null) {
            try {
                int datum;
                InputStream istrm = resource.openStream();
                istrm = new BufferedInputStream(istrm);
                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                while ((datum = istrm.read()) > -1) {
                    ostrm.write(datum);
                }
                istrm.close();
                ostrm.close();
                icon = new ImageIcon(ostrm.toByteArray());
                this.resourceFound = Boolean.TRUE;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = ResourceIcon.dummyIcon();
            this.resourceFound = Boolean.FALSE;
        }
        return icon;
    }

    private static Icon dummyIcon() {
        return new MetalCheckBoxIcon();
    }

    private static Component getDummyComponent() {
        if (dummyComponent_ == null) {
            dummyComponent_ = new JPanel();
        }
        return dummyComponent_;
    }

    public static void checkResourcesPresent() throws FileNotFoundException {
        ArrayList<String> notFound = new ArrayList<String>();
        Iterator it = ResourceIcon.getMemberNameMap().entrySet().iterator();
        while (it.hasNext()) {
            ResourceIcon icon = (ResourceIcon)it.next().getValue();
            icon.readBaseIcon();
            if (icon.resourceFound.booleanValue()) continue;
            notFound.add(icon.location);
        }
        if (notFound.size() > 0) {
            StringBuffer msg = new StringBuffer().append("Resource files not found:");
            Iterator it2 = notFound.iterator();
            while (it2.hasNext()) {
                msg.append(' ').append(it2.next());
            }
            throw new FileNotFoundException(msg.toString());
        }
    }

    public static void writeHelpMapXML(OutputStream ostrm, String prefix) {
        PrintStream pstrm = ostrm instanceof PrintStream ? (PrintStream)ostrm : new PrintStream(ostrm);
        pstrm.println("<?xml version='1.0'?>");
        pstrm.println("<!DOCTYPE map");
        pstrm.println("  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\"");
        pstrm.println("         \"http://java.sun.com/products/javahelp/map_1_0.dtd\">");
        pstrm.println("\n<!-- Automatically generated by " + ResourceIcon.class.getName() + " -->");
        pstrm.println("\n<map version='1.0'>");
        Map iconMap = ResourceIcon.getMemberNameMap();
        ArrayList iconList = new ArrayList(iconMap.keySet());
        Collections.sort(iconList);
        Iterator it = iconList.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ResourceIcon icon = (ResourceIcon)iconMap.get(name);
            String mapID = "  <mapID target='" + name + "'" + " url='" + prefix + PREFIX + icon.location + "'/>";
            pstrm.println(mapID);
        }
        pstrm.println("</map>");
    }

    private static Map getMemberNameMap() {
        HashMap<String, ResourceIcon> nameMap = new HashMap<String, ResourceIcon>();
        Field[] fields = ResourceIcon.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Icon icon;
            Field field = fields[i];
            int mods = field.getModifiers();
            String name = field.getName();
            if (!(class$javax$swing$Icon == null ? ResourceIcon.class$("javax.swing.Icon") : class$javax$swing$Icon).isAssignableFrom(field.getType()) || !Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || !name.equals(name.toUpperCase())) continue;
            try {
                icon = (Icon)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            ResourceIcon ricon = null;
            if (icon instanceof ResourceIcon) {
                ricon = (ResourceIcon)icon;
            } else if (icon instanceof ResourceImageIcon) {
                ricon = ((ResourceImageIcon)icon).getResourceIcon();
            }
            if (ricon == null) continue;
            nameMap.put(name, ricon);
        }
        return nameMap;
    }

    private static Map getDiyIconMap() {
        HashMap<String, Icon> nameMap = new HashMap<String, Icon>();
        ErrorModeSelectionModel errX = new ErrorModeSelectionModel(0, "X");
        ErrorModeSelectionModel errY = new ErrorModeSelectionModel(1, "Y");
        ErrorModeSelectionModel errZ = new ErrorModeSelectionModel(2, "Z");
        nameMap.put("ERROR_X", errX.createOnOffButton().getIcon());
        nameMap.put("ERROR_Y", errY.createOnOffButton().getIcon());
        nameMap.put("ERROR_Z", errZ.createOnOffButton().getIcon());
        nameMap.put("ERROR_TANGENT", SphereWindow.createTangentErrorIcon());
        nameMap.put("ERROR_NONE", errX.getIcon(ErrorMode.NONE, 24, 24, 1, 1));
        nameMap.put("ERROR_SYMMETRIC", errX.getIcon(ErrorMode.SYMMETRIC, 24, 24, 1, 1));
        nameMap.put("ERROR_LOWER", errX.getIcon(ErrorMode.LOWER, 24, 24, 1, 1));
        nameMap.put("ERROR_UPPER", errX.getIcon(ErrorMode.UPPER, 24, 24, 1, 1));
        nameMap.put("ERROR_BOTH", errX.getIcon(ErrorMode.BOTH, 24, 24, 1, 1));
        return nameMap;
    }

    private static ImageIcon makeIcon(String location) {
        return new ResourceImageIcon(new ResourceIcon(location));
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(ResourceIcon.createImage(icon));
    }

    private static BufferedImage createImage(Icon icon) {
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = image.createGraphics();
        Color color = g2.getColor();
        Composite compos = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(2));
        g2.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.fillRect(0, 0, w, h);
        g2.setColor(color);
        g2.setComposite(compos);
        icon.paintIcon(ResourceIcon.getDummyComponent(), g2, 0, 0);
        g2.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGif(Icon icon, File file) throws IOException {
        OutputStream out = new FileOutputStream(file);
        try {
            out = new BufferedOutputStream(out);
            new GifEncoder((Image)ResourceIcon.createImage(icon), out).encode();
        }
        finally {
            out.close();
        }
    }

    public static void main(String[] args) throws IOException {
        String mode;
        String string = mode = args.length == 1 ? args[0] : null;
        if ("-map".equals(mode)) {
            ResourceIcon.writeHelpMapXML(System.out, "../");
        } else if ("-files".equals(mode)) {
            Map iconMap = ResourceIcon.getMemberNameMap();
            Iterator it = iconMap.keySet().iterator();
            while (it.hasNext()) {
                ResourceIcon icon = (ResourceIcon)iconMap.get(it.next());
                System.out.println(icon.location);
            }
        } else if ("-entities".equals(mode)) {
            Map iconMap = ResourceIcon.getMemberNameMap();
            String t1 = "  <!ENTITY IMG.";
            String t2 = " '<img src=\"../images/";
            String t3 = "\"/>'>";
            Iterator it = iconMap.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                ResourceIcon icon = (ResourceIcon)iconMap.get(name);
                System.out.println(t1 + name + t2 + icon.location + t3);
            }
            Map diyMap = ResourceIcon.getDiyIconMap();
            Iterator it2 = diyMap.keySet().iterator();
            while (it2.hasNext()) {
                String name = (String)it2.next();
                System.out.println(t1 + name + t2 + name + ".gif" + t3);
            }
        } else if ("-writegifs".equals(mode)) {
            Map diyMap = ResourceIcon.getDiyIconMap();
            Iterator it = diyMap.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Icon icon = (Icon)diyMap.get(name);
                ResourceIcon.writeGif(icon, new File(name + ".gif"));
            }
        } else {
            String usage = "Usage: ResourceIcon [-map|-files|-entities|-writegifs]";
            System.err.println(usage);
            System.exit(1);
        }
    }

    static {
        DO_WHAT = ResourceIcon.makeIcon("burst.gif");
        TOPCAT = ResourceIcon.makeIcon("TopCat2.gif");
        STARLINK = ResourceIcon.makeIcon("starlinklogo3.gif");
        TABLE = ResourceIcon.makeIcon("browser1.gif");
        TOPCAT_LOGO = ResourceIcon.makeIcon("tc3.gif");
        TOPCAT_LOGO_SMALL = ResourceIcon.makeIcon("tc3_24.gif");
        STAR_LOGO = ResourceIcon.makeIcon("starlink48.gif");
        ASTROGRID_LOGO = ResourceIcon.makeIcon("ag48.gif");
        BRISTOL_LOGO = ResourceIcon.makeIcon("bris48.gif");
        VOTECH_LOGO = ResourceIcon.makeIcon("votech48.gif");
        CLOSE = ResourceIcon.makeIcon("multiply4.gif");
        EXIT = ResourceIcon.makeIcon("exit.gif");
        LOAD = ResourceIcon.makeIcon("Open24.gif");
        SAVE = ResourceIcon.makeIcon("Save24.gif");
        IMPORT = ResourceIcon.makeIcon("browser1.gif");
        PRINT = ResourceIcon.makeIcon("Print24.gif");
        IMAGE = ResourceIcon.makeIcon("picture.gif");
        FITS = ResourceIcon.makeIcon("fits1.gif");
        COPY = ResourceIcon.makeIcon("Copy24.gif");
        REDO = ResourceIcon.makeIcon("Redo24.gif");
        ADD = ResourceIcon.makeIcon("Plus1.gif");
        SUBTRACT = ResourceIcon.makeIcon("Minus1.gif");
        DELETE = ResourceIcon.makeIcon("trash2.gif");
        HELP = ResourceIcon.makeIcon("Help3.gif");
        HELP_BROWSER = ResourceIcon.makeIcon("Help3b.gif");
        DEMO = ResourceIcon.makeIcon("demo.gif");
        HIDE = ResourceIcon.makeIcon("false.gif");
        REVEAL = ResourceIcon.makeIcon("true.gif");
        HIDE_ALL = ResourceIcon.makeIcon("falseAll2.gif");
        REVEAL_ALL = ResourceIcon.makeIcon("trueAll2.gif");
        MODIFY = ResourceIcon.makeIcon("redo3.gif");
        SEARCH = ResourceIcon.makeIcon("search2.gif");
        LOG = ResourceIcon.makeIcon("book3.gif");
        CLEAR = ResourceIcon.makeIcon("newdoc1.gif");
        HIDE_WINDOWS = ResourceIcon.makeIcon("hide1.gif");
        CONTROL = ResourceIcon.makeIcon("controlw.gif");
        COLUMNS = ResourceIcon.makeIcon("colmeta0.gif");
        STATS = ResourceIcon.makeIcon("sigma0.gif");
        HISTOGRAM = ResourceIcon.makeIcon("hist0.gif");
        CUMULATIVE = ResourceIcon.makeIcon("cum0.gif");
        NORMALISE = ResourceIcon.makeIcon("hnorm1.gif");
        PLOT = ResourceIcon.makeIcon("plot0.gif");
        DENSITY = ResourceIcon.makeIcon("2hist2.gif");
        PLOT3D = ResourceIcon.makeIcon("3dax6.gif");
        SPHERE = ResourceIcon.makeIcon("sphere2.gif");
        STACK = ResourceIcon.makeIcon("stack1.gif");
        PARAMS = ResourceIcon.makeIcon("tablemeta0.gif");
        VIEWER = ResourceIcon.makeIcon("browser1.gif");
        SUBSETS = ResourceIcon.makeIcon("venn2.gif");
        FUNCTION = ResourceIcon.makeIcon("fx2.gif");
        MATCH1 = ResourceIcon.makeIcon("matchOne2.gif");
        MATCH2 = ResourceIcon.makeIcon("matchTwo2.gif");
        MATCHN = ResourceIcon.makeIcon("matchN.gif");
        CONCAT = ResourceIcon.makeIcon("concat4.gif");
        SAMP = ResourceIcon.makeIcon("comms2.gif");
        UNSORT = ResourceIcon.makeIcon("arrow_level.gif");
        DELETE_COLUMN = ResourceIcon.makeIcon("ColumnDelete24.gif");
        VISIBLE_SUBSET = ResourceIcon.makeIcon("spoints5.gif");
        RANGE_SUBSET = ResourceIcon.makeIcon("sbars0.gif");
        XRANGE_SUBSET = ResourceIcon.makeIcon("xrange1.gif");
        BLOB_SUBSET = ResourceIcon.makeIcon("blob2.gif");
        BLOB_SUBSET_END = ResourceIcon.makeIcon("ublob3b.gif");
        RESIZE = ResourceIcon.makeIcon("4way3.gif");
        RESIZE_X = ResourceIcon.makeIcon("ew_arrow.gif");
        RESIZE_Y = ResourceIcon.makeIcon("ns_arrow.gif");
        GRID_ON = ResourceIcon.makeIcon("gridon.gif");
        GRID_OFF = ResourceIcon.makeIcon("gridoff.gif");
        Y_CURSOR = ResourceIcon.makeIcon("vline0.gif");
        Y0_LINE = ResourceIcon.makeIcon("y0line1.gif");
        TO_COLUMN = ResourceIcon.makeIcon("Column.gif");
        COUNT = ResourceIcon.makeIcon("ab3.gif");
        RECOUNT = ResourceIcon.makeIcon("re-ab3.gif");
        INVERT = ResourceIcon.makeIcon("invert3.gif");
        HEAD = ResourceIcon.makeIcon("head.gif");
        TAIL = ResourceIcon.makeIcon("tail.gif");
        SAMPLE = ResourceIcon.makeIcon("sample.gif");
        INCLUDE_ROWS = ResourceIcon.makeIcon("selrows3.gif");
        EXCLUDE_ROWS = ResourceIcon.makeIcon("exrows.gif");
        UP = ResourceIcon.makeIcon("arrow_n_pad.gif");
        DOWN = ResourceIcon.makeIcon("arrow_s_pad.gif");
        UP_TRIM = ResourceIcon.makeIcon("arrow_n.gif");
        DOWN_TRIM = ResourceIcon.makeIcon("arrow_s.gif");
        EQUATION = ResourceIcon.makeIcon("xeq.gif");
        EXPLODE = ResourceIcon.makeIcon("explode.gif");
        ADDSKY = ResourceIcon.makeIcon("addsky1.gif");
        COLOR_LOG = ResourceIcon.makeIcon("logred2.gif");
        XLOG = ResourceIcon.makeIcon("xlog.gif");
        YLOG = ResourceIcon.makeIcon("ylog.gif");
        XFLIP = ResourceIcon.makeIcon("xflip.gif");
        YFLIP = ResourceIcon.makeIcon("yflip.gif");
        XYZ = ResourceIcon.makeIcon("xyz.gif");
        FOG = ResourceIcon.makeIcon("fog1.gif");
        ANTIALIAS = ResourceIcon.makeIcon("aaA4.gif");
        COLOR = ResourceIcon.makeIcon("rgb.gif");
        FINE = ResourceIcon.makeIcon("smallpix.gif");
        ROUGH = ResourceIcon.makeIcon("bigpix2.gif");
        AXIS_EDIT = ResourceIcon.makeIcon("axed3.gif");
        BROADCAST = ResourceIcon.makeIcon("tx3.gif");
        SEND = ResourceIcon.makeIcon("phone2.gif");
        ADD_TAB = ResourceIcon.makeIcon("atab3.gif");
        REMOVE_TAB = ResourceIcon.makeIcon("rtab3.gif");
        ADD_COLORS = ResourceIcon.makeIcon("acolour1.gif");
        REMOVE_COLORS = ResourceIcon.makeIcon("rcolour1.gif");
        NORTH = ResourceIcon.makeIcon("north2.gif");
        WEIGHT = ResourceIcon.makeIcon("weight6.gif");
        JPEG = ResourceIcon.makeIcon("jpeg1.gif");
        SPLIT = ResourceIcon.makeIcon("split4.gif");
        FORWARD = ResourceIcon.makeIcon("Forward24.gif");
        BACKWARD = ResourceIcon.makeIcon("Back24.gif");
        PAGE_SETUP = ResourceIcon.makeIcon("PageSetup24.gif");
        MANUAL = ResourceIcon.makeIcon("book1.gif");
        MANUAL_BROWSER = ResourceIcon.makeIcon("book1b.gif");
        MANUAL1_BROWSER = ResourceIcon.makeIcon("scroll1b.gif");
        LEGEND = ResourceIcon.makeIcon("legend3.gif");
        LABEL = ResourceIcon.makeIcon("label2.gif");
        RADIAL = ResourceIcon.makeIcon("clock1.gif");
        CONNECT = ResourceIcon.makeIcon("connected-24.gif");
        DISCONNECT = ResourceIcon.makeIcon("disconnected-24.gif");
        SMALL_DEC = ResourceIcon.makeIcon("dec.gif");
        SMALL_INC = ResourceIcon.makeIcon("inc.gif");
        COLLAPSED = ResourceIcon.makeIcon("handle1.gif");
        EXPANDED = ResourceIcon.makeIcon("handle2.gif");
        HOME = ResourceIcon.makeIcon("Home24.gif");
        TV_UP = ResourceIcon.makeIcon("Up.gif");
        TV_DOWN = ResourceIcon.makeIcon("Down.gif");
        FOLDER_NODE = ResourceIcon.makeIcon("folder_node.gif");
        LIBRARY_NODE = ResourceIcon.makeIcon("book_leaf.gif");
        FUNCTION_NODE = ResourceIcon.makeIcon("fx_leaf.gif");
        CONSTANT_NODE = ResourceIcon.makeIcon("c_leaf.gif");
        dummy = DO_WHAT;
    }

    private static class ResourceImageIcon
    extends ImageIcon {
        ResourceIcon resourceIcon;

        ResourceImageIcon(ResourceIcon resourceIcon) {
            this.resourceIcon = resourceIcon;
        }

        public ResourceIcon getResourceIcon() {
            return this.resourceIcon;
        }

        protected void loadImage() {
        }

        public int getImageLoadStatus() {
            return 8;
        }

        public Image getImage() {
            return this.resourceIcon.getImage();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.resourceIcon.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.resourceIcon.getIconWidth();
        }

        public int getIconHeight() {
            return this.resourceIcon.getIconHeight();
        }
    }
}

