/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.ColumnComboBoxModel;

public abstract class RestrictedColumnComboBoxModel
extends ColumnComboBoxModel {
    private TableColumnModel colModel;
    private boolean hasNone;
    private List activeColumns;
    private List modelColumns;

    public RestrictedColumnComboBoxModel(TableColumnModel colModel, boolean hasNone) {
        super(colModel, hasNone);
        this.colModel = colModel;
        this.hasNone = hasNone;
        this.activeColumns = new ArrayList();
        this.modelColumns = new ArrayList();
        if (hasNone) {
            this.activeColumns.add(NO_COLUMN);
        }
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn tcol = colModel.getColumn(i);
            this.modelColumns.add(tcol);
            if (!this.acceptColumn(tcol)) continue;
            this.activeColumns.add(tcol);
        }
    }

    public abstract boolean acceptColumn(ColumnInfo var1);

    private boolean acceptColumn(TableColumn tcol) {
        return tcol instanceof StarTableColumn && this.acceptColumn(((StarTableColumn)tcol).getColumnInfo());
    }

    public Object getElementAt(int index) {
        return this.activeColumns.get(index);
    }

    public int getSize() {
        return this.activeColumns.size();
    }

    public void columnAdded(TableColumnModelEvent evt) {
        int index = evt.getToIndex();
        TableColumn tcol = this.colModel.getColumn(index);
        this.modelColumns.add(tcol);
        if (this.acceptColumn(tcol)) {
            int pos = this.activeColumns.size();
            this.activeColumns.add(tcol);
            this.fireIntervalAdded(this, pos, pos);
        }
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        int index = evt.getFromIndex();
        TableColumn tcol = (TableColumn)this.modelColumns.get(index);
        this.modelColumns.remove(tcol);
        int pos = this.activeColumns.indexOf(tcol);
        if (pos >= 0) {
            this.activeColumns.remove(pos);
            this.fireIntervalRemoved(this, pos, pos);
        }
    }

    public void columnMoved(TableColumnModelEvent evt) {
        int from = evt.getFromIndex();
        TableColumn tcol = (TableColumn)this.modelColumns.get(from);
        if (this.activeColumns.contains(tcol)) {
            List oldActive = this.activeColumns;
            this.activeColumns = new ArrayList();
            this.modelColumns = new ArrayList();
            if (this.hasNone) {
                this.activeColumns.add(NO_COLUMN);
            }
            for (int i = 0; i < this.colModel.getColumnCount(); ++i) {
                TableColumn tc = this.colModel.getColumn(i);
                this.modelColumns.add(tc);
                if (!oldActive.contains(tc)) continue;
                this.activeColumns.add(tc);
            }
            int index0 = this.hasNone ? 1 : 0;
            int index1 = this.activeColumns.size() - 1;
            this.fireContentsChanged(this, index0, index1);
        }
    }

    public static RestrictedColumnComboBoxModel makeClassColumnComboBoxModel(TableColumnModel colModel, boolean hasNone, Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            clazz = Number.class;
        }
        final Class effClazz = clazz;
        return new RestrictedColumnComboBoxModel(colModel, hasNone){

            public boolean acceptColumn(ColumnInfo colInfo) {
                return effClazz.isAssignableFrom(colInfo.getContentClass());
            }
        };
    }
}

