/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.gui.TableSaveChooser;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.UpDownButton;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class SaveQueryWindow
extends QueryWindow {
    private final TableSaveChooser chooser_;

    public SaveQueryWindow(final TopcatModel tcModel, StarTableOutput sto, TableLoadChooser loadChooser, Component parent) {
        super("Save Table", parent, false, true);
        JProgressBar progBar = this.placeProgressBar();
        this.chooser_ = new TableSaveChooser(sto){

            public StarTable getTable() {
                return tcModel.getApparentStarTable();
            }

            public void done() {
                super.done();
                SaveQueryWindow.this.dispose();
            }
        };
        this.chooser_.setProgressBar(progBar);
        this.chooser_.configureFromLoader(loadChooser);
        Box mainBox = Box.createVerticalBox();
        this.getAuxControlPanel().add(mainBox);
        Box subsetLine = Box.createHorizontalBox();
        subsetLine.add(Box.createHorizontalStrut(5));
        subsetLine.add(new JLabel("Row Subset: "));
        subsetLine.add((Component)new ShrinkWrapper(new JComboBox(tcModel.getSubsetSelectionModel())));
        subsetLine.add(Box.createHorizontalGlue());
        mainBox.add(subsetLine);
        mainBox.add(Box.createVerticalStrut(5));
        Box sortLine = Box.createHorizontalBox();
        sortLine.add(Box.createHorizontalStrut(5));
        sortLine.add(new JLabel("Sort Order: "));
        sortLine.add((Component)new ShrinkWrapper(new JComboBox(tcModel.getSortSelectionModel())));
        sortLine.add(new UpDownButton(tcModel.getSortSenseModel()));
        sortLine.add(Box.createHorizontalGlue());
        mainBox.add(sortLine);
        Box chooserLine = Box.createHorizontalBox();
        chooserLine.add((Component)this.chooser_);
        chooserLine.add(Box.createHorizontalGlue());
        mainBox.add(chooserLine);
    }

    public boolean perform() {
        return false;
    }
}

