/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SizingScrollPane
extends JScrollPane {
    private SizeConfig config_;

    public SizingScrollPane() {
        this(null);
    }

    public SizingScrollPane(Component view) {
        super(view);
    }

    public Dimension getPreferredSize() {
        SizeConfig config = this.getConfig();
        if (this.getViewport() != null && this.getViewport().getView() != null) {
            JViewport cHead;
            Dimension vdim = this.getViewport().getView().getPreferredSize();
            int vw = vdim.width;
            int vh = vdim.height;
            Insets insets = this.getInsets();
            vw += insets.left + insets.right;
            vh += insets.top + insets.bottom;
            JViewport rHead = this.getRowHeader();
            if (rHead != null) {
                vw += ((Component)rHead).getPreferredSize().width;
            }
            if ((cHead = this.getColumnHeader()) != null) {
                vh += ((Component)cHead).getPreferredSize().height;
            }
            if (vw > config.maxWidth_) {
                vh += this.getVerticalScrollBar().getPreferredSize().width;
            }
            if (vh > config.maxHeight_) {
                vw += this.getHorizontalScrollBar().getPreferredSize().height;
            }
            int w = SizingScrollPane.limit(vw, config.minWidth_, config.maxWidth_);
            int h = SizingScrollPane.limit(vh, config.minHeight_, config.maxHeight_);
            return new Dimension(w, h);
        }
        return new Dimension(config.defWidth_, config.defHeight_);
    }

    private SizeConfig getConfig() {
        if (this.config_ == null) {
            this.config_ = new SizeConfig(((Graphics2D)this.getGraphics()).getDeviceConfiguration().getBounds().getSize());
        }
        return this.config_;
    }

    private static int limit(int pref, int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException();
        }
        return Math.max(Math.min(pref, max), min);
    }

    private static class SizeConfig {
        final int minWidth_;
        final int maxWidth_;
        final int defWidth_;
        final int minHeight_;
        final int maxHeight_;
        final int defHeight_;

        SizeConfig(Dimension screen) {
            this.minWidth_ = 100;
            this.maxWidth_ = SizingScrollPane.limit((int)(0.6 * (double)screen.width), 300, 700);
            this.defWidth_ = SizingScrollPane.limit((int)(0.3 * (double)screen.width), 300, 500);
            this.minHeight_ = 100;
            this.maxHeight_ = SizingScrollPane.limit((int)(0.3 * (double)screen.height), 200, 500);
            this.defHeight_ = SizingScrollPane.limit((int)(0.2 * (double)screen.height), 200, 300);
        }
    }
}

