/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSource;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.NumericCellRenderer;
import uk.ac.starlink.table.gui.ProgressBarStarTable;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.NormaliseTable;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SaveTableQueryWindow;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.TableColumnModelAdapter;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.ttools.filter.QuantCalc;

public class StatsWindow
extends AuxWindow {
    private final TopcatModel tcModel_;
    private final StarTable dataModel_;
    private final TableColumnModel columnModel_;
    private final OptionsListModel subsets_;
    private final Map calcMap_;
    private final JTable jtab_;
    private final JProgressBar progBar_;
    private final JComboBox subSelector_;
    private final AbstractTableModel statsTableModel_;
    private final BitSet hideColumns_ = new BitSet();
    private final Action recalcAct_;
    private StatsCalculator activeCalculator_;
    private StatsCalculator lastCalc_;
    private SaveTableQueryWindow saveWindow_;
    private static final ValueInfo NROW_INFO = new DefaultValueInfo("statRows", Long.class, "Number of rows over which statistics were gathered");
    private static final ValueInfo LOC_INFO = new DefaultValueInfo("dataLocation", String.class, "Location of original table");
    private static final ValueInfo RSET_INFO = new DefaultValueInfo("subset", String.class, "Name of row subset over which statistics were gathered");
    private static final Map QUANTILE_NAMES = StatsWindow.quantileNames();
    private static final double[] QUANTILES = new double[]{0.001, 0.01, 0.25, 0.5, 0.75, 0.99, 0.999};
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$StatsWindow;

    public StatsWindow(TopcatModel tcModel, Component parent) {
        super(tcModel, "Row Statistics", parent);
        this.tcModel_ = tcModel;
        this.dataModel_ = tcModel.getDataModel();
        this.columnModel_ = tcModel.getColumnModel();
        this.subsets_ = tcModel.getSubsets();
        this.calcMap_ = new HashMap();
        this.statsTableModel_ = this.makeStatsTableModel();
        this.jtab_ = new JTable(this.statsTableModel_);
        StatsWindow.configureJTable(this.jtab_);
        this.getMainArea().add(new SizingScrollPane(this.jtab_));
        MetaColumnModel statsColumnModel = new MetaColumnModel(this.jtab_.getColumnModel(), this.statsTableModel_);
        this.jtab_.setColumnModel(statsColumnModel);
        int nstat = statsColumnModel.getColumnCount();
        for (int i = 0; i < nstat; ++i) {
            if (!this.hideColumns_.get(i)) continue;
            statsColumnModel.removeColumn(i);
        }
        statsColumnModel.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                if (StatsWindow.this.getMetaColumn(evt.getToIndex()) instanceof QuantileColumn) {
                    StatsCalculator calc = StatsWindow.this.activeCalculator_;
                    if (calc == null) {
                        calc = StatsWindow.this.lastCalc_;
                    }
                    if (calc != null && !calc.hasQuant) {
                        StatsWindow.this.recalcAct_.actionPerformed(null);
                    }
                }
            }
        });
        JPanel controlPanel = this.getControlPanel();
        this.subSelector_ = this.subsets_.makeComboBox();
        this.subSelector_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    StatsWindow.this.setSubset((RowSubset)evt.getItem());
                }
            }
        });
        controlPanel.add(new JLabel("Subset for calculations: "));
        controlPanel.add(this.subSelector_);
        TableSource statsSrc = new TableSource(){

            public StarTable getStarTable() {
                return StatsWindow.this.getStatsTable();
            }
        };
        Action saveAct = this.createSaveTableAction("statistics", statsSrc);
        Action importAct = this.createImportTableAction("statistics", statsSrc, "stats of " + this.tcModel_.getID());
        this.recalcAct_ = new BasicAction("Recalculate", ResourceIcon.REDO, "Recalculate the statistics for the current subset"){

            public void actionPerformed(ActionEvent evt) {
                RowSubset rset = (RowSubset)StatsWindow.this.subSelector_.getSelectedItem();
                StatsWindow.this.calcMap_.remove(rset);
                StatsWindow.this.setSubset(rset);
            }
        };
        this.getToolBar().add(saveAct);
        this.getToolBar().add(importAct);
        this.getToolBar().add(this.recalcAct_);
        this.getToolBar().addSeparator();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(saveAct);
        exportMenu.add(importAct);
        this.getJMenuBar().add(exportMenu);
        JMenu statsMenu = new JMenu("Statistics");
        statsMenu.setMnemonic(83);
        statsMenu.add(new JMenuItem(this.recalcAct_));
        this.getJMenuBar().add(statsMenu);
        JMenu displayMenu = statsColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        this.progBar_ = this.placeProgressBar();
        this.addHelp("StatsWindow");
        this.subSelector_.setSelectedItem(tcModel.getSelectedSubset());
        tcModel.addTopcatListener(new TopcatListener(){

            public void modelChanged(TopcatEvent evt) {
                if (evt.getCode() == 4) {
                    StatsWindow.this.subSelector_.setSelectedItem(StatsWindow.this.tcModel_.getSelectedSubset());
                }
                if (evt.getCode() == 7) {
                    StatsWindow.this.subSelector_.setSelectedItem((RowSubset)evt.getDatum());
                }
            }
        });
    }

    public void setSubset(RowSubset rset) {
        if (this.activeCalculator_ != null) {
            this.activeCalculator_.interrupt();
        }
        if (rset != this.subSelector_.getSelectedItem()) {
            this.subSelector_.setSelectedItem(rset);
            return;
        }
        boolean hasQuant = false;
        for (int icol = 0; icol < this.jtab_.getColumnCount() && !hasQuant; ++icol) {
            hasQuant = hasQuant || this.getMetaColumn(icol) instanceof QuantileColumn;
        }
        if (this.calcMap_.containsKey(rset)) {
            this.displayCalculations((StatsCalculator)this.calcMap_.get(rset));
        } else {
            this.activeCalculator_ = new StatsCalculator(rset, hasQuant);
            this.activeCalculator_.start();
        }
    }

    private void displayCalculations(StatsCalculator stats) {
        boolean firstTime = this.lastCalc_ == null;
        this.lastCalc_ = stats;
        this.statsTableModel_.fireTableDataChanged();
        if (firstTime) {
            StarJTable.configureColumnWidths((JTable)this.jtab_, (int)200, (int)Integer.MAX_VALUE);
        }
        RowSubset rset = stats.rset;
        long nrow = stats.ngoodrow;
        int irset = this.subsets_.indexOf(rset);
        if (irset >= 0) {
            this.tcModel_.getSubsetCounts().put(rset, new Long(nrow));
            this.subsets_.fireContentsChanged(irset, irset);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.activeCalculator_ != null) {
            this.activeCalculator_.interrupt();
            this.activeCalculator_ = null;
            this.setBusy(false);
        }
    }

    private static void configureJTable(JTable jtab) {
        jtab.setAutoResizeMode(0);
        jtab.setColumnSelectionAllowed(false);
        jtab.setRowSelectionAllowed(false);
        TableColumnModel tcm = jtab.getColumnModel();
        TableModel tmodel = jtab.getModel();
        StarJTable.configureColumnWidth((JTable)jtab, (int)200, (int)Integer.MAX_VALUE, (int)0);
        for (int icol = 0; icol < tcm.getColumnCount(); ++icol) {
            Class clazz = tmodel.getColumnClass(icol);
            if (clazz.equals(class$java$lang$Long == null ? StatsWindow.class$("java.lang.Long") : class$java$lang$Long)) {
                clazz = class$java$lang$Integer == null ? StatsWindow.class$("java.lang.Integer") : class$java$lang$Integer;
            }
            if (clazz.equals(class$java$lang$Object == null ? StatsWindow.class$("java.lang.Object") : class$java$lang$Object)) {
                clazz = class$java$lang$Double == null ? StatsWindow.class$("java.lang.Double") : class$java$lang$Double;
            }
            NumericCellRenderer rend = new NumericCellRenderer(clazz);
            TableColumn tcol = tcm.getColumn(icol);
            tcol.setCellRenderer((TableCellRenderer)rend);
            tcol.setPreferredWidth(rend.getCellWidth());
        }
    }

    private int getModelIndexFromRow(int irow) {
        return this.columnModel_.getColumn(irow).getModelIndex();
    }

    public int getCardinalityLimit(long nvalue) {
        return Math.min(50, (int)Math.min((double)nvalue * 0.75, 2.147483647E9));
    }

    private AbstractTableModel makeStatsTableModel() {
        ArrayList<MetaColumn> metas = new ArrayList<MetaColumn>();
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Index", Integer.class, "Column index"){

            public Object getValue(int irow) {
                return new Integer(irow + 1);
            }
        });
        this.hideColumns_.set(metas.size());
        final ValueInfo idInfo = TopcatUtils.COLID_INFO;
        metas.add(new MetaColumn(idInfo.getName(), String.class, "Column unique identifier"){

            public Object getValue(int irow) {
                return ((StarTableColumn)StatsWindow.this.columnModel_.getColumn(irow)).getColumnInfo().getAuxDatum(idInfo).getValue();
            }
        });
        metas.add(new MetaColumn("Name", String.class, "Column name"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                return StatsWindow.this.dataModel_.getColumnInfo(jcol).getName();
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Sum", Double.class, "Sum of all values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                if (((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol]) {
                    return new Double(((StatsWindow)StatsWindow.this).lastCalc_.sums[jcol]);
                }
                if (((StatsWindow)StatsWindow.this).lastCalc_.isBoolean[jcol]) {
                    return new Long(((StatsWindow)StatsWindow.this).lastCalc_.ntrues[jcol]);
                }
                return null;
            }
        });
        metas.add(new MetaColumn("Mean", Float.class, "Mean of values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] || ((StatsWindow)StatsWindow.this).lastCalc_.isBoolean[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.means[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("SD", Float.class, "Population standard deviation of values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.popsdevs[jcol]) : null;
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Variance", Float.class, "Population variance of values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.popvars[jcol]) : null;
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Sample_SD", Float.class, "Sample standard deviation of values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.sampsdevs[jcol]) : null;
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Sample_Variance", Float.class, "Sample variance of values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.sampvars[jcol]) : null;
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Skew", Float.class, "Gamma 1 measure of skewness of column value distribution"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.skews[jcol]) : null;
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Kurtosis", Float.class, "Gamma 2 measure of peakedness of column value distribution"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.isNumber[jcol] ? new Float(((StatsWindow)StatsWindow.this).lastCalc_.kurts[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("Minimum", Object.class, "Numerically or other (e.g. alphabetically) smallest value in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.mins[jcol];
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Row_of_min", Long.class, "Row index of the minimum value from column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.mins[jcol] != null ? new Long(((StatsWindow)StatsWindow.this).lastCalc_.imins[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("Maximum", Object.class, "Numerically or other (e.g. alphabetically) largest value in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.maxs[jcol];
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Row_of_max", Long.class, "Row index of the maximum value from column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return ((StatsWindow)StatsWindow.this).lastCalc_.maxs[jcol] != null ? new Long(((StatsWindow)StatsWindow.this).lastCalc_.imaxs[jcol]) : null;
            }
        });
        metas.add(new MetaColumn("nGood", Long.class, "Number of non-blank values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return new Long(((StatsWindow)StatsWindow.this).lastCalc_.ngoods[jcol]);
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("nBad", Long.class, "Number of blank values in column"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                return new Long(((StatsWindow)StatsWindow.this).lastCalc_.nbads[jcol]);
            }
        });
        this.hideColumns_.set(metas.size());
        metas.add(new MetaColumn("Cardinality", Integer.class, "Number of distinct non-blank values in column (blank if too large)"){

            public Object getValue(int irow) {
                int jcol = StatsWindow.this.getModelIndexFromRow(irow);
                if (StatsWindow.this.lastCalc_ == null || jcol >= ((StatsWindow)StatsWindow.this).lastCalc_.ncol) {
                    return null;
                }
                int card = ((StatsWindow)StatsWindow.this).lastCalc_.cards[jcol];
                return ((StatsWindow)StatsWindow.this).lastCalc_.isCardinal[jcol] && card > 0 ? new Integer(card) : null;
            }
        });
        for (int iq = 0; iq < QUANTILES.length; ++iq) {
            this.hideColumns_.set(metas.size());
            metas.add(new QuantileColumn(QUANTILES[iq]));
        }
        final MetaColumnTableModel tmodel = new MetaColumnTableModel(metas){

            public int getRowCount() {
                return StatsWindow.this.columnModel_.getColumnCount();
            }
        };
        this.columnModel_.addColumnModelListener(new TableColumnModelAdapter(){

            public void columnAdded(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }

            public void columnRemoved(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }

            public void columnMoved(TableColumnModelEvent evt) {
                tmodel.fireTableDataChanged();
            }
        });
        return tmodel;
    }

    private MetaColumn getMetaColumn(int icol) {
        int jcol = this.jtab_.getColumnModel().getColumn(icol).getModelIndex();
        return ((MetaColumnTableModel)this.jtab_.getModel()).getMeta(jcol);
    }

    private StarTable getStatsTable() {
        int ncol = this.jtab_.getColumnCount();
        ColumnInfo[] infos = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            infos[icol] = new ColumnInfo(this.getMetaColumn(icol).getInfo());
        }
        RowListStarTable table = new RowListStarTable(infos);
        table.setName("Statistics for " + this.tcModel_.getLabel());
        RowSubset rset = (RowSubset)this.subSelector_.getSelectedItem();
        String loc = this.tcModel_.getLocation();
        if (loc != null && loc.trim().length() > 0) {
            table.setParameter(new DescribedValue(LOC_INFO, (Object)loc));
        }
        table.setParameter(new DescribedValue(NROW_INFO, (Object)new Long(this.lastCalc_.ngoodrow)));
        if (rset != null && rset != RowSubset.ALL) {
            table.setParameter(new DescribedValue(RSET_INFO, (Object)rset.getName()));
        }
        int nrow = this.jtab_.getRowCount();
        for (int irow = 0; irow < nrow; ++irow) {
            Object[] row = new Object[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                row[icol] = this.jtab_.getValueAt(irow, icol);
            }
            table.addRow(row);
        }
        return new NormaliseTable((StarTable)table);
    }

    private static Map quantileNames() {
        HashMap<Double, String> map = new HashMap<Double, String>();
        map.put(new Double(0.5), "Median");
        map.put(new Double(0.25), "Quartile1");
        map.put(new Double(0.75), "Quartile3");
        map.put(new Double(0.001), "Q001");
        map.put(new Double(0.01), "Q01");
        map.put(new Double(0.99), "Q99");
        map.put(new Double(0.999), "Q999");
        return map;
    }

    static /* synthetic */ void access$1500(StatsWindow x0, StatsCalculator x1) {
        x0.displayCalculations(x1);
    }

    static /* synthetic */ StatsCalculator access$102(StatsWindow x0, StatsCalculator x1) {
        x0.activeCalculator_ = x1;
        return x0.activeCalculator_;
    }

    private class StatsCalculator
    extends Thread {
        private final RowSubset rset;
        private final boolean hasQuant;
        int ncol;
        long ngoodrow;
        boolean[] isNumber;
        boolean[] isComparable;
        boolean[] isBoolean;
        boolean[] isCardinal;
        Object[] mins;
        Object[] maxs;
        long[] imins;
        long[] imaxs;
        long[] ngoods;
        long[] nbads;
        long[] ntrues;
        double[] means;
        double[] popsdevs;
        double[] popvars;
        double[] sampsdevs;
        double[] sampvars;
        double[] skews;
        double[] kurts;
        double[] sums;
        double[] sum2s;
        double[] sum3s;
        double[] sum4s;
        int[] cards;
        Map[] quantiles;
        QuantCalc[] quantCalcs;
        static final /* synthetic */ boolean $assertionsDisabled;

        public StatsCalculator(RowSubset rset, boolean hasQuant) {
            super("StatsCalculator");
            this.rset = rset;
            this.hasQuant = hasQuant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ StatsCalculator this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (this.this$1 == StatsWindow.access$100(StatsCalculator.access$1400(this.this$1))) {
                        StatsCalculator.access$1400(this.this$1).setBusy(true);
                    }
                }
            });
            try {
                this.calculate();
                StatsWindow.this.calcMap_.put(this.rset, this);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ StatsCalculator this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        StatsWindow.access$1500(StatsCalculator.access$1400(this.this$1), this.this$1);
                    }
                });
            }
            catch (OutOfMemoryError e) {
                block6: {
                    if (!this.hasQuant) break block6;
                    this.quantCalcs = null;
                    String[] msg = new String[]{"Out of memory while calculating quantiles.", "", "Quantiles (median, quartiles, percentiles etc)", "are much more expensive to calculate than other", "statistical quantities.", "To calculate statistics for this table you will", "need to undisplay these columns, or start again", "with more memory."};
                    SwingUtilities.invokeLater(new Runnable(this, msg){
                        private final /* synthetic */ Object val$msg;
                        private final /* synthetic */ StatsCalculator this$1;
                        {
                            this.this$1 = this$1;
                            this.val$msg = val$msg;
                        }

                        public void run() {
                            JOptionPane.showMessageDialog(StatsCalculator.access$1400(this.this$1), this.val$msg, "Calculation failed", 0);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ StatsCalculator this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (this.this$1 == StatsWindow.access$100(StatsCalculator.access$1400(this.this$1))) {
                            StatsWindow.access$102(StatsCalculator.access$1400(this.this$1), null);
                            StatsCalculator.access$1400(this.this$1).setBusy(false);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private void calculate() throws IOException {
            Object num;
            this.ncol = StatsWindow.this.dataModel_.getColumnCount();
            this.isNumber = new boolean[this.ncol];
            this.isComparable = new boolean[this.ncol];
            this.isBoolean = new boolean[this.ncol];
            this.isCardinal = new boolean[this.ncol];
            this.mins = new Object[this.ncol];
            this.maxs = new Object[this.ncol];
            this.imins = new long[this.ncol];
            this.imaxs = new long[this.ncol];
            this.ngoods = new long[this.ncol];
            this.nbads = new long[this.ncol];
            this.ntrues = new long[this.ncol];
            this.means = new double[this.ncol];
            this.popsdevs = new double[this.ncol];
            this.popvars = new double[this.ncol];
            this.sampsdevs = new double[this.ncol];
            this.sampvars = new double[this.ncol];
            this.skews = new double[this.ncol];
            this.kurts = new double[this.ncol];
            this.sums = new double[this.ncol];
            this.sum2s = new double[this.ncol];
            this.sum3s = new double[this.ncol];
            this.sum4s = new double[this.ncol];
            this.cards = new int[this.ncol];
            this.quantiles = new Map[this.ncol];
            this.quantCalcs = new QuantCalc[this.ncol];
            boolean[] badcompars = new boolean[this.ncol];
            double[] dmins = new double[this.ncol];
            double[] dmaxs = new double[this.ncol];
            Set[] valuesets = new Set[this.ncol];
            Arrays.fill(dmins, Double.MAX_VALUE);
            Arrays.fill(dmaxs, -1.7976931348623157E308);
            long nr = -1L;
            if (this.hasQuant && (num = StatsWindow.this.tcModel_.getSubsetCounts().get(this.rset)) instanceof Number) {
                nr = ((Number)num).longValue();
            }
            for (int icol = 0; icol < this.ncol; ++icol) {
                Class clazz = StatsWindow.this.dataModel_.getColumnInfo(icol).getContentClass();
                this.isNumber[icol] = (class$java$lang$Number == null ? StatsWindow.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz);
                this.isComparable[icol] = (class$java$lang$Comparable == null ? StatsWindow.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(clazz);
                this.isBoolean[icol] = clazz.equals(class$java$lang$Boolean == null ? StatsWindow.class$("java.lang.Boolean") : class$java$lang$Boolean);
                boolean bl = this.isCardinal[icol] = !clazz.equals(class$java$lang$Boolean == null ? StatsWindow.class$("java.lang.Boolean") : class$java$lang$Boolean);
                if (this.isCardinal[icol]) {
                    valuesets[icol] = new HashSet();
                }
                if (!this.hasQuant || !this.isNumber[icol]) continue;
                this.quantCalcs[icol] = QuantCalc.createInstance((Class)clazz, (long)nr);
            }
            RowSequence rseq = new ProgressBarStarTable(StatsWindow.this.dataModel_, StatsWindow.this.progBar_).getRowSequence();
            int cardlimit = StatsWindow.this.getCardinalityLimit(StatsWindow.this.dataModel_.getRowCount());
            IOException interruption = null;
            long lrow = 0L;
            this.ngoodrow = 0L;
            while (true) {
                long lrow1;
                block51: {
                    lrow1 = ++lrow;
                    try {
                        if (!rseq.next()) {
                        }
                        break block51;
                    }
                    catch (IOException e) {
                        interruption = e;
                    }
                    break;
                }
                if (!this.rset.isIncluded(lrow)) continue;
                ++this.ngoodrow;
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < this.ncol; ++icol) {
                    boolean good;
                    Object val = row[icol];
                    if (val == null) {
                        good = false;
                    } else {
                        if (this.isNumber[icol]) {
                            double dval = Double.NaN;
                            if (!(val instanceof Number)) {
                                System.err.println("Error in table data: not numeric at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                dval = ((Number)val).doubleValue();
                            }
                            good = !Double.isNaN(dval);
                            if (good) {
                                if (dval < dmins[icol]) {
                                    dmins[icol] = dval;
                                    this.mins[icol] = val;
                                    this.imins[icol] = lrow1;
                                }
                                if (dval > dmaxs[icol]) {
                                    dmaxs[icol] = dval;
                                    this.maxs[icol] = val;
                                    this.imaxs[icol] = lrow1;
                                }
                                double s1 = dval;
                                double s2 = dval * s1;
                                double s3 = dval * s2;
                                double s4 = dval * s3;
                                int n = icol;
                                this.sums[n] = this.sums[n] + s1;
                                int n2 = icol;
                                this.sum2s[n2] = this.sum2s[n2] + s2;
                                int n3 = icol;
                                this.sum3s[n3] = this.sum3s[n3] + s3;
                                int n4 = icol;
                                this.sum4s[n4] = this.sum4s[n4] + s4;
                                if (this.hasQuant) {
                                    this.quantCalcs[icol].acceptDatum(val);
                                }
                            }
                        } else if (this.isComparable[icol]) {
                            if (!(val instanceof Comparable)) {
                                System.err.println("Error in table data: not Comparable  at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                good = true;
                            }
                            if (good) {
                                Comparable cval = (Comparable)val;
                                if (this.mins[icol] == null) {
                                    if (!$assertionsDisabled && this.maxs[icol] != null) {
                                        throw new AssertionError();
                                    }
                                    this.mins[icol] = val;
                                    this.maxs[icol] = val;
                                    this.imins[icol] = lrow1;
                                    this.imaxs[icol] = lrow1;
                                } else {
                                    try {
                                        if (cval.compareTo(this.mins[icol]) < 0) {
                                            this.mins[icol] = val;
                                            this.imins[icol] = lrow1;
                                        } else if (cval.compareTo(this.maxs[icol]) > 0) {
                                            this.maxs[icol] = val;
                                            this.imaxs[icol] = lrow1;
                                        }
                                    }
                                    catch (ClassCastException e) {
                                        badcompars[icol] = true;
                                    }
                                }
                            }
                        } else if (this.isBoolean[icol]) {
                            boolean bval;
                            if (!(val instanceof Boolean)) {
                                System.err.println("Error in table data: not boolean at " + lrow1 + "," + icol + "(" + val + ")");
                                good = false;
                            } else {
                                good = true;
                            }
                            if (good && (bval = ((Boolean)val).booleanValue())) {
                                int n = icol;
                                this.ntrues[n] = this.ntrues[n] + 1L;
                            }
                        } else {
                            good = true;
                        }
                        if (good) {
                            int n = icol;
                            this.ngoods[n] = this.ngoods[n] + 1L;
                        }
                    }
                    if (!good || !this.isCardinal[icol]) continue;
                    valuesets[icol].add(val);
                    if (valuesets[icol].size() <= cardlimit) continue;
                    this.isCardinal[icol] = false;
                    valuesets[icol] = null;
                }
            }
            rseq.close();
            long nrow = lrow;
            for (int icol = 0; icol < this.ncol; ++icol) {
                long ngood = this.ngoods[icol];
                this.nbads[icol] = this.ngoodrow - ngood;
                if (ngood > 0L) {
                    QuantCalc quantCalc;
                    if (this.isNumber[icol]) {
                        double dcount;
                        double sum0 = dcount = (double)ngood;
                        double sum1 = this.sums[icol];
                        double sum2 = this.sum2s[icol];
                        double sum3 = this.sum3s[icol];
                        double sum4 = this.sum4s[icol];
                        double mean = sum1 / dcount;
                        double nvar = sum2 - sum1 * sum1 / dcount;
                        this.means[icol] = mean;
                        this.popvars[icol] = nvar / dcount;
                        this.popsdevs[icol] = Math.sqrt(this.popvars[icol]);
                        if (ngood > 1L) {
                            this.sampvars[icol] = nvar / (dcount - 1.0);
                            this.sampsdevs[icol] = Math.sqrt(this.sampvars[icol]);
                        } else {
                            this.sampvars[icol] = Double.NaN;
                            this.sampsdevs[icol] = Double.NaN;
                        }
                        this.skews[icol] = Math.sqrt(dcount) / Math.pow(nvar, 1.5) * (1.0 * sum3 - 3.0 * mean * sum2 + 3.0 * mean * mean * sum1 - 1.0 * mean * mean * mean * sum0);
                        this.kurts[icol] = dcount / (nvar * nvar) * (1.0 * sum4 - 4.0 * mean * sum3 + 6.0 * mean * mean * sum2 - 4.0 * mean * mean * mean * sum1 + 1.0 * mean * mean * mean * mean * sum0) - 3.0;
                    } else if (this.isBoolean[icol]) {
                        this.means[icol] = (double)this.ntrues[icol] / (double)ngood;
                    }
                    if (this.isCardinal[icol]) {
                        int card = valuesets[icol].size();
                        if (card <= StatsWindow.this.getCardinalityLimit(ngood)) {
                            this.cards[icol] = card;
                        } else {
                            this.cards[icol] = 0;
                            this.isCardinal[icol] = false;
                            valuesets[icol] = null;
                        }
                    }
                    if ((quantCalc = this.quantCalcs[icol]) != null) {
                        quantCalc.ready();
                        this.quantiles[icol] = new HashMap();
                        for (int iq = 0; iq < QUANTILES.length; ++iq) {
                            double q = QUANTILES[iq];
                            this.quantiles[icol].put(new Double(q), quantCalc.getQuantile(q));
                        }
                        this.quantCalcs[icol] = null;
                    }
                } else {
                    this.means[icol] = Double.NaN;
                    this.popsdevs[icol] = Double.NaN;
                    this.popvars[icol] = Double.NaN;
                    this.sampvars[icol] = Double.NaN;
                    this.sampsdevs[icol] = Double.NaN;
                    this.skews[icol] = Double.NaN;
                    this.kurts[icol] = Double.NaN;
                }
                if (!badcompars[icol]) continue;
                this.mins[icol] = null;
                this.maxs[icol] = null;
                this.imins[icol] = -1L;
                this.imaxs[icol] = -1L;
            }
            if (interruption != null) {
                throw interruption;
            }
        }

        static /* synthetic */ StatsWindow access$1400(StatsCalculator x0) {
            return x0.StatsWindow.this;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$StatsWindow == null ? (class$uk$ac$starlink$topcat$StatsWindow = StatsWindow.class$("uk.ac.starlink.topcat.StatsWindow")) : class$uk$ac$starlink$topcat$StatsWindow).desiredAssertionStatus();
        }
    }

    private class QuantileColumn
    extends MetaColumn {
        private final Double key_;
        private final double quant_;

        QuantileColumn(double quant) {
            this(quant, (String)QUANTILE_NAMES.get(new Double(quant)));
        }

        QuantileColumn(double quant, String name) {
            super(name, class$java$lang$Number == null ? (class$java$lang$Number = StatsWindow.class$("java.lang.Number")) : class$java$lang$Number, "Value below which " + quant + " of column contents fall");
            this.quant_ = quant;
            this.key_ = new Double(quant);
        }

        public Object getValue(int irow) {
            int jcol = StatsWindow.this.getModelIndexFromRow(irow);
            if (StatsWindow.this.lastCalc_.hasQuant) {
                Map quantiles = ((StatsWindow)StatsWindow.this).lastCalc_.quantiles[jcol];
                if (quantiles == null || !quantiles.containsKey(this.key_)) {
                    return null;
                }
                return quantiles.get(this.key_);
            }
            return null;
        }
    }
}

