/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.BitSet;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SubsetConsumer;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.interop.SubsetActivity;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.util.gui.ErrorDialog;

public class SubsetConsumerDialog
extends JPanel {
    private final JComboBox nameSelector_;
    private JDialog dialog_;
    private SubsetConsumer consumer_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SubsetConsumerDialog(TopcatModel tcModel, final TopcatCommunicator communicator) {
        super(new BorderLayout());
        final SubsetActivity subsetActivity = communicator.createSubsetActivity();
        Box box = Box.createVerticalBox();
        this.add((Component)box, "Center");
        Box nameLine = Box.createHorizontalBox();
        this.nameSelector_ = tcModel.createNewSubsetNameSelector();
        nameLine.add(new JLabel("New Subset Name: "));
        nameLine.add(this.nameSelector_);
        box.add(nameLine);
        ConsumerAction addAction = new ConsumerAction("Add Subset", ResourceIcon.ADD, "Add the new subset to the table's Subsets Window", true){

            public void consumeSubset(TopcatModel tcModel, RowSubset rset) {
                tcModel.addSubset(rset);
            }
        };
        Box addLine = Box.createHorizontalBox();
        addLine.add(new JButton(addAction));
        addLine.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(5));
        box.add(addLine);
        ConsumerAction applyAction = new ConsumerAction("Add and Set Current Subset", ResourceIcon.ADD, "Add the new subset to the table's Subsets Window and set it as the table's Current Subset", true){

            public void consumeSubset(TopcatModel tcModel, RowSubset rset) {
                tcModel.addSubset(rset);
                tcModel.applySubset(rset);
            }
        };
        Box applyLine = Box.createHorizontalBox();
        applyLine.add(new JButton(applyAction));
        applyLine.add(Box.createHorizontalGlue());
        box.add(Box.createVerticalStrut(5));
        box.add(applyLine);
        final ConsumerAction transmitAction = new ConsumerAction("Transmit Subset", ResourceIcon.BROADCAST, "Send the subset to all listening applications", false){

            public void consumeSubset(TopcatModel tcModel, RowSubset rset) {
                try {
                    subsetActivity.selectSubset(tcModel, rset);
                }
                catch (IOException e) {
                    ErrorDialog.showError((Component)SubsetConsumerDialog.this, (String)"Send Error", (Throwable)e, (String)"Failed to transmit subset");
                }
            }
        };
        Box transmitLine = Box.createHorizontalBox();
        final JComboBox targetSelector = new JComboBox(subsetActivity.getTargetSelector());
        transmitLine.add(new JButton(transmitAction));
        transmitLine.add(Box.createHorizontalStrut(5));
        transmitLine.add(new JLabel(ResourceIcon.FORWARD));
        transmitLine.add(Box.createHorizontalStrut(5));
        transmitLine.add(targetSelector);
        communicator.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                boolean isConn = communicator.isConnected();
                transmitAction.setEnabled(isConn);
                targetSelector.setEnabled(isConn);
            }
        });
        box.add(Box.createVerticalStrut(5));
        box.add(transmitLine);
    }

    public SubsetConsumer enquireConsumer(Component parent) {
        JOptionPane op = new JOptionPane(this, 3);
        op.setOptions(new String[]{"Cancel"});
        this.dialog_ = op.createDialog(parent, "New Subset");
        this.consumer_ = null;
        this.dialog_.show();
        return this.consumer_;
    }

    private String getSubsetName() {
        Object item = this.nameSelector_.getSelectedItem();
        if (item instanceof String) {
            return (String)item;
        }
        if (item instanceof RowSubset) {
            return ((RowSubset)item).getName();
        }
        if (item == null) {
            return null;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return item.toString();
    }

    static {
        $assertionsDisabled = !SubsetConsumerDialog.class.desiredAssertionStatus();
    }

    private abstract class ConsumerAction
    extends BasicAction
    implements SubsetConsumer {
        private final boolean reqName_;
        private String name_;

        ConsumerAction(String name, Icon icon, String descrip, boolean reqName) {
            super(name, null, descrip);
            this.reqName_ = reqName;
        }

        public void actionPerformed(ActionEvent evt) {
            Object item = SubsetConsumerDialog.this.nameSelector_.getSelectedItem();
            this.name_ = SubsetConsumerDialog.this.getSubsetName();
            if (this.reqName_ && (this.name_ == null || this.name_.trim().length() == 0)) {
                JOptionPane.showMessageDialog(SubsetConsumerDialog.this, "Name required to add subset", "Missing Name", 2);
            } else {
                SubsetConsumerDialog.this.consumer_ = this;
                SubsetConsumerDialog.this.dialog_.dispose();
                if (this.reqName_) {
                    SubsetConsumerDialog.this.nameSelector_.setSelectedItem(null);
                }
            }
        }

        public void consumeSubset(TopcatModel tcModel, BitSet rowMask) {
            this.consumeSubset(tcModel, new BitsRowSubset(this.name_, rowMask));
        }

        abstract void consumeSubset(TopcatModel var1, RowSubset var2);
    }
}

