/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BooleanColumnRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.IntegerSubsetQueryWindow;
import uk.ac.starlink.topcat.InverseRowSubset;
import uk.ac.starlink.topcat.MetaColumn;
import uk.ac.starlink.topcat.MetaColumnModel;
import uk.ac.starlink.topcat.MetaColumnTableModel;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.SyntheticColumnQueryWindow;
import uk.ac.starlink.topcat.SyntheticRowSubset;
import uk.ac.starlink.topcat.SyntheticSubsetQueryWindow;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.topcat.interop.Transmitter;

public class SubsetWindow
extends AuxWindow
implements ListDataListener {
    private final TopcatModel tcModel;
    private final OptionsListModel subsets;
    private final Map subsetCounts;
    private final PlasticStarTable dataModel;
    private final MetaColumnTableModel subsetsTableModel;
    private final ToggleButtonModel autoCountModel;
    private final Action addAct;
    private final Action tocolAct;
    private final Action countAct;
    private final Action invertAct;
    private final Action sampleAct;
    private final Action headAct;
    private final Action tailAct;
    private JTable jtab;
    private JProgressBar progBar;
    private SubsetCounter activeCounter;
    private static final String CNAME_ID = "ID";
    private static final String CNAME_NAME = "Name";
    private static final String CNAME_SIZE = "Size";
    private static final String CNAME_FRACTION = "Fraction";
    private static final String CNAME_EXPRESSION = "Expression";
    private static final String CNAME_COLID = "Col $ID";

    public SubsetWindow(final TopcatModel tcModel, Component parent) {
        super(tcModel, "Row Subsets", parent);
        this.tcModel = tcModel;
        this.subsets = tcModel.getSubsets();
        this.subsetCounts = tcModel.getSubsetCounts();
        this.dataModel = tcModel.getDataModel();
        this.subsetsTableModel = this.makeTableModel();
        this.subsets.addListDataListener(this);
        this.progBar = this.placeProgressBar();
        this.jtab = new JTable(this.subsetsTableModel);
        this.jtab.setColumnSelectionAllowed(false);
        this.jtab.setRowSelectionAllowed(true);
        TableColumnModel tcm = this.jtab.getColumnModel();
        tcm.getColumn(tcm.getColumnIndex(CNAME_ID)).setPreferredWidth(64);
        tcm.getColumn(tcm.getColumnIndex(CNAME_NAME)).setPreferredWidth(200);
        tcm.getColumn(tcm.getColumnIndex(CNAME_SIZE)).setPreferredWidth(100);
        tcm.getColumn(tcm.getColumnIndex(CNAME_FRACTION)).setPreferredWidth(80);
        tcm.getColumn(tcm.getColumnIndex(CNAME_EXPRESSION)).setPreferredWidth(200);
        tcm.getColumn(tcm.getColumnIndex(CNAME_COLID)).setPreferredWidth(80);
        DefaultTableCellRenderer rightRend = new DefaultTableCellRenderer();
        rightRend.setHorizontalAlignment(4);
        tcm.getColumn(tcm.getColumnIndex(CNAME_FRACTION)).setCellRenderer(rightRend);
        MetaColumnModel metaColumnModel = new MetaColumnModel(this.jtab.getColumnModel(), this.subsetsTableModel);
        metaColumnModel.purgeEmptyColumns();
        this.jtab.setColumnModel(metaColumnModel);
        this.getMainArea().add(new SizingScrollPane(this.jtab));
        this.addAct = new SubsetAction("New subset", ResourceIcon.ADD, "Define a new subset using algebraic expression");
        this.addAct.setEnabled(TopcatUtils.canJel());
        this.tocolAct = new SubsetAction("To column", ResourceIcon.TO_COLUMN, "Create new boolean column from selected subset");
        this.countAct = new SubsetAction("Count rows", ResourceIcon.COUNT, "(Re)count the number of rows in each subset");
        this.invertAct = new SubsetAction("Invert subset", ResourceIcon.INVERT, "Create new subset complementary to selected subset");
        this.sampleAct = new SubsetAction("Add sample subset", ResourceIcon.SAMPLE, "Create new subset containing a regular sample of the rows");
        this.headAct = new SubsetAction("Add head subset", ResourceIcon.HEAD, "Create new subset containing the first N rows");
        this.tailAct = new SubsetAction("Add tail subset", ResourceIcon.TAIL, "Create new subset containing the last N rows");
        TopcatCommunicator communicator = ControlWindow.getInstance().getCommunicator();
        String proto = communicator.getProtocolName();
        final Transmitter subsetTransmitter = communicator.createSubsetTransmitter(tcModel, this);
        subsetTransmitter.getBroadcastAction().putValue("ShortDescription", "Select rows in other registered applications using " + proto);
        JMenu sendMenu = subsetTransmitter.createSendMenu();
        sendMenu.setToolTipText("Select rows in a single other registered application using " + proto);
        ListSelectionListener selList = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                int nsel = SubsetWindow.this.jtab.getSelectedRowCount();
                boolean hasUniqueSelection = nsel == 1;
                SubsetWindow.this.tocolAct.setEnabled(hasUniqueSelection);
                SubsetWindow.this.invertAct.setEnabled(hasUniqueSelection);
                subsetTransmitter.setEnabled(hasUniqueSelection);
            }
        };
        final ListSelectionModel selectionModel = this.jtab.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(selList);
        selList.valueChanged(null);
        tcModel.addTopcatListener(new TopcatListener(){

            public void modelChanged(TopcatEvent evt) {
                RowSubset rset = null;
                if (evt.getCode() == 4) {
                    rset = SubsetWindow.this.getSelectedSubset();
                } else if (evt.getCode() == 7) {
                    rset = (RowSubset)evt.getDatum();
                }
                if (rset != null) {
                    selectionModel.setValueIsAdjusting(true);
                    selectionModel.clearSelection();
                    ComboBoxModel tcSelModel = tcModel.getSubsetSelectionModel();
                    for (int i = 0; i < tcSelModel.getSize(); ++i) {
                        if (tcSelModel.getElementAt(i) != rset) continue;
                        selectionModel.addSelectionInterval(i, i);
                    }
                    selectionModel.setValueIsAdjusting(false);
                }
            }
        });
        this.autoCountModel = new ToggleButtonModel("Autocount rows", ResourceIcon.RECOUNT, "Count subset size automatically");
        this.autoCountModel.setSelected(true);
        this.getToolBar().add(this.addAct);
        this.getToolBar().add(this.sampleAct);
        this.getToolBar().add(this.headAct);
        this.getToolBar().add(this.tailAct);
        this.getToolBar().addSeparator();
        this.getToolBar().add(this.invertAct);
        this.getToolBar().add(this.tocolAct);
        this.getToolBar().add(this.countAct);
        this.getToolBar().add(subsetTransmitter.getBroadcastAction());
        this.getToolBar().addSeparator();
        JMenu subsetsMenu = new JMenu("Subsets");
        subsetsMenu.setMnemonic(83);
        subsetsMenu.add(this.addAct);
        subsetsMenu.add(this.sampleAct);
        subsetsMenu.add(this.headAct);
        subsetsMenu.add(this.tailAct);
        subsetsMenu.add(this.invertAct);
        subsetsMenu.add(this.tocolAct);
        subsetsMenu.add(this.countAct);
        subsetsMenu.add(this.autoCountModel.createMenuItem());
        this.getJMenuBar().add(subsetsMenu);
        JMenu displayMenu = metaColumnModel.makeCheckBoxMenu("Display");
        displayMenu.setMnemonic(68);
        this.getJMenuBar().add(displayMenu);
        JMenu interopMenu = new JMenu("Interop");
        interopMenu.setMnemonic(73);
        interopMenu.add(subsetTransmitter.getBroadcastAction());
        interopMenu.add(sendMenu);
        this.getJMenuBar().add(interopMenu);
        this.addHelp("SubsetWindow");
    }

    public MetaColumnTableModel makeTableModel() {
        MetaColumn idCol = new MetaColumn(CNAME_ID, String.class){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetID(irow);
            }
        };
        MetaColumn nameCol = new MetaColumn(CNAME_NAME, String.class){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetName(irow);
            }
        };
        MetaColumn sizeCol = new MetaColumn(CNAME_SIZE, Long.class){

            public Object getValue(int irow) {
                return SubsetWindow.this.getSubsetSize(irow);
            }
        };
        MetaColumn fracCol = new MetaColumn(CNAME_FRACTION, String.class){
            final NumberFormat fmt;
            {
                this.fmt = NumberFormat.getInstance();
                if (this.fmt instanceof DecimalFormat) {
                    ((DecimalFormat)this.fmt).applyPattern("###% ");
                }
            }

            public Object getValue(int irow) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                Number count = (Number)SubsetWindow.this.subsetCounts.get(rset);
                return count == null ? null : this.fmt.format(count.doubleValue() / (double)SubsetWindow.this.tcModel.getDataModel().getRowCount());
            }
        };
        MetaColumn exprCol = new MetaColumn(CNAME_EXPRESSION, String.class){

            public Object getValue(int irow) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                if (rset instanceof SyntheticRowSubset) {
                    return ((SyntheticRowSubset)rset).getExpression();
                }
                return null;
            }

            public boolean isEditable(int irow) {
                return SubsetWindow.this.getSubset(irow) instanceof SyntheticRowSubset;
            }

            public void setValue(int irow, Object value) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                try {
                    SyntheticRowSubset newSet = new SyntheticRowSubset((StarTable)SubsetWindow.this.dataModel, SubsetWindow.this.subsets, rset.getName(), value.toString());
                    SubsetWindow.this.subsets.set(irow, newSet);
                    SubsetWindow.this.tcModel.getViewModel().fireTableDataChanged();
                }
                catch (CompilationException e) {
                    String[] msg = new String[]{"Syntax error in algebraic subset expression \"" + value + "\":", e.getMessage()};
                    JOptionPane.showMessageDialog(SubsetWindow.this, msg, "Expression Syntax Error", 0);
                }
            }
        };
        MetaColumn colCol = new MetaColumn(CNAME_COLID, String.class){

            public Object getValue(int irow) {
                RowSubset rset = SubsetWindow.this.getSubset(irow);
                if (rset instanceof BooleanColumnRowSubset) {
                    ColumnInfo cinfo = ((BooleanColumnRowSubset)rset).getColumnInfo();
                    return " " + SubsetWindow.this.tcModel.getColumnID(cinfo);
                }
                return null;
            }
        };
        ArrayList<MetaColumn> cols = new ArrayList<MetaColumn>();
        cols.add(idCol);
        cols.add(nameCol);
        cols.add(sizeCol);
        cols.add(fracCol);
        cols.add(exprCol);
        cols.add(colCol);
        return new MetaColumnTableModel(cols){

            public int getRowCount() {
                return SubsetWindow.this.subsets.size();
            }
        };
    }

    private RowSubset getSubset(int irow) {
        return (RowSubset)this.subsets.get(irow);
    }

    public RowSubset getSelectedSubset() {
        int irow = this.jtab.getSelectedRow();
        return irow >= 0 ? this.getSubset(irow) : null;
    }

    private String getSubsetID(int irow) {
        return '_' + Integer.toString(irow + 1);
    }

    private String getSubsetName(int irow) {
        return this.getSubset(irow).getName();
    }

    private Object getSubsetSize(int irow) {
        RowSubset rset = this.getSubset(irow);
        Number count = (Number)this.subsetCounts.get(rset);
        if (count == null || count.longValue() < 0L) {
            if (this.autoCountModel.isSelected() && this.activeCounter == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubsetWindow.this.activeCounter == null) {
                            SubsetWindow.this.countAct.actionPerformed(null);
                        }
                    }
                });
            }
            return null;
        }
        return count;
    }

    public void dispose() {
        super.dispose();
        if (this.activeCounter != null) {
            this.activeCounter.interrupt();
            this.activeCounter = null;
            this.setBusy(false);
            this.progBar.setValue(0);
        }
    }

    public void contentsChanged(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    public void intervalAdded(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.subsetsTableModel.fireTableDataChanged();
    }

    private class SubsetCounter
    extends Thread {
        private long currentRow;

        public SubsetCounter() {
            super("Subset counter");
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1100(SubsetCounter.access$1800(this.this$1)) == this.this$1) {
                        SubsetCounter.access$1800(this.this$1).setBusy(true);
                    }
                }
            });
            this.count();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1100(SubsetCounter.access$1800(this.this$1)) == this.this$1) {
                        SubsetWindow.access$1102(SubsetCounter.access$1800(this.this$1), null);
                        SubsetCounter.access$1800(this.this$1).setBusy(false);
                    }
                }
            });
        }

        void count() {
            RowSubset[] rsets = SubsetWindow.this.subsets == null ? new RowSubset[]{} : SubsetWindow.this.subsets.toArray(new RowSubset[0]);
            int nrset = rsets.length;
            long[] counts = new long[nrset];
            long nrow = SubsetWindow.this.dataModel.getRowCount();
            SubsetWindow.this.progBar.setMaximum((int)Math.min(Integer.MAX_VALUE, nrow));
            Runnable updater = new Runnable(this){
                private final /* synthetic */ SubsetCounter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (SubsetWindow.access$1100(SubsetCounter.access$1800(this.this$1)) == this.this$1) {
                        SubsetWindow.access$1900(SubsetCounter.access$1800(this.this$1)).setValue((int)SubsetCounter.access$2000(this.this$1));
                    }
                }
            };
            long every = nrow / 200L;
            long counter = 0L;
            this.currentRow = 0L;
            while (this.currentRow < nrow && !SubsetCounter.interrupted()) {
                if (--counter < 0L) {
                    SwingUtilities.invokeLater(updater);
                    counter = every;
                }
                for (int i = 0; i < nrset; ++i) {
                    RowSubset rset = rsets[i];
                    if (!rset.isIncluded(this.currentRow)) continue;
                    int n = i;
                    counts[n] = counts[n] + 1L;
                }
                ++this.currentRow;
            }
            SwingUtilities.invokeLater(updater);
            if (this.currentRow == nrow) {
                SwingUtilities.invokeLater(new Runnable(this, nrset, rsets, counts){
                    private final /* synthetic */ int val$nrset;
                    private final /* synthetic */ RowSubset[] val$rsets;
                    private final /* synthetic */ long[] val$counts;
                    private final /* synthetic */ SubsetCounter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$nrset = val$nrset;
                        this.val$rsets = val$rsets;
                        this.val$counts = val$counts;
                    }

                    public void run() {
                        for (int i = 0; i < this.val$nrset; ++i) {
                            SubsetWindow.access$700(SubsetCounter.access$1800(this.this$1)).put(this.val$rsets[i], new Long(this.val$counts[i]));
                        }
                        SubsetWindow.access$1000(SubsetCounter.access$1800(this.this$1)).fireContentsChanged(0, this.val$nrset - 1);
                        if (SubsetWindow.access$1100(SubsetCounter.access$1800(this.this$1)) == this.this$1) {
                            SubsetWindow.access$1900(SubsetCounter.access$1800(this.this$1)).setValue(0);
                        }
                    }
                });
            }
        }

        static /* synthetic */ SubsetWindow access$1800(SubsetCounter x0) {
            return x0.SubsetWindow.this;
        }

        static /* synthetic */ long access$2000(SubsetCounter x0) {
            return x0.currentRow;
        }
    }

    private class SubsetAction
    extends BasicAction {
        SubsetAction(String name, Icon icon, String description) {
            super(name, icon, description);
        }

        public void actionPerformed(ActionEvent evt) {
            SubsetWindow parent = SubsetWindow.this;
            if (this == SubsetWindow.this.addAct) {
                new SyntheticSubsetQueryWindow(SubsetWindow.this.tcModel, (Component)parent).setVisible(true);
            } else if (this == SubsetWindow.this.tocolAct) {
                SyntheticColumnQueryWindow colwin = new SyntheticColumnQueryWindow(SubsetWindow.this.tcModel, -1, (Component)parent);
                int irow = SubsetWindow.this.jtab.getSelectedRow();
                colwin.setExpression(SubsetWindow.this.getSubsetID(irow));
                colwin.setName(SubsetWindow.this.getSubsetName(irow));
                colwin.setVisible(true);
            } else if (this == SubsetWindow.this.countAct) {
                if (SubsetWindow.this.activeCounter != null) {
                    SubsetWindow.this.activeCounter.interrupt();
                }
                SubsetCounter sc = new SubsetCounter();
                SubsetWindow.this.activeCounter = sc;
                sc.start();
            } else if (this == SubsetWindow.this.invertAct) {
                int irow = SubsetWindow.this.jtab.getSelectedRow();
                SubsetWindow.this.subsets.add(new InverseRowSubset(SubsetWindow.this.getSubset(irow)));
            } else if (this == SubsetWindow.this.sampleAct) {
                new IntegerSubsetQueryWindow(this, SubsetWindow.this.tcModel, parent, "New Subset from Regular Sample", "Sample Interval"){
                    private final /* synthetic */ SubsetAction this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1, x2, x3);
                    }

                    protected void configureFields(int num) {
                        this.setSelectedName("every_" + num);
                        this.getExpressionField().setText("$0 % " + num + " == 0");
                    }
                }.setVisible(true);
            } else if (this == SubsetWindow.this.headAct) {
                new IntegerSubsetQueryWindow(this, SubsetWindow.this.tcModel, parent, "New Subset from First Rows", "Row Count"){
                    private final /* synthetic */ SubsetAction this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1, x2, x3);
                    }

                    protected void configureFields(int num) {
                        this.setSelectedName("head_" + num);
                        this.getExpressionField().setText("$0 <= " + num);
                    }
                }.setVisible(true);
            } else if (this == SubsetWindow.this.tailAct) {
                new IntegerSubsetQueryWindow(this, SubsetWindow.this.tcModel, parent, "New Subset from Last Rows", "Row Count"){
                    private final /* synthetic */ SubsetAction this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1, x2, x3);
                    }

                    protected void configureFields(int num) {
                        this.setSelectedName("tail_" + num);
                        long nrow = SubsetWindow.access$800(SubsetAction.access$1700(this.this$1)).getDataModel().getRowCount();
                        String expr = nrow + " - $0 < " + num;
                        this.getExpressionField().setText(expr);
                    }
                }.setVisible(true);
            } else {
                throw new AssertionError();
            }
        }

        static /* synthetic */ SubsetWindow access$1700(SubsetAction x0) {
            return x0.SubsetWindow.this;
        }
    }
}

