/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.UCDSelector;
import uk.ac.starlink.topcat.ClassComboBoxRenderer;
import uk.ac.starlink.topcat.ColumnIndexSpinner;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.SyntheticColumn;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;

public class SyntheticColumnQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel;
    private final PlasticStarTable dataModel;
    private final OptionsListModel subsets;
    private final TableColumnModel columnModel;
    private JTextField nameField;
    private JTextField unitField;
    private JTextField descriptionField;
    private JTextField expressionField;
    private JComboBox typeField;
    private UCDSelector ucdField;
    private ColumnIndexSpinner indexSpinner;

    public SyntheticColumnQueryWindow(TopcatModel tcModel, int insertIndex, Component parent) {
        super("Define Synthetic Column", parent);
        this.tcModel = tcModel;
        this.columnModel = tcModel.getColumnModel();
        this.dataModel = tcModel.getDataModel();
        this.subsets = tcModel.getSubsets();
        LabelledComponentStack stack = this.getStack();
        this.nameField = new JTextField();
        stack.addLine("Name", (Component)this.nameField);
        this.expressionField = new JTextField();
        stack.addLine("Expression", (Component)this.expressionField);
        this.unitField = new JTextField();
        stack.addLine("Units", (Component)this.unitField);
        this.descriptionField = new JTextField();
        stack.addLine("Description", (Component)this.descriptionField);
        this.typeField = new JComboBox();
        this.typeField.addItem(null);
        this.typeField.addItem(Byte.TYPE);
        this.typeField.addItem(Short.TYPE);
        this.typeField.addItem(Integer.TYPE);
        this.typeField.addItem(Long.TYPE);
        this.typeField.addItem(Float.TYPE);
        this.typeField.addItem(Double.TYPE);
        ClassComboBoxRenderer renderer = new ClassComboBoxRenderer();
        renderer.setNullRepresentation("(auto)");
        this.typeField.setRenderer(renderer);
        this.typeField.setSelectedIndex(0);
        this.ucdField = new UCDSelector();
        stack.addLine("UCD", (Component)this.ucdField);
        this.indexSpinner = new ColumnIndexSpinner(this.columnModel);
        this.indexSpinner.setColumnIndex(insertIndex);
        stack.addLine("Index", (Component)this.indexSpinner);
        this.getToolBar().add(MethodWindow.getWindowAction(this, false));
        this.getToolBar().addSeparator();
        this.addHelp("SyntheticColumnQueryWindow");
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setName(String name) {
        this.nameField.setText(name);
    }

    public String getUnit() {
        return this.unitField.getText();
    }

    public void setUnit(String units) {
        this.unitField.setText(units);
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public void setDescription(String desc) {
        this.descriptionField.setText(desc);
    }

    public String getExpression() {
        return this.expressionField.getText();
    }

    public void setExpression(String expr) {
        this.expressionField.setText(expr);
    }

    public String getUCD() {
        return this.ucdField.getID();
    }

    public void setUCD(String ucd) {
        this.ucdField.setID(ucd);
    }

    public void setType(Class clazz) {
        this.typeField.setSelectedItem(clazz);
    }

    public Class getType() {
        return (Class)this.typeField.getSelectedItem();
    }

    public int getIndex() {
        return this.indexSpinner.getColumnIndex();
    }

    protected SyntheticColumn makeColumn() {
        String name = this.getName();
        String desc = this.getDescription();
        String unit = this.getUnit();
        String expr = this.getExpression();
        String ucd = this.getUCD();
        Class clazz = this.getType();
        DefaultValueInfo info = new DefaultValueInfo(name);
        if (desc != null) {
            info.setDescription(desc);
        }
        if (ucd != null) {
            info.setUCD(ucd);
        }
        if (unit != null) {
            info.setUnitString(unit);
        }
        try {
            return new SyntheticColumn((ValueInfo)info, (StarTable)this.dataModel, this.subsets, expr, null);
        }
        catch (CompilationException e) {
            String[] msg = new String[]{"Syntax error in synthetic column expression \"" + expr + "\":", e.getMessage()};
            JOptionPane.showMessageDialog(this, msg, "Expression Syntax Error", 0);
            return null;
        }
    }

    protected boolean perform() {
        SyntheticColumn col = this.makeColumn();
        if (col == null) {
            return false;
        }
        this.tcModel.appendColumn(col, this.getIndex());
        return true;
    }

    public static SyntheticColumnQueryWindow replaceColumnDialog(final TopcatModel tcModel, final StarTableColumn baseCol, Component parent) {
        String OLD_SUFFIX = "_old";
        final ColumnList columnList = tcModel.getColumnList();
        ColumnInfo baseInfo = baseCol.getColumnInfo();
        String baseName = TopcatUtils.getBaseName(baseInfo.getName(), "_old");
        int pos = columnList.getModelIndex(columnList.indexOf((TableColumn)baseCol));
        SyntheticColumnQueryWindow qwin = new SyntheticColumnQueryWindow(tcModel, pos, parent){

            protected boolean perform() {
                SyntheticColumn col = this.makeColumn();
                if (col == null) {
                    return false;
                }
                String newName = col.getColumnInfo().getName();
                int ncol = columnList.size();
                for (int i = 0; i < ncol; ++i) {
                    StarTableColumn stcol;
                    ColumnInfo cinfo;
                    String cname;
                    TableColumn tcol = columnList.getColumn(i);
                    if (!(tcol instanceof StarTableColumn) || !(cname = (cinfo = (stcol = (StarTableColumn)tcol).getColumnInfo()).getName()).equals(newName)) continue;
                    String bname = TopcatUtils.getBaseName(cname, "_old");
                    String rname = TopcatUtils.getDistinctName(columnList, bname, "_old");
                    tcModel.renameColumn((TableColumn)stcol, rname);
                }
                tcModel.getColumnModel().removeColumn((TableColumn)baseCol);
                tcModel.appendColumn(col, this.getIndex());
                return true;
            }
        };
        qwin.setName(baseName);
        qwin.setUnit(baseInfo.getUnitString());
        qwin.setDescription(TopcatUtils.getBaseDescription(baseInfo));
        qwin.setUCD(baseInfo.getUCD());
        DescribedValue colId = baseInfo.getAuxDatum(TopcatUtils.COLID_INFO);
        if (colId != null) {
            qwin.setExpression(colId.getValue().toString());
        }
        qwin.setVisible(true);
        return qwin;
    }
}

