/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatJELRowReader;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.ttools.jel.JELRowReader;

public class SyntheticRowSubset
implements RowSubset {
    private StarTable stable;
    private List subsets;
    private String name;
    private String expression;
    private TopcatJELRowReader rowReader;
    private CompiledExpression compEx;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.topcat");

    public SyntheticRowSubset(StarTable stable, List subsets, String name, String expression) throws CompilationException {
        this.stable = stable;
        this.subsets = subsets;
        this.name = name;
        this.setExpression(expression);
    }

    public void setExpression(String expression) throws CompilationException {
        RowSubset[] subsetArray = this.subsets == null ? new RowSubset[]{} : this.subsets.toArray(new RowSubset[0]);
        this.rowReader = new TopcatJELRowReader(this.stable, subsetArray);
        Library lib = TopcatJELUtils.getLibrary((JELRowReader)this.rowReader, false);
        this.compEx = Evaluator.compile((String)expression, (Library)lib, Boolean.TYPE);
        this.expression = expression;
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isIncluded(long lrow) {
        try {
            Boolean result = (Boolean)this.rowReader.evaluateAtRow(this.compEx, lrow);
            return result == null ? false : result;
        }
        catch (RuntimeException e) {
            logger.info(e.toString());
            return false;
        }
        catch (Throwable th) {
            logger.warning(th.toString());
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }
}

