/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.BitSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.TableRowHeader;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnInfoWindow;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SizingScrollPane;
import uk.ac.starlink.topcat.SortOrder;
import uk.ac.starlink.topcat.SubsetConsumer;
import uk.ac.starlink.topcat.SyntheticColumnQueryWindow;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.ViewerTableModel;

public class TableViewerWindow
extends AuxWindow
implements TableModelListener,
TableColumnModelListener,
TopcatListener {
    private final TopcatModel tcModel;
    private final PlasticStarTable dataModel;
    private final ViewerTableModel viewModel;
    private final TableColumnModel columnModel;
    private final OptionsListModel subsets;
    private final ColumnList columnList;
    private JTable jtab;
    private TableRowHeader rowHead;
    private JScrollPane scrollpane;
    private Action includeAct;
    private Action excludeAct;
    private boolean selfHighlighting;
    private static int MAX_COLUMN_WIDTH;
    private static int MAX_SAMPLE_ROWS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableViewerWindow(final TopcatModel tcModel, Component parent) {
        super(tcModel, "Table Browser", parent);
        this.tcModel = tcModel;
        this.dataModel = tcModel.getDataModel();
        this.viewModel = tcModel.getViewModel();
        this.columnModel = tcModel.getColumnModel();
        this.subsets = tcModel.getSubsets();
        this.columnList = tcModel.getColumnList();
        tcModel.addTopcatListener(this);
        this.jtab = new JTable();
        this.jtab.setCellSelectionEnabled(false);
        this.jtab.setColumnSelectionAllowed(false);
        this.jtab.setRowSelectionAllowed(true);
        this.jtab.setModel(this.viewModel);
        this.jtab.setColumnModel(this.columnModel);
        this.scrollpane = new SizingScrollPane(this.jtab);
        this.getMainArea().add((Component)this.scrollpane, "Center");
        this.rowHead = new TableRowHeader(this.jtab){

            public int rowNumber(int irow) {
                return (int)TableViewerWindow.this.viewModel.getBaseRow(irow) + 1;
            }
        };
        this.scrollpane.setRowHeaderView((Component)this.rowHead);
        this.viewModel.addTableModelListener(this);
        this.columnModel.addColumnModelListener(this);
        BasicAction printAct = new BasicAction("Print", ResourceIcon.PRINT, "Table printing information"){
            Object msg;
            {
                this.msg = new String[]{"There is no option to print the table out directly.", "However, you can save it in a format suitable for printing", "(ascii, text, HTML or LaTeX)", "using the Save option in the Control Window", "and print out the resulting file separately."};
            }

            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(TableViewerWindow.this, this.msg, "Printing Tables", 1);
            }
        };
        this.includeAct = new ViewerAction("Subset From Selected Rows", ResourceIcon.INCLUDE_ROWS, "Define a new row subset containing all selected rows");
        this.excludeAct = new ViewerAction("Subset From Unselected Rows", ResourceIcon.EXCLUDE_ROWS, "Define a new row subset containing all visible unselected rows");
        final ListSelectionModel selectionModel = this.jtab.getSelectionModel();
        ListSelectionListener selList = new ListSelectionListener(){
            long lastActive = -1L;

            public void valueChanged(ListSelectionEvent evt) {
                boolean hasSelection = !selectionModel.isSelectionEmpty();
                TableViewerWindow.this.includeAct.setEnabled(hasSelection);
                TableViewerWindow.this.excludeAct.setEnabled(hasSelection);
                if (hasSelection && !evt.getValueIsAdjusting()) {
                    long active;
                    int first = selectionModel.getMinSelectionIndex();
                    if (selectionModel.getMaxSelectionIndex() == first && (active = TableViewerWindow.this.viewModel.getBaseRow(first)) != this.lastActive) {
                        this.lastActive = active;
                        if (!TableViewerWindow.this.selfHighlighting) {
                            TableViewerWindow.this.selfHighlighting = true;
                            tcModel.highlightRow(active);
                            TableViewerWindow.this.selfHighlighting = false;
                        }
                    }
                }
            }
        };
        selectionModel.addListSelectionListener(selList);
        selList.valueChanged(null);
        MouseAdapter mousey = new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                this.maybeShowPopup(evt);
            }

            private void maybeShowPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    JPopupMenu popper;
                    int jcol = TableViewerWindow.this.jtab.columnAtPoint(evt.getPoint());
                    if (evt.getComponent() == TableViewerWindow.this.rowHead) {
                        jcol = -1;
                    }
                    if (jcol >= -1 && (popper = TableViewerWindow.this.columnPopup(jcol)) != null) {
                        popper.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            }
        };
        this.jtab.addMouseListener(mousey);
        this.jtab.getTableHeader().addMouseListener(mousey);
        this.rowHead.addMouseListener((MouseListener)mousey);
        this.scrollpane.getViewport().setViewPosition(new Point(0, 0));
        StarJTable.configureColumnWidths((JTable)this.jtab, (int)MAX_COLUMN_WIDTH, (int)MAX_SAMPLE_ROWS);
        this.getToolBar().add(this.includeAct);
        this.getToolBar().add(this.excludeAct);
        this.getToolBar().addSeparator();
        this.getFileMenu().insert(printAct, 1);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        subsetMenu.add(this.includeAct);
        subsetMenu.add(this.excludeAct);
        AbstractAction applysubsetAct = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                int index = evt.getID();
                tcModel.applySubset((RowSubset)TableViewerWindow.this.subsets.get(index));
            }
        };
        JMenu applysubsetMenu = this.subsets.makeJMenu("Apply Subset", applysubsetAct);
        subsetMenu.add(applysubsetMenu);
        this.getJMenuBar().add(subsetMenu);
        this.addHelp("TableViewerWindow");
    }

    private void highlightRow(long lrow) {
        if (this.selfHighlighting) {
            return;
        }
        this.selfHighlighting = true;
        this.jtab.clearSelection();
        if (this.viewModel.getSubset().isIncluded(lrow)) {
            int viewRow = this.viewModel.getViewRow(lrow);
            if (!$assertionsDisabled && viewRow < 0) {
                throw new AssertionError();
            }
            this.jtab.addRowSelectionInterval(viewRow, viewRow);
            this.scrollToRow(viewRow);
        }
        this.selfHighlighting = false;
    }

    private JPopupMenu columnPopup(final int jcol) {
        String colName;
        ColumnInfo colInfo;
        StarTableColumn tcol;
        boolean rowHead;
        boolean bl = rowHead = jcol < 0;
        if (!rowHead) {
            tcol = (StarTableColumn)this.columnModel.getColumn(jcol);
            colInfo = tcol.getColumnInfo();
            colName = colInfo.getName();
        } else {
            tcol = null;
            colInfo = null;
            colName = null;
        }
        JPopupMenu popper = new JPopupMenu();
        final TableViewerWindow parent = this;
        if (!rowHead) {
            BasicAction replacecolAct = new BasicAction("Replace Column", ResourceIcon.MODIFY, "Replace " + colName + " with new synthetic column"){

                public void actionPerformed(ActionEvent evt) {
                    SyntheticColumnQueryWindow.replaceColumnDialog(TableViewerWindow.this.tcModel, tcol, parent);
                }
            };
            replacecolAct.setEnabled(TopcatUtils.canJel());
            popper.add(replacecolAct);
        }
        BasicAction addcolAct = new BasicAction("New Synthetic Column", ResourceIcon.ADD, "Add new synthetic column after " + colName){

            public void actionPerformed(ActionEvent evt) {
                new SyntheticColumnQueryWindow(TableViewerWindow.this.tcModel, jcol + 1, parent).setVisible(true);
            }
        };
        addcolAct.setEnabled(TopcatUtils.canJel());
        popper.add(addcolAct);
        if (rowHead) {
            popper.add(this.tcModel.getUnsortAction());
        } else if (Comparable.class.isAssignableFrom(colInfo.getContentClass())) {
            popper.add(this.tcModel.getSortAction(new SortOrder((TableColumn)tcol), true));
            popper.add(this.tcModel.getSortAction(new SortOrder((TableColumn)tcol), false));
        }
        if (!rowHead) {
            BasicAction hidecolAct = new BasicAction("Hide Column", ResourceIcon.HIDE, "Hide column " + colName + " from view"){

                public void actionPerformed(ActionEvent evt) {
                    TableViewerWindow.this.columnModel.removeColumn((TableColumn)tcol);
                }
            };
            popper.add(hidecolAct);
        }
        if (!rowHead && colInfo.getContentClass() == String.class) {
            BasicAction searchAct = new BasicAction("Search Column", ResourceIcon.SEARCH, "Search for regular expression in cell"){

                public void actionPerformed(ActionEvent evt) {
                    TableViewerWindow.this.findRegex(tcol, jcol);
                }
            };
            popper.add(searchAct);
        }
        if (!rowHead && colInfo.isArray() && ColumnInfoWindow.getElementCount((ValueInfo)colInfo) > 0) {
            BasicAction explodeAct = new BasicAction("Explode Column", ResourceIcon.EXPLODE, "Replace N-element array column with N scalar columns"){

                public void actionPerformed(ActionEvent evt) {
                    TableViewerWindow.this.tcModel.explodeColumn(tcol);
                }
            };
            popper.add(explodeAct);
        }
        return popper;
    }

    private BitSet getSelectedRowFlags() {
        int nrow = (int)this.dataModel.getRowCount();
        BitSet bits = new BitSet(nrow);
        int[] selected = this.jtab.getSelectedRows();
        int nsel = selected.length;
        int[] rowMap = this.viewModel.getRowMap();
        if (rowMap == null) {
            for (int i = 0; i < nsel; ++i) {
                bits.set(selected[i]);
            }
        } else {
            for (int i = 0; i < nsel; ++i) {
                bits.set(rowMap[selected[i]]);
            }
        }
        return bits;
    }

    private BitSet getUnselectedRowFlags() {
        int nrow = (int)this.dataModel.getRowCount();
        BitSet bits = new BitSet(nrow);
        int nactive = this.jtab.getRowCount();
        ListSelectionModel selModel = this.jtab.getSelectionModel();
        int[] rowMap = this.viewModel.getRowMap();
        if (rowMap == null) {
            for (int i = 0; i < nactive; ++i) {
                if (selModel.isSelectedIndex(i)) continue;
                bits.set(i);
            }
        } else {
            if (!$assertionsDisabled && rowMap.length != nactive) {
                throw new AssertionError();
            }
            for (int i = 0; i < nactive; ++i) {
                if (selModel.isSelectedIndex(i)) continue;
                bits.set(rowMap[i]);
            }
        }
        return bits;
    }

    private void findRegex(StarTableColumn tcol, int jcol) {
        Object[] msg = new Object[]{"Enter a regular expression (e.g. \".*XYZ.*\")", "to select rows whose " + tcol.getColumnInfo().getName() + " value match it"};
        String regex = JOptionPane.showInputDialog(this, msg, "Search Column", 3);
        ListSelectionModel selModel = this.jtab.getSelectionModel();
        if (regex != null && regex.trim().length() > 0) {
            Pattern pat = Pattern.compile(regex);
            int nfound = 0;
            int first = -1;
            int nrow = this.viewModel.getRowCount();
            for (int irow = 0; irow < nrow; ++irow) {
                Object cell = this.viewModel.getValueAt(irow, jcol);
                if (!(cell instanceof String) || !pat.matcher((String)cell).matches()) continue;
                if (nfound == 0) {
                    first = irow;
                    selModel.clearSelection();
                }
                selModel.addSelectionInterval(irow, irow);
                ++nfound;
            }
            if (nfound == 1) {
                this.tcModel.highlightRow(this.viewModel.getBaseRow(first));
            } else if (nfound > 1) {
                this.scrollToRow(first);
            }
        }
    }

    private void scrollToRow(int viewRow) {
        Rectangle viewRect = this.jtab.getCellRect(viewRow, 0, false);
        int yMid = viewRect.y + viewRect.height / 2;
        JScrollBar yBar = this.scrollpane.getVerticalScrollBar();
        yBar.setValue(yMid - yBar.getVisibleAmount() / 2);
    }

    private void scrollToColumn(int viewCol) {
        Rectangle viewRect = this.jtab.getCellRect(0, viewCol, false);
        int xMid = viewRect.x + viewRect.width / 2;
        JScrollBar xBar = this.scrollpane.getHorizontalScrollBar();
        xBar.setValue(xMid - xBar.getVisibleAmount() / 2);
    }

    public void modelChanged(TopcatEvent evt) {
        int code = evt.getCode();
        if (code == 5) {
            Object datum = evt.getDatum();
            if (datum instanceof Long) {
                this.highlightRow((Long)datum);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else if (code == 6) {
            Object datum = evt.getDatum();
            if (!$assertionsDisabled && !(datum instanceof StarTableColumn)) {
                throw new AssertionError();
            }
            int viewCol = -1;
            int ncol = this.columnModel.getColumnCount();
            for (int icol = 0; icol < ncol && viewCol < 0; ++icol) {
                if (this.columnModel.getColumn(icol) != datum) continue;
                viewCol = icol;
            }
            if (viewCol >= 0) {
                this.scrollToColumn(viewCol);
            }
        } else if (code == 7) {
            this.setSelection((RowSubset)evt.getDatum());
        }
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getSource() == this.viewModel) {
            // empty if block
        }
    }

    public void columnAdded(TableColumnModelEvent evt) {
        if (evt.getSource() == this.columnModel) {
            StarJTable.configureColumnWidth((JTable)this.jtab, (int)MAX_COLUMN_WIDTH, (int)MAX_SAMPLE_ROWS, (int)evt.getToIndex());
        }
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        if (evt.getSource() == this.columnModel) {
            // empty if block
        }
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnMoved(TableColumnModelEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    private void setSelection(RowSubset rset) {
        ListSelectionModel selModel = this.jtab.getSelectionModel();
        selModel.setValueIsAdjusting(true);
        selModel.clearSelection();
        int nrow = this.viewModel.getRowCount();
        int[] rowMap = this.viewModel.getRowMap();
        for (int irow = 0; irow < nrow; ++irow) {
            long jrow;
            long l = jrow = rowMap == null ? (long)irow : (long)rowMap[irow];
            if (!rset.isIncluded(jrow)) continue;
            selModel.addSelectionInterval(irow, irow);
        }
        selModel.setValueIsAdjusting(false);
    }

    static {
        $assertionsDisabled = !TableViewerWindow.class.desiredAssertionStatus();
        MAX_COLUMN_WIDTH = 300;
        MAX_SAMPLE_ROWS = 800;
    }

    private class ViewerAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        public ViewerAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == TableViewerWindow.this.includeAct || this == TableViewerWindow.this.excludeAct) {
                boolean exclude = this == TableViewerWindow.this.excludeAct;
                SubsetConsumer consumer = TableViewerWindow.this.tcModel.enquireNewSubsetConsumer(TableViewerWindow.this);
                if (consumer != null) {
                    BitSet bits = exclude ? TableViewerWindow.this.getUnselectedRowFlags() : TableViewerWindow.this.getSelectedRowFlags();
                    consumer.consumeSubset(TableViewerWindow.this.tcModel, bits);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$TableViewerWindow == null ? (class$uk$ac$starlink$topcat$TableViewerWindow = TableViewerWindow.class$("uk.ac.starlink.topcat.TableViewerWindow")) : class$uk$ac$starlink$topcat$TableViewerWindow).desiredAssertionStatus();
        }
    }
}

