/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import cds.tools.ExtApp;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.table.TableColumn;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.votable.VOTableBuilder;

public class TopcatExtApp
implements ExtApp {
    private final ControlWindow cwin_;
    private final Map importTables_;
    private int subsetCount_;
    private static final String OID_COLNAME = "_OID";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat");

    TopcatExtApp(ControlWindow cwin) {
        this.cwin_ = cwin;
        this.importTables_ = new HashMap();
    }

    public void loadVOTable(ExtApp app, InputStream in) {
        StarTable table;
        String appName;
        if (app != null) {
            String appClass = app.getClass().getName();
            appName = app.toString();
            if (appName.startsWith(appClass + "@")) {
                appName = appClass.replaceFirst(".*\\.", "");
            }
        } else {
            appName = "ExtApp";
        }
        try {
            table = this.cwin_.getTableFactory().makeStarTable(in, (TableBuilder)new VOTableBuilder());
        }
        catch (IOException e) {
            ErrorDialog.showError((Component)this.cwin_, (String)("Error accepting table from " + appName), (Throwable)e);
            return;
        }
        TopcatModel tcModel = this.cwin_.addTable(table, appName, true);
        this.importTables_.put(tcModel, appName);
        int[] oidCols = TopcatExtApp.getOidColumns(tcModel);
        ColumnList colList = tcModel.getColumnList();
        for (int i = 0; i < oidCols.length; ++i) {
            colList.setActive(oidCols[i], false);
        }
    }

    public void setVisible(boolean flag) {
        if (flag) {
            logger_.info("ExtApp setVisible(true) received");
            this.cwin_.toFront();
        } else {
            logger_.info("ExtApp setVisible(false) received");
            ListModel tcList = this.cwin_.getTablesListModel();
            for (int i = 0; i < tcList.getSize(); ++i) {
                this.cwin_.setViewsVisible((TopcatModel)tcList.getElementAt(i), false);
            }
        }
    }

    public String execCommand(String cmd) {
        logger_.info("ExtApp execCommand(\"" + cmd + "\") received (ignored)");
        return "External commands currently unsupported";
    }

    public void showVOTableObject(String[] oids) {
        this.addSubsets(oids, true);
    }

    public void selectVOTableObject(String[] oids) {
        this.addSubsets(oids, false);
    }

    private void addSubsets(String[] oids, boolean apply) {
        ++this.subsetCount_;
        logger_.info("ExtApp showVOTableObject() received, " + oids.length + " items");
        HashSet<String> oidSet = new HashSet<String>();
        for (int i = 0; i < oids.length; ++i) {
            oidSet.add(oids[i]);
        }
        ListModel tcList = this.cwin_.getTablesListModel();
        for (int i = 0; i < tcList.getSize(); ++i) {
            TopcatModel tcModel = (TopcatModel)tcList.getElementAt(i);
            RowSubset rset = this.locateSubset(tcModel, oidSet);
            if (rset == null || !apply) continue;
            tcModel.applySubset(rset);
        }
    }

    public String toString() {
        return "TOPCAT";
    }

    private static int[] getOidColumns(TopcatModel tcModel) {
        ArrayList<Integer> oidColList = new ArrayList<Integer>();
        ColumnList colList = tcModel.getColumnList();
        for (int icol = 0; icol < colList.size(); ++icol) {
            TableColumn col = colList.getColumn(icol);
            if (!OID_COLNAME.equals(col.getHeaderValue())) continue;
            oidColList.add(new Integer(icol));
        }
        int[] oidCols = new int[oidColList.size()];
        for (int i = 0; i < oidColList.size(); ++i) {
            oidCols[i] = (Integer)oidColList.get(i);
        }
        return oidCols;
    }

    private RowSubset locateSubset(TopcatModel tcModel, Set oidSet) {
        BitSet included = this.identifyIncluded(tcModel, oidSet);
        if (included == null || included.cardinality() == 0) {
            return null;
        }
        Iterator it = tcModel.getSubsets().iterator();
        while (it.hasNext()) {
            BitSet cmpBits;
            RowSubset subset = (RowSubset)it.next();
            if (!(subset instanceof BitsRowSubset) || !(cmpBits = ((BitsRowSubset)subset).getBitSet()).equals(included)) continue;
            return subset;
        }
        BitsRowSubset rset = new BitsRowSubset("imported" + this.subsetCount_, included);
        tcModel.getSubsets().add(rset);
        logger_.info("New subset " + rset.getName() + " in table " + tcModel);
        return rset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BitSet identifyIncluded(TopcatModel tcModel, Set oidSet) {
        int[] oidCols = TopcatExtApp.getOidColumns(tcModel);
        PlasticStarTable dataModel = tcModel.getDataModel();
        BitSet included = new BitSet();
        RowSequence rseq = null;
        long irow = 0L;
        rseq = dataModel.getRowSequence();
        while (rseq.next()) {
            for (int i = 0; i < oidCols.length; ++i) {
                int icol = oidCols[i];
                Object obj = rseq.getCell(icol);
                if (!oidSet.contains(obj)) continue;
                included.set(Tables.checkedLongToInt((long)irow));
            }
            ++irow;
        }
        Object var13_13 = null;
        if (rseq == null) return included;
        try {
            rseq.close();
            return included;
        }
        catch (IOException e2) {}
        return included;
        {
            catch (IOException e) {
                logger_.warning("ExtApp locate subset failed " + e);
                BitSet bitSet = null;
                Object var13_14 = null;
                if (rseq == null) return bitSet;
                try {
                    rseq.close();
                    return bitSet;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return bitSet;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (rseq == null) throw throwable;
            try {
                rseq.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

