/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;

public class TopcatJELRowReader
extends RandomJELRowReader {
    private final RowSubset[] subsets_;
    public static final char SUBSET_ID_CHAR = '_';
    static final /* synthetic */ boolean $assertionsDisabled;

    public TopcatJELRowReader(StarTable table, RowSubset[] subsets) {
        super(table);
        if (!table.isRandom()) {
            throw new IllegalArgumentException("Table is not random-access");
        }
        this.subsets_ = subsets == null ? new RowSubset[]{} : subsets;
    }

    public String getTypeName(String name) {
        String typeName = super.getTypeName(name);
        if (typeName != null) {
            return typeName;
        }
        short isub = this.getSubsetIndex(name);
        if (isub >= 0) {
            return "Boolean";
        }
        return null;
    }

    public Object translate(String name) {
        Object translation = super.translate(name);
        if (!$assertionsDisabled && translation instanceof Short) {
            throw new AssertionError();
        }
        if (translation != null) {
            return translation;
        }
        short isub = this.getSubsetIndex(name);
        if (isub >= 0) {
            return new Short(isub);
        }
        return null;
    }

    public boolean getBooleanProperty(short isub) {
        return this.subsets_[isub].isIncluded(this.getCurrentRow());
    }

    private short getSubsetIndex(String name) {
        if (name.charAt(0) == '_') {
            try {
                int isub = Integer.parseInt(name.substring(1)) - 1;
                if (isub >= 0 && isub < this.subsets_.length) {
                    return (short)isub;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.subsets_.length; ++i) {
            if (!this.subsets_[i].getName().equalsIgnoreCase(name)) continue;
            return (short)i;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !TopcatJELRowReader.class.desiredAssertionStatus();
    }
}

