/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import gnu.jel.DVResolver;
import gnu.jel.Library;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.func.BasicImageDisplay;
import uk.ac.starlink.topcat.func.Browsers;
import uk.ac.starlink.topcat.func.Image;
import uk.ac.starlink.topcat.func.Mgc;
import uk.ac.starlink.topcat.func.Output;
import uk.ac.starlink.topcat.func.Sdss;
import uk.ac.starlink.topcat.func.Sog;
import uk.ac.starlink.topcat.func.Spectrum;
import uk.ac.starlink.topcat.func.Splat;
import uk.ac.starlink.topcat.func.SuperCosmos;
import uk.ac.starlink.topcat.func.System;
import uk.ac.starlink.topcat.func.TwoQZ;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;

public class TopcatJELUtils
extends JELUtils {
    private static List activationStaticClasses;
    public static final String ACTIVATION_CLASSES_PROPERTY = "jel.classes.activation";
    private static Logger logger;
    static /* synthetic */ Class class$java$lang$String;

    public static Library getLibrary(JELRowReader rowReader, boolean activation) {
        ArrayList statix = new ArrayList(TopcatJELUtils.getStaticClasses());
        if (activation) {
            statix.addAll(TopcatJELUtils.getActivationStaticClasses());
        }
        Class[] staticLib = statix.toArray(new Class[0]);
        Class[] dynamicLib = new Class[]{rowReader.getClass()};
        Class[] dotClasses = new Class[]{};
        JELRowReader resolver = rowReader;
        Hashtable cnmap = null;
        Library lib = new Library(staticLib, dynamicLib, dotClasses, (DVResolver)resolver, cnmap);
        if (activation) {
            try {
                for (int i = 1; i <= 4; ++i) {
                    Object[] argClasses = new Class[i];
                    Arrays.fill(argClasses, class$java$lang$String == null ? TopcatJELUtils.class$("java.lang.String") : class$java$lang$String);
                    lib.markStateDependent("exec", (Class[])argClasses);
                }
            }
            catch (CompilationException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
            }
        }
        return lib;
    }

    public static List getActivationStaticClasses() {
        if (activationStaticClasses == null) {
            ArrayList<Class> classList = new ArrayList<Class>();
            classList.add(Output.class);
            classList.add(System.class);
            classList.add(Image.class);
            classList.add(Spectrum.class);
            classList.add(BasicImageDisplay.class);
            if (TopcatUtils.canSog()) {
                classList.add(Sog.class);
            }
            if (TopcatUtils.canSplat()) {
                classList.add(Splat.class);
            }
            classList.add(Browsers.class);
            classList.add(Mgc.class);
            classList.add(Sdss.class);
            classList.add(SuperCosmos.class);
            classList.add(TwoQZ.class);
            try {
                String auxClasses = java.lang.System.getProperty(ACTIVATION_CLASSES_PROPERTY);
                if (auxClasses != null && auxClasses.trim().length() > 0) {
                    String[] cs = auxClasses.split(":");
                    for (int i = 0; i < cs.length; ++i) {
                        String className = cs[i].trim();
                        Class clazz = TopcatJELUtils.classForName(className);
                        if (clazz != null) {
                            if (classList.contains(clazz)) continue;
                            classList.add(clazz);
                            continue;
                        }
                        logger.warning("Class not found: " + className);
                    }
                }
            }
            catch (SecurityException e) {
                logger.info("Security manager prevents loading auxiliary JEL classes");
            }
            activationStaticClasses = classList;
        }
        return activationStaticClasses;
    }

    public static Class wrapPrimitiveClass(Class prim) {
        if (prim == Boolean.TYPE) {
            return Boolean.class;
        }
        if (prim == Character.TYPE) {
            return Character.class;
        }
        if (prim == Byte.TYPE) {
            return Byte.class;
        }
        if (prim == Short.TYPE) {
            return Short.class;
        }
        if (prim == Integer.TYPE) {
            return Integer.class;
        }
        if (prim == Long.TYPE) {
            return Long.class;
        }
        if (prim == Float.TYPE) {
            return Float.class;
        }
        if (prim == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(prim + " is not primitive");
    }

    public static Class classForName(String cname) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(cname, true, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.topcat");
    }
}

