/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.ShapeIterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.topcat.ActivationQueryWindow;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BooleanColumnRowSubset;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.ColumnSelectorModel;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.JELActivator;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SaveQueryWindow;
import uk.ac.starlink.topcat.SortOrder;
import uk.ac.starlink.topcat.SubsetConsumer;
import uk.ac.starlink.topcat.SubsetConsumerDialog;
import uk.ac.starlink.topcat.SyntheticColumn;
import uk.ac.starlink.topcat.SyntheticSubsetQueryWindow;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.ViewerTableModel;
import uk.ac.starlink.topcat.WindowAction;
import uk.ac.starlink.topcat.interop.RowActivity;
import uk.ac.starlink.ttools.convert.Conversions;
import uk.ac.starlink.ttools.convert.ValueConverter;

public class TopcatModel {
    private final PlasticStarTable dataModel_;
    private final ViewerTableModel viewModel_;
    private final TableColumnModel columnModel_;
    private final ColumnList columnList_;
    private final OptionsListModel subsets_;
    private final Map subsetCounts_;
    private final OptionsListModel activators_;
    private final ComboBoxModel sortSelectionModel_;
    private final ComboBoxModel subsetSelectionModel_;
    private final SortSenseModel sortSenseModel_;
    private final ToggleButtonModel rowSendModel_;
    private final Collection listeners_;
    private final Map columnSelectorMap_;
    private SubsetConsumerDialog subsetConsumerDialog_;
    private final int id_;
    private final ControlWindow controlWindow_;
    private String location_;
    private String label_;
    private Activator activator_;
    private long lastHighlight_ = -1L;
    private ActivationQueryWindow activationWindow_;
    private SaveQueryWindow saveWindow_;
    private Action newsubsetAct_;
    private Action unsortAct_;
    private TopcatWindowAction activationAct_;
    private TopcatWindowAction saveAct_;
    private static final Logger logger_;
    private static int instanceCount;
    private static StarTableColumn DUMMY_COLUMN;
    private static RowActivity rowActivity_;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Comparable;

    public TopcatModel(StarTable startab, String location, ControlWindow controlWindow) {
        ColumnInfo cinfo;
        int icol;
        this.controlWindow_ = controlWindow;
        if (!startab.isRandom()) {
            throw new IllegalArgumentException("Can't use non-random table");
        }
        this.label_ = this.location_ = location;
        this.id_ = ++instanceCount;
        if (this.label_ == null) {
            this.label_ = startab.getName();
        }
        if (this.label_ == null) {
            this.label_ = "(table)";
        }
        this.dataModel_ = new PlasticStarTable(startab);
        this.viewModel_ = new ViewerTableModel(this.dataModel_);
        this.columnModel_ = new DefaultTableColumnModel(){

            public TableColumn getColumn(int icol) {
                if (icol >= 0) {
                    return super.getColumn(icol);
                }
                if (DUMMY_COLUMN == null) {
                    logger_.warning("Attempt to work around Mac OSX JTable bug");
                    DUMMY_COLUMN = new StarTableColumn(new ColumnInfo("DUMMY"));
                }
                return DUMMY_COLUMN;
            }
        };
        for (int icol2 = 0; icol2 < this.dataModel_.getColumnCount(); ++icol2) {
            ColumnInfo cinfo2 = this.dataModel_.getColumnInfo(icol2);
            StarTableColumn tcol = new StarTableColumn(cinfo2, icol2);
            this.columnModel_.addColumn((TableColumn)tcol);
        }
        this.columnList_ = new ColumnList(this.columnModel_);
        this.sortSelectionModel_ = new SortSelectionModel();
        this.sortSenseModel_ = new SortSenseModel();
        this.rowSendModel_ = new ToggleButtonModel("Broadcast Row", null, "Whether to broadcast row index to other clients at at row activation");
        this.subsets_ = new OptionsListModel();
        this.subsets_.add(RowSubset.ALL);
        this.subsetSelectionModel_ = new SubsetSelectionModel();
        this.subsetCounts_ = new HashMap();
        this.subsetCounts_.put(RowSubset.NONE, new Long(0L));
        this.subsetCounts_.put(RowSubset.ALL, new Long(startab.getRowCount()));
        int ncol = this.dataModel_.getColumnCount();
        for (icol = 0; icol < ncol; ++icol) {
            cinfo = this.dataModel_.getColumnInfo(icol);
            if (cinfo.getContentClass() != (class$java$lang$Boolean == null ? TopcatModel.class$("java.lang.Boolean") : class$java$lang$Boolean)) continue;
            int jcol = icol;
            BooleanColumnRowSubset yes = new BooleanColumnRowSubset((StarTable)this.dataModel_, icol);
            this.subsets_.add(yes);
        }
        this.activator_ = Activator.NOP;
        this.columnSelectorMap_ = new HashMap();
        this.activators_ = new OptionsListModel();
        for (icol = 0; icol < this.dataModel_.getColumnCount(); ++icol) {
            ValueConverter conv;
            Class clazz;
            if ((class$java$lang$Number == null ? TopcatModel.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz = (cinfo = this.dataModel_.getColumnInfo(icol)).getContentClass()) || (conv = Conversions.getNumericConverter((ValueInfo)cinfo)) == null) continue;
            DescribedValue dval = new DescribedValue(TopcatUtils.NUMERIC_CONVERTER_INFO, (Object)conv);
            cinfo.setAuxDatum(dval);
        }
        this.newsubsetAct_ = new ModelAction("New Subset Expression", null, "Define a new row subset");
        this.unsortAct_ = new ModelAction("Unsort", ResourceIcon.UNSORT, "Use natural row order");
        this.activationAct_ = new TopcatWindowAction("Set Activation Action", null, "Set what happens when a row/point is clicked on");
        this.saveAct_ = new TopcatWindowAction("Save Table", ResourceIcon.SAVE, "Write out the current table");
        this.listeners_ = new ArrayList();
    }

    public String getLocation() {
        return this.location_;
    }

    public String getLabel() {
        return this.label_;
    }

    public int getID() {
        return this.id_;
    }

    public String toString() {
        return this.id_ + ": " + this.getLabel();
    }

    public void setLabel(String label) {
        if (!TopcatModel.equalObject(label, this.label_)) {
            this.label_ = label;
            this.fireModelChanged(1, null);
        }
    }

    public void setActivator(Activator activator) {
        if (!TopcatModel.equalObject(activator, this.activator_)) {
            this.activator_ = activator;
            if (this.activator_ != null && this.activator_ != Activator.NOP) {
                List params = this.dataModel_.getParameters();
                params.remove(this.dataModel_.getParameterByName(TopcatUtils.ACTIVATORS_INFO.getName()));
                params.add(new DescribedValue(TopcatUtils.ACTIVATORS_INFO, (Object)this.activator_.toString()));
            }
            this.fireModelChanged(2, null);
        }
    }

    public Activator getActivator() {
        return this.activator_;
    }

    public OptionsListModel getActivatorList() {
        return this.activators_;
    }

    public Activator makeActivator(String actstr) throws CompilationException {
        if (actstr == null || actstr.trim().length() == 0 || actstr.equals(Activator.NOP.toString())) {
            return Activator.NOP;
        }
        return new JELActivator(this, actstr);
    }

    public PlasticStarTable getDataModel() {
        return this.dataModel_;
    }

    public ViewerTableModel getViewModel() {
        return this.viewModel_;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel_;
    }

    public ColumnList getColumnList() {
        return this.columnList_;
    }

    public OptionsListModel getSubsets() {
        return this.subsets_;
    }

    public Map getSubsetCounts() {
        return this.subsetCounts_;
    }

    public ComboBoxModel getSortSelectionModel() {
        return this.sortSelectionModel_;
    }

    public JToggleButton.ToggleButtonModel getSortSenseModel() {
        return this.sortSenseModel_;
    }

    public ComboBoxModel getSubsetSelectionModel() {
        return this.subsetSelectionModel_;
    }

    public RowSubset getSelectedSubset() {
        return (RowSubset)this.subsetSelectionModel_.getSelectedItem();
    }

    public SortOrder getSelectedSort() {
        return (SortOrder)this.sortSelectionModel_.getSelectedItem();
    }

    public ColumnSelectorModel getColumnSelectorModel(ValueInfo info) {
        if (!this.columnSelectorMap_.containsKey(info)) {
            this.columnSelectorMap_.put(info, new ColumnSelectorModel(this, info));
        }
        return (ColumnSelectorModel)this.columnSelectorMap_.get(info);
    }

    public ToggleButtonModel getRowSendModel() {
        return this.rowSendModel_;
    }

    public void addTopcatListener(TopcatListener listener) {
        this.listeners_.add(listener);
    }

    public void removeTopcatListener(TopcatListener listener) {
        this.listeners_.remove(listener);
    }

    public void fireModelChanged(int code, Object datum) {
        TopcatEvent evt = new TopcatEvent(this, code, datum);
        Iterator it = this.listeners_.iterator();
        while (it.hasNext()) {
            ((TopcatListener)it.next()).modelChanged(evt);
        }
    }

    public void highlightRow(long lrow) {
        if (lrow != this.lastHighlight_) {
            String msg;
            this.fireModelChanged(5, new Long(lrow));
            if (this.activator_ != null && (msg = this.activator_.activateRow(lrow)) != null && msg.trim().length() > 0) {
                System.out.println(msg);
            }
            if (this.rowSendModel_.isSelected() && this.controlWindow_.getCommunicator().isConnected()) {
                try {
                    this.getRowActivity().highlightRow(this, lrow);
                }
                catch (IOException e) {
                    logger_.info("Row send fail: " + e);
                }
            }
        }
    }

    public Action getNewSubsetAction() {
        return this.newsubsetAct_;
    }

    public Action getUnsortAction() {
        return this.unsortAct_;
    }

    public Action getActivationAction() {
        return this.activationAct_;
    }

    public Action getSaveAction() {
        return this.saveAct_;
    }

    public Action getSortAction(final SortOrder order, final boolean ascending) {
        TableColumn tcol = order.getColumn();
        return new BasicAction("Sort " + (ascending ? "up" : "down"), ascending ? ResourceIcon.UP : ResourceIcon.DOWN, "Sort rows by " + (ascending ? "a" : "de") + "scending order of " + tcol.getIdentifier()){

            public void actionPerformed(ActionEvent evt) {
                TopcatModel.this.sortBy(order, ascending);
            }
        };
    }

    public String getColumnID(ColumnInfo cinfo) {
        return cinfo.getAuxDatum(TopcatUtils.COLID_INFO).getValue().toString();
    }

    public void appendColumn(ColumnData col, int colIndex) {
        if (colIndex > this.dataModel_.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        this.dataModel_.addColumn(col);
        int modelIndex = this.dataModel_.getColumnCount() - 1;
        StarTableColumn tc = new StarTableColumn(col.getColumnInfo(), modelIndex);
        this.columnModel_.addColumn((TableColumn)tc);
        if (colIndex >= 0) {
            this.columnModel_.moveColumn(this.columnModel_.getColumnCount() - 1, colIndex);
        } else {
            colIndex = this.columnModel_.getColumnCount() - 1;
        }
    }

    public void appendColumn(ColumnData col) {
        this.appendColumn(col, -1);
    }

    public void appendColumns(final StarTable colTable) {
        for (int i = 0; i < colTable.getColumnCount(); ++i) {
            final int icol = i;
            ColumnData cdata = new ColumnData(colTable.getColumnInfo(i)){

                public Object readValue(long lrow) throws IOException {
                    return colTable.getCell(lrow, icol);
                }
            };
            this.appendColumn(cdata, -1);
        }
    }

    public void renameColumn(TableColumn tcol, String name) {
        tcol.setHeaderValue(name);
        if (tcol instanceof StarTableColumn) {
            ((StarTableColumn)tcol).getColumnInfo().setName(name);
        }
        for (int i = 0; i < this.columnModel_.getColumnCount(); ++i) {
            if (this.columnModel_.getColumn(i) != tcol) continue;
            this.columnModel_.moveColumn(i, i);
        }
    }

    public void explodeColumn(StarTableColumn tcol) {
        ColumnInfo baseInfo = tcol.getColumnInfo();
        int insertPos = this.columnList_.getModelIndex(this.columnList_.indexOf((TableColumn)tcol));
        String baseName = baseInfo.getName();
        String baseDesc = baseInfo.getDescription();
        String baseExpr = baseInfo.getAuxDatum(TopcatUtils.COLID_INFO).getValue().toString();
        ColumnInfo elInfo = new ColumnInfo(baseInfo);
        elInfo.setShape(null);
        int ipos = 0;
        ShapeIterator it = new ShapeIterator(baseInfo.getShape());
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            StringBuffer postxt = new StringBuffer();
            for (int i = 0; i < pos.length; ++i) {
                postxt.append('_');
                postxt.append(Integer.toString(pos[i] + 1));
            }
            ColumnInfo colInfo = new ColumnInfo(elInfo);
            colInfo.setName(baseName + postxt.toString());
            colInfo.setDescription("Element " + (ipos + 1) + " of " + baseName);
            String colExpr = baseExpr + '[' + ipos + ']';
            try {
                SyntheticColumn elcol = new SyntheticColumn((ValueInfo)colInfo, (StarTable)this.dataModel_, null, colExpr, null);
                this.appendColumn(elcol, ++insertPos);
            }
            catch (CompilationException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)e.getMessage()))).initCause(e));
            }
            ++ipos;
        }
        this.columnModel_.removeColumn((TableColumn)tcol);
    }

    public SubsetConsumer enquireNewSubsetConsumer(Component parent) {
        if (this.subsetConsumerDialog_ == null) {
            this.subsetConsumerDialog_ = new SubsetConsumerDialog(this, this.controlWindow_.getCommunicator());
        }
        return this.subsetConsumerDialog_.enquireConsumer(parent);
    }

    public JComboBox createNewSubsetNameSelector() {
        JComboBox selector = this.subsets_.makeComboBox();
        final ComboBoxModel baseModel = selector.getModel();
        Object item0 = baseModel.getElementAt(0);
        if (item0 == RowSubset.ALL) {
            selector.setModel(new ComboBoxModel(){

                public int getSize() {
                    return baseModel.getSize() - 1;
                }

                public Object getElementAt(int index) {
                    return baseModel.getElementAt(index >= 0 ? index + 1 : index);
                }

                public Object getSelectedItem() {
                    return baseModel.getSelectedItem();
                }

                public void setSelectedItem(Object item) {
                    baseModel.setSelectedItem(item);
                }

                public void addListDataListener(ListDataListener lr) {
                    baseModel.addListDataListener(lr);
                }

                public void removeListDataListener(ListDataListener lr) {
                    baseModel.removeListDataListener(lr);
                }
            });
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        selector.setEditable(true);
        selector.setSelectedItem(null);
        return selector;
    }

    public void addSubset(RowSubset rset) {
        boolean done = false;
        int nset = this.subsets_.size();
        for (int is = 0; is < nset && !done; ++is) {
            RowSubset rs = (RowSubset)this.subsets_.get(is);
            if (rset == RowSubset.ALL || !rset.getName().equals(rs.getName())) continue;
            this.subsets_.set(is, rset);
            done = true;
        }
        if (!done) {
            this.subsets_.add(rset);
            done = true;
        }
        if (!$assertionsDisabled && !done) {
            throw new AssertionError();
        }
        this.showSubset(rset);
    }

    public void addParameter(DescribedValue param) {
        this.dataModel_.getParameters().add(param);
        this.fireModelChanged(3, null);
    }

    public boolean removeParameter(DescribedValue param) {
        if (this.dataModel_.getParameters().remove(param)) {
            this.fireModelChanged(3, null);
            return true;
        }
        return false;
    }

    public void sortBy(SortOrder order, boolean ascending) {
        if (order != SortOrder.NONE) {
            this.sortSenseModel_.setSelected(ascending);
        }
        this.sortSelectionModel_.setSelectedItem(order);
    }

    public void applySubset(RowSubset rset) {
        this.subsetSelectionModel_.setSelectedItem(rset);
    }

    public void showSubset(RowSubset rset) {
        this.fireModelChanged(7, rset);
    }

    private int[] getSortOrder(int icol, boolean ascending) throws IOException {
        int sense = ascending ? 1 : -1;
        int nrow = AbstractStarTable.checkedLongToInt((long)this.dataModel_.getRowCount());
        ColumnData coldata = this.dataModel_.getColumnData(icol);
        class Item
        implements Comparable {
            int rank;
            Comparable value;
            private final /* synthetic */ int val$sense;

            Item(int val$sense) {
                this.val$sense = val$sense;
            }

            public int compareTo(Object o) {
                Comparable oval = ((Item)o).value;
                if (this.value != null && oval != null) {
                    return this.val$sense * this.value.compareTo(oval);
                }
                if (this.value == null && oval == null) {
                    return 0;
                }
                return this.val$sense * (this.value == null ? 1 : -1);
            }
        }
        Object[] items = new Item[nrow];
        for (int i = 0; i < nrow; ++i) {
            Item item = new Item(sense);
            item.rank = i;
            item.value = (Comparable)coldata.readValue((long)i);
            items[i] = item;
        }
        Arrays.sort(items);
        int[] rowMap = new int[nrow];
        for (int i = 0; i < nrow; ++i) {
            rowMap[i] = ((Item)items[i]).rank;
        }
        return rowMap;
    }

    public StarTable getApparentStarTable() {
        int ncol = this.columnModel_.getColumnCount();
        int[] colMap = new int[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            colMap[icol] = this.columnModel_.getColumn(icol).getModelIndex();
        }
        return new ColumnPermutedStarTable(this.viewModel_.getSnapshot(), colMap);
    }

    private RowActivity getRowActivity() {
        if (rowActivity_ == null) {
            rowActivity_ = this.controlWindow_.getCommunicator().createRowActivity();
        }
        return rowActivity_;
    }

    private static boolean equalObject(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static synchronized TopcatModel createDummyModel() {
        int ic = instanceCount;
        instanceCount = -1;
        TopcatModel dummy = new TopcatModel((StarTable)new RowListStarTable(new ColumnInfo[0]), "dummy", null);
        instanceCount = ic;
        return dummy;
    }

    static {
        $assertionsDisabled = !TopcatModel.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
        instanceCount = 0;
    }

    private class SubsetSelectionModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private RowSubset lastSubset_ = RowSubset.ALL;

        SubsetSelectionModel() {
            TopcatModel.this.subsets_.addListDataListener(this);
        }

        public Object getSelectedItem() {
            return this.lastSubset_;
        }

        public void setSelectedItem(Object item) {
            RowSubset rset = (RowSubset)item;
            if (rset == null) {
                return;
            }
            if (rset.equals(this.lastSubset_)) {
                return;
            }
            TopcatModel.this.viewModel_.setSubset(rset);
            TopcatModel.this.subsetCounts_.put(rset, new Long(TopcatModel.this.viewModel_.getRowCount()));
            int irset = TopcatModel.this.subsets_.indexOf(rset);
            if (irset >= 0) {
                TopcatModel.this.subsets_.fireContentsChanged(irset, irset);
            }
            this.lastSubset_ = rset;
            this.fireContentsChanged(this, -1, -1);
            TopcatModel.this.fireModelChanged(4, null);
        }

        public Object getElementAt(int index) {
            return TopcatModel.this.subsets_.getElementAt(index);
        }

        public int getSize() {
            return TopcatModel.this.subsets_.getSize();
        }

        public void contentsChanged(ListDataEvent evt) {
            this.fireContentsChanged(this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalAdded(ListDataEvent evt) {
            this.fireIntervalAdded(this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            this.fireIntervalRemoved(this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private class SortSelectionModel
    extends RestrictedColumnComboBoxModel {
        private SortOrder lastSort_;

        SortSelectionModel() {
            super(TopcatModel.this.columnModel_, true);
            this.lastSort_ = SortOrder.NONE;
        }

        public Object getElementAt(int index) {
            return new SortOrder((TableColumn)super.getElementAt(index));
        }

        public boolean acceptColumn(ColumnInfo cinfo) {
            Class clazz = cinfo.getContentClass();
            return (class$java$lang$Comparable == null ? (class$java$lang$Comparable = TopcatModel.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(clazz);
        }

        public Object getSelectedItem() {
            return this.lastSort_;
        }

        public void setSelectedItem(Object item) {
            int[] rowMap;
            SortOrder order = (SortOrder)item;
            if (order == null) {
                return;
            }
            if (order.equals(this.lastSort_)) {
                return;
            }
            if (order.equals(SortOrder.NONE)) {
                rowMap = null;
            } else {
                TableColumn tcol = order.getColumn();
                try {
                    rowMap = TopcatModel.this.getSortOrder(tcol.getModelIndex(), TopcatModel.this.sortSenseModel_.isSelected());
                }
                catch (IOException e) {
                    Toolkit.getDefaultToolkit().beep();
                    e.printStackTrace(System.err);
                    this.setSelectedItem(SortOrder.NONE);
                    return;
                }
            }
            TopcatModel.this.viewModel_.setOrder(rowMap);
            this.lastSort_ = order;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    private class SortSenseModel
    extends JToggleButton.ToggleButtonModel {
        boolean lastAscending_ = true;

        private SortSenseModel() {
        }

        public void setSelected(boolean ascending) {
            if (ascending != this.lastAscending_) {
                int[] rowMap = TopcatModel.this.viewModel_.getRowMap();
                if (rowMap != null) {
                    int i = 0;
                    for (int j = rowMap.length - 1; i < j; ++i, --j) {
                        int c = rowMap[i];
                        rowMap[i] = rowMap[j];
                        rowMap[j] = c;
                    }
                    TopcatModel.this.viewModel_.setRowMap(rowMap);
                }
                this.lastAscending_ = ascending;
                this.fireStateChanged();
            }
        }

        public boolean isSelected() {
            return this.lastAscending_;
        }
    }

    private class TopcatWindowAction
    extends WindowAction {
        TopcatWindowAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public boolean hasWindow() {
            if (this == TopcatModel.this.activationAct_) {
                return TopcatModel.this.activationWindow_ != null;
            }
            if (this == TopcatModel.this.saveAct_) {
                return TopcatModel.this.saveWindow_ != null;
            }
            throw new AssertionError();
        }

        public Window getWindow(Component parent) {
            TopcatModel tcModel = TopcatModel.this;
            if (this == TopcatModel.this.activationAct_) {
                if (!this.hasWindow()) {
                    TopcatModel.this.activationWindow_ = new ActivationQueryWindow(tcModel, parent);
                    TopcatModel.this.activationWindow_.setVisible(true);
                }
                return TopcatModel.this.activationWindow_;
            }
            if (this == TopcatModel.this.saveAct_) {
                if (!this.hasWindow()) {
                    StarTableOutput sto = TopcatModel.this.controlWindow_.getTableOutput();
                    TableLoadChooser loadChooser = TopcatModel.this.controlWindow_.getLoadChooser();
                    TopcatModel.this.saveWindow_ = new SaveQueryWindow(tcModel, sto, loadChooser, parent);
                    TopcatModel.this.saveWindow_.setVisible(true);
                }
                return TopcatModel.this.saveWindow_;
            }
            throw new AssertionError();
        }
    }

    private class ModelAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ModelAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            Component parent = this.getEventWindow(evt);
            TopcatModel model = TopcatModel.this;
            if (this == TopcatModel.this.newsubsetAct_) {
                new SyntheticSubsetQueryWindow(model, parent).setVisible(true);
            } else if (this == TopcatModel.this.unsortAct_) {
                TopcatModel.this.sortBy(SortOrder.NONE, false);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$TopcatModel == null ? (class$uk$ac$starlink$topcat$TopcatModel = TopcatModel.class$("uk.ac.starlink.topcat.TopcatModel")) : class$uk$ac$starlink$topcat$TopcatModel).desiredAssertionStatus();
        }
    }
}

