/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.ColumnList;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.HelpWindow;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.util.IOUtils;

public class TopcatUtils {
    private static Boolean canSog_;
    private static Boolean canSplat_;
    private static Boolean canExec_;
    private static Boolean canJel_;
    private static String[] about_;
    private static String version_;
    private static String stilVersion_;
    private static Logger logger_;
    public static String DEMO_LOCATION;
    public static String DEMO_TABLE;
    public static String DEMO_NODES;
    public static final String VERSION_RESOURCE = "version-string";
    public static final ValueInfo COLID_INFO;
    public static final ValueInfo BASE_DESCRIPTION_INFO;
    public static final ValueInfo EXPR_INFO;
    public static final ValueInfo NUMERIC_CONVERTER_INFO;
    public static final ValueInfo ACTIVATORS_INFO;
    public static final ValueInfo TIME_INFO;

    public static String getBaseDescription(ColumnInfo info) {
        DescribedValue descValue = info.getAuxDatum(BASE_DESCRIPTION_INFO);
        if (descValue == null) {
            return info.getDescription();
        }
        Object desc = descValue.getValue();
        return desc instanceof String ? (String)desc : info.getDescription();
    }

    public static void setBaseDescription(ColumnInfo info, String desc) {
        DescribedValue descValue = info.getAuxDatum(BASE_DESCRIPTION_INFO);
        if (descValue == null) {
            info.setDescription(desc);
        } else {
            descValue.setValue((Object)desc);
            String descrip = desc;
            String expr = TopcatUtils.getExpression(info);
            if (expr != null && expr.trim().length() > 0) {
                String string = descrip + " (" + expr + ")";
            }
        }
    }

    public static String getExpression(ColumnInfo info) {
        DescribedValue exprValue = info.getAuxDatum(EXPR_INFO);
        if (exprValue == null) {
            return null;
        }
        Object expr = exprValue.getValue();
        return expr == null ? null : expr.toString();
    }

    public static String getBaseName(String origName, String baseSuffix) {
        return TopcatUtils.suffixPattern(baseSuffix).matcher(origName).replaceFirst("");
    }

    public static String getDistinctName(ColumnList colList, String origName, String baseSuffix) {
        Pattern suffixPattern = TopcatUtils.suffixPattern(baseSuffix);
        String baseName = TopcatUtils.getBaseName(origName, baseSuffix);
        int baseLeng = baseName.length();
        int ncol = colList.size();
        int nextFreeIndex = 0;
        boolean unique = true;
        for (int ic = 0; ic < ncol; ++ic) {
            int isuf;
            Matcher matcher;
            String colName = ((StarTableColumn)colList.getColumn(ic)).getColumnInfo().getName();
            if (!colName.startsWith(baseName)) continue;
            if (colName.equals(baseName)) {
                unique = false;
            }
            if (!(matcher = suffixPattern.matcher(colName.substring(baseLeng))).matches()) continue;
            unique = false;
            String suffIndex = matcher.group(1);
            int n = isuf = suffIndex == null || suffIndex.length() == 0 ? 0 : Integer.parseInt(suffIndex);
            if (isuf < nextFreeIndex) continue;
            nextFreeIndex = isuf + 1;
        }
        if (unique) {
            return origName;
        }
        String newName = baseName + baseSuffix;
        if (nextFreeIndex > 0) {
            newName = newName + nextFreeIndex;
        }
        return newName;
    }

    private static Pattern suffixPattern(String baseSuffix) {
        return Pattern.compile("\\Q" + baseSuffix + "\\E" + "([0-9]*)$");
    }

    public static String getApplicationName() {
        return "TOPCAT";
    }

    public static String[] getAbout() {
        if (about_ == null) {
            about_ = new String[]{"This is TOPCAT - Tool for OPerations on Catalogues And Tables", "", "TOPCAT Version " + TopcatUtils.getVersion(), "STIL Version " + TopcatUtils.getSTILVersion(), "Starjava build: " + TopcatUtils.getRevision(), "JVM: " + InvokeUtils.getJavaVM(), "SPLAT: " + (TopcatUtils.canSplat() ? "available" : "absent"), "SoG: " + (TopcatUtils.canSog() ? "available" : "absent"), "", "Author: Mark Taylor (Bristol University)", "WWW: http://www.starlink.ac.uk/topcat/"};
        }
        return about_;
    }

    public static void memoryError(OutOfMemoryError e) {
        String title;
        int iopt;
        ControlWindow control = ControlWindow.getInstance();
        String nullOpt = "OK";
        String helpOpt = "Help!";
        Object[] options = new String[]{nullOpt, helpOpt};
        String msg = e.getMessage();
        if (msg == null || msg.trim().length() == 0) {
            msg = "Out of memory";
        }
        if ((iopt = JOptionPane.showOptionDialog(control, msg, title = "Out Of Memory", -1, 0, null, options, helpOpt)) > 0 && iopt < options.length && helpOpt.equals(options[iopt])) {
            HelpWindow helpWin = HelpWindow.getInstance(control);
            helpWin.makeVisible();
            helpWin.setID("largeTables");
        }
    }

    public static void memoryErrorLater(final OutOfMemoryError e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopcatUtils.memoryError(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSog() {
        if (canSog_ == null) {
            Class clazz = TopcatUtils.class;
            synchronized (clazz) {
                try {
                    Class.forName("uk.ac.starlink.sog.SOG");
                    Class.forName("javax.media.jai.util.CaselessStringKey");
                    canSog_ = Boolean.TRUE;
                }
                catch (Throwable th) {
                    logger_.info("No SoG: " + th);
                    logger_.log(Level.CONFIG, "SoG load error", th);
                    canSog_ = Boolean.FALSE;
                }
            }
        }
        return canSog_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSplat() {
        if (canSplat_ == null) {
            Class clazz = TopcatUtils.class;
            synchronized (clazz) {
                try {
                    Class.forName("uk.ac.starlink.splat.data.SpecData");
                    canSplat_ = AstPackage.isAvailable() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable th) {
                    logger_.info("No SPLAT: " + th);
                    logger_.log(Level.CONFIG, "SPLAT load error", th);
                    canSplat_ = Boolean.FALSE;
                }
            }
        }
        return canSplat_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canExec() {
        if (canExec_ == null) {
            Class clazz = TopcatUtils.class;
            synchronized (clazz) {
                SecurityManager sman = System.getSecurityManager();
                if (sman != null) {
                    try {
                        sman.checkExec(null);
                    }
                    catch (SecurityException e) {
                        logger_.warning("Security manager forbids system execution");
                        canExec_ = Boolean.FALSE;
                    }
                }
                canExec_ = Boolean.TRUE;
            }
        }
        return canExec_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canJel() {
        if (canJel_ == null) {
            boolean can;
            Class clazz = TopcatUtils.class;
            synchronized (clazz) {
                SecurityManager sman = System.getSecurityManager();
                if (sman != null) {
                    try {
                        sman.checkCreateClassLoader();
                        can = true;
                    }
                    catch (SecurityException e) {
                        logger_.warning("Security manager forbids JEL use");
                        can = false;
                    }
                } else {
                    can = true;
                }
            }
            canJel_ = can;
        }
        return canJel_;
    }

    public static String getVersion() {
        return IOUtils.getResourceContents((Class)AuxWindow.class, (String)VERSION_RESOURCE);
    }

    public static String getRevision() {
        return IOUtils.getResourceContents((Class)AuxWindow.class, (String)"revision-string");
    }

    public static String getSTILVersion() {
        return IOUtils.getResourceContents((Class)StarTable.class, (String)"stil.version");
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
        DEMO_LOCATION = "uk/ac/starlink/topcat/demo";
        DEMO_TABLE = "6dfgs_mini.xml.bz2";
        DEMO_NODES = "demo_list";
        COLID_INFO = new DefaultValueInfo("$ID", String.class, "Unique column ID");
        BASE_DESCRIPTION_INFO = new DefaultValueInfo("Base Description", String.class, "Description omitting expression");
        EXPR_INFO = new DefaultValueInfo("Expression", String.class, "Algebraic expression for column value");
        NUMERIC_CONVERTER_INFO = new DefaultValueInfo("Decoder", ValueConverter.class, "Converts from string to numeric values");
        ACTIVATORS_INFO = new DefaultValueInfo("topcat-activation", String.class, "Action which can be performed on row activation");
        TIME_INFO = new DefaultValueInfo("time", Number.class, "Epoch");
        ((DefaultValueInfo)TIME_INFO).setUCD("TIME");
    }
}

