/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import uk.ac.starlink.topcat.BasicAction;

public abstract class WindowAction
extends BasicAction {
    public static final String HIDE = "HIDE";
    public static final String SHOW = "SHOW";
    public static final String VISIBLE = "VISIBLE";
    private ActionEvent currentEvent;

    protected WindowAction(String name, Icon icon, String shortdesc) {
        super(name, icon, shortdesc);
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        boolean show = !HIDE.equals(cmd);
        this.currentEvent = evt;
        this.putValue(VISIBLE, show);
        this.currentEvent = null;
    }

    public Object getValue(String key) {
        if (VISIBLE.equals(key)) {
            return this.hasWindow() && this.getWindow(null).isShowing();
        }
        return super.getValue(key);
    }

    public void putValue(String key, Object newValue) {
        if (VISIBLE.equals(key)) {
            Window win;
            boolean wasVisible;
            boolean show = (Boolean)newValue;
            if (show) {
                boolean windowCreated = !this.hasWindow();
                Window win2 = this.getWindow(this.getEventWindow(this.currentEvent));
                boolean wasVisible2 = !windowCreated && win2.isShowing();
                win2.show();
                if (!wasVisible2) {
                    this.firePropertyChange(VISIBLE, Boolean.FALSE, Boolean.TRUE);
                }
                if (windowCreated) {
                    win2.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent evt) {
                            WindowAction.this.firePropertyChange(WindowAction.VISIBLE, Boolean.TRUE, Boolean.FALSE);
                        }
                    });
                }
            } else if (this.hasWindow() && (wasVisible = (win = this.getWindow(null)).isShowing())) {
                this.getWindow(null).dispose();
                this.firePropertyChange(VISIBLE, Boolean.TRUE, Boolean.FALSE);
            }
        } else {
            super.putValue(key, newValue);
        }
    }

    public abstract Window getWindow(Component var1);

    public abstract boolean hasWindow();

    public JToggleButton getButton() {
        final JToggleButton button = new JToggleButton();
        button.setIcon((Icon)this.getValue("SmallIcon"));
        button.setToolTipText((String)this.getValue("Name"));
        button.setModel(new JToggleButton.ToggleButtonModel(){

            public boolean isSelected() {
                return (Boolean)WindowAction.this.getValue(WindowAction.VISIBLE);
            }

            public void setSelected(boolean vis) {
                WindowAction.this.putValue(WindowAction.VISIBLE, vis);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (WindowAction.VISIBLE.equals(evt.getPropertyName())) {
                    button.setSelected(button.isSelected());
                }
            }
        });
        return button;
    }
}

