/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.contrib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;

public class GavoCSVTableParser {
    final StoragePolicy storage;
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_COMMENT_PREFIX = "#";
    private static final String QUOTE = "\"";
    private RecursiveDescentParser recursiveDescentParser = new RecursiveDescentParser();

    public GavoCSVTableParser(StoragePolicy storage) {
        this(storage, DEFAULT_DELIMITER);
    }

    public GavoCSVTableParser(StoragePolicy storage, String delimiter) {
        this.storage = storage;
        this.setDelimiter(delimiter);
    }

    public String getCommentPrefix() {
        return DEFAULT_COMMENT_PREFIX;
    }

    public void setDelimiter(String delimiter) {
        this.recursiveDescentParser.setDelimiter(delimiter);
    }

    public String getDelimiter() {
        return this.recursiveDescentParser.getDelimiter();
    }

    public List parseLine(String line) {
        return this.recursiveDescentParser.parse(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StarTable parse(InputStream stream) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        if (line.startsWith("#OK")) {
            Vector<String> columnLines = new Vector<String>();
            while ((line = reader.readLine()) != null && line.startsWith(DEFAULT_COMMENT_PREFIX)) {
                if (!line.startsWith("#COLUMN")) continue;
                columnLines.add(line);
            }
            final ColumnInfo[] columnInfo = new ColumnInfo[columnLines.size()];
            int dim = columnLines.size();
            int[] types = new int[dim];
            for (int i = 0; i < dim; ++i) {
                String columnLine = (String)columnLines.get(i);
                int index1 = columnLine.indexOf("JDBC_TYPE=") + 10;
                int index2 = columnLine.indexOf(" ", index1);
                types[i] = Integer.parseInt(columnLine.substring(index1, index2));
                Class type = GavoCSVTableParser.classForJDBCType(types[i]);
                index1 = columnLine.indexOf("name=") + 5;
                index2 = columnLine.indexOf(" ", index1);
                String name = columnLine.substring(index1, index2);
                columnInfo[i] = new ColumnInfo(name, type, "");
            }
            AbstractStarTable metaData = new AbstractStarTable(){

                public int getColumnCount() {
                    return columnInfo.length;
                }

                public ColumnInfo getColumnInfo(int icol) {
                    return columnInfo[icol];
                }

                public long getRowCount() {
                    return -1L;
                }

                public RowSequence getRowSequence() {
                    throw new UnsupportedOperationException();
                }
            };
            RowStore rowStore = this.storage.makeConfiguredRowStore((StarTable)metaData);
            try {
                Object[] row = null;
                while ((line = reader.readLine()) != null) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (line.startsWith("#ERROR")) {
                        StringBuffer sb = new StringBuffer(line);
                        while ((line = reader.readLine()) != null && sb.length() < 8096) {
                            sb.append(line + "\n");
                        }
                        throw new IOException(sb.toString());
                    }
                    List cells_ = this.parseLine(line);
                    String[] cells = cells_.toArray(new String[0]);
                    row = new Object[dim];
                    for (int i = 0; i < dim; ++i) {
                        row[i] = GavoCSVTableParser.objectForJDBCType(types[i], cells[i]);
                    }
                    rowStore.acceptRow(row);
                }
            }
            finally {
                rowStore.endRows();
                reader.close();
            }
            return Tables.randomTable((StarTable)rowStore.getStarTable());
        }
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null && sb.length() < 8096) {
            sb.append(line + "\n");
        }
        throw new IOException("Error\n" + sb.toString());
    }

    public static Class classForJDBCType(int jdbcType) {
        switch (jdbcType) {
            case -5: {
                return Long.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Short.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
        }
        return String.class;
    }

    public static Object objectForJDBCType(int jdbcType, String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        switch (jdbcType) {
            case -5: {
                return Long.valueOf(value);
            }
            case 4: {
                return Integer.valueOf(value);
            }
            case 5: {
                return Short.valueOf(value);
            }
            case 6: 
            case 8: {
                return Double.valueOf(value);
            }
            case 7: {
                return Float.valueOf(value);
            }
        }
        return value;
    }

    public static class RecursiveDescentParser {
        private static final boolean DEBUG = false;
        private String lastToken;
        private String nextToken;
        private StringTokenizer stringTokenizer;
        private String delimiter = ",";
        private StringBuffer currentItem = new StringBuffer();
        private List itemList;
        private String line;

        public RecursiveDescentParser() {
        }

        public RecursiveDescentParser(String line) {
            this.setLine(line);
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setLine(String line) {
            this.line = line;
            if (line == null) {
                System.out.println("help");
            }
            this.stringTokenizer = new StringTokenizer(line, this.delimiter + GavoCSVTableParser.QUOTE, true);
        }

        public String getLine() {
            return this.line;
        }

        public List parse(String line) {
            this.setLine(line);
            this.parse();
            return this.itemList;
        }

        public List parse() {
            if (this.stringTokenizer == null) {
                return null;
            }
            this.itemList = new ArrayList();
            this.parseLine();
            if (this.delimiter.equals(this.lastToken)) {
                this.itemList.add("");
            }
            return this.itemList;
        }

        private void consumeToken() {
            this.lastToken = this.nextToken;
            this.nextToken = null;
        }

        private boolean moreTokens() {
            return this.nextToken != null || this.stringTokenizer.hasMoreTokens();
        }

        private String nextToken() {
            if (this.nextToken == null && this.stringTokenizer.hasMoreTokens()) {
                this.nextToken = this.stringTokenizer.nextToken();
            }
            return this.nextToken;
        }

        private void parseError(String msg) {
            throw new IllegalArgumentException("Parse error: " + msg);
        }

        private void parseLine() {
            if (this.moreTokens()) {
                String token = this.nextToken();
                if (this.delimiter.equals(token)) {
                    this.itemList.add("");
                    this.consumeToken();
                    this.parseLine();
                } else if (GavoCSVTableParser.QUOTE.equals(token)) {
                    this.consumeToken();
                    this.currentItem = new StringBuffer();
                    this.parseQuotedWords();
                    this.parseLine();
                } else {
                    this.parseUnquotedWords();
                    this.parseLine();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parseQuotedWords() {
            String token = this.nextToken();
            if (token == null) {
                this.parseError("Expected quoted string, but found <EOL>");
                return;
            }
            if (this.delimiter.equals(token)) {
                this.currentItem.append(this.delimiter);
                this.consumeToken();
                this.parseQuotedWords();
                return;
            }
            if (!GavoCSVTableParser.QUOTE.equals(token)) {
                this.currentItem.append(token);
                this.consumeToken();
                this.parseQuotedWords();
                return;
            }
            this.consumeToken();
            this.nextToken = this.nextToken();
            if (GavoCSVTableParser.QUOTE.equals(this.nextToken)) {
                this.currentItem.append(GavoCSVTableParser.QUOTE);
                this.consumeToken();
                this.parseQuotedWords();
                return;
            }
            this.itemList.add(this.currentItem.toString());
            this.consumeToken();
        }

        private void parseUnquotedWords() {
            this.itemList.add(this.nextToken());
            this.consumeToken();
            String nextToken = this.nextToken();
            if (nextToken == null) {
                return;
            }
            if (!this.delimiter.equals(nextToken)) {
                String msg = "This shouldn't happen.";
                this.parseError(msg);
                throw new IllegalStateException(msg);
            }
            this.consumeToken();
        }
    }
}

