/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.contrib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import sun.misc.BASE64Encoder;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.BasicTableLoadDialog;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.topcat.contrib.GavoCSVTableParser;
import uk.ac.starlink.topcat.contrib.GavoSampleQuery;

public class GavoTableLoadDialog
extends BasicTableLoadDialog {
    private int nquery = 0;
    private static final String MILL_URL = "http://www.g-vo.org/Millennium";
    private static final String MYMILL_URL = "http://www.g-vo.org/MyMillennium";
    private static final String QUERY_TRAIL = "?action=doQuery&SQL=";
    private static final Database[] DATABASES = new Database[]{new Database("http://www.g-vo.org/Millennium", "http://www.g-vo.org/Millennium?action=doQuery&SQL=", false), new Database("http://www.g-vo.org/MyMillennium", "http://www.g-vo.org/MyMillennium?action=doQuery&SQL=", true)};
    private static final ValueInfo URL_INFO = new DefaultValueInfo("Database", String.class, "Base URL of database providing results");
    private static final ValueInfo SQL_INFO = new DefaultValueInfo("SQL", String.class, "Text of SQL query");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat.contrib");
    private final JComboBox urlField_ = new JComboBox<Database>(DATABASES);
    private final JTextField userField_;
    private final JPasswordField passField_;
    private final JEditorPane sqlField_;

    public GavoTableLoadDialog() {
        super("GAVO Millennium Run Query", "Uses the GAVO service to query the Millennium Simulation Database");
        this.urlField_.setEditable(true);
        this.userField_ = new JTextField();
        this.passField_ = new JPasswordField();
        this.sqlField_ = new JEditorPane();
        this.sqlField_.setEditable(true);
        LabelledComponentStack stack = new LabelledComponentStack();
        stack.addLine("Base URL", (Component)this.urlField_);
        stack.addLine("User", (Component)this.userField_);
        final JLabel userLabel = stack.getLabels()[stack.getLabels().length - 1];
        stack.addLine("Password", (Component)this.passField_);
        final JLabel passLabel = stack.getLabels()[stack.getLabels().length - 1];
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionListener urlListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Database db = GavoTableLoadDialog.this.getSelectedDatabase();
                boolean acceptsAuth = db != null && db.acceptsAuth_;
                userLabel.setEnabled(acceptsAuth);
                GavoTableLoadDialog.this.userField_.setEnabled(acceptsAuth);
                passLabel.setEnabled(acceptsAuth);
                GavoTableLoadDialog.this.passField_.setEnabled(acceptsAuth);
            }
        };
        urlListener.actionPerformed(null);
        this.urlField_.addActionListener(urlListener);
        JPanel sqlHolder = new JPanel(new BorderLayout());
        Box labelBox = Box.createVerticalBox();
        labelBox.add(new JLabel("SQL Query: "));
        labelBox.add(Box.createVerticalGlue());
        sqlHolder.add((Component)labelBox, "West");
        sqlHolder.add((Component)new JScrollPane(this.sqlField_), "Center");
        sqlHolder.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)stack, "North");
        this.add(sqlHolder, "Center");
        this.setPreferredSize(new Dimension(400, 300));
    }

    protected JDialog createDialog(Component parent) {
        JDialog dialog = super.createDialog(parent);
        JMenuBar mbar = new JMenuBar();
        dialog.setJMenuBar(mbar);
        JMenu sampleMenu = new JMenu("SampleQueries");
        mbar.add(sampleMenu);
        GavoSampleQuery[] queries = GavoSampleQuery.SAMPLES;
        for (int i = 0; i < queries.length; ++i) {
            GavoSampleQuery sample = queries[i];
            final String sqlText = sample.getText();
            AbstractAction act = new AbstractAction(sample.getName()){

                public void actionPerformed(ActionEvent evt) {
                    GavoTableLoadDialog.this.sqlField_.setText(sqlText);
                }
            };
            act.putValue("ShortDescription", sample.getDescription());
            sampleMenu.add(act);
        }
        return dialog;
    }

    public boolean isAvailable() {
        return true;
    }

    private Database getSelectedDatabase() {
        Object db = this.urlField_.getSelectedItem();
        if (db instanceof Database) {
            return (Database)db;
        }
        if (db instanceof String && ((String)db).trim().length() > 0) {
            String baseUrl = (String)db;
            return new Database(baseUrl, baseUrl + QUERY_TRAIL, true);
        }
        return null;
    }

    protected BasicTableLoadDialog.TableSupplier getTableSupplier() {
        URL queryUrl;
        String sqlEncoding;
        Database db = this.getSelectedDatabase();
        if (db == null) {
            throw new IllegalArgumentException("No database URL provided");
        }
        final boolean acceptsAuth = db.acceptsAuth_;
        final String url = db.url_;
        String user = acceptsAuth ? this.userField_.getText() : "";
        String pass = acceptsAuth ? new String(this.passField_.getPassword()) : null;
        final String sql = this.sqlField_.getText();
        if (sql == null || sql.trim().length() == 0) {
            throw new IllegalArgumentException("No SQL query provided");
        }
        ++this.nquery;
        try {
            sqlEncoding = URLEncoder.encode(sql, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Do what?");
        }
        String userPassword = user + ":" + pass;
        final String encoding = new BASE64Encoder().encode(userPassword.getBytes());
        String urlString = url + sqlEncoding;
        try {
            queryUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad url: " + url).initCause(e);
        }
        final String id = db.toString() + " query " + this.nquery;
        return new BasicTableLoadDialog.TableSupplier(){

            public StarTable getTable(StarTableFactory tabFact, String fmt) throws IOException {
                StarTable table;
                URLConnection uc = queryUrl.openConnection();
                if (acceptsAuth) {
                    uc.setRequestProperty("Authorization", "Basic " + encoding);
                }
                if (uc instanceof HttpURLConnection) {
                    HttpURLConnection huc = (HttpURLConnection)uc;
                    int code = huc.getResponseCode();
                    if (code == 401) {
                        throw new ConnectException("Authorisation failed\nCheck username/password");
                    }
                    if (code >= 400) {
                        throw new ConnectException("Connection failed:\n" + code + " " + huc.getResponseMessage());
                    }
                    logger_.info("URL response: " + code);
                }
                InputStream stream = uc.getInputStream();
                logger_.info("Content type = " + uc.getContentType());
                GavoCSVTableParser csvParser = new GavoCSVTableParser(tabFact.getStoragePolicy());
                try {
                    table = csvParser.parse(stream);
                }
                catch (Throwable e) {
                    throw BasicTableLoadDialog.asIOException((Throwable)e);
                }
                finally {
                    stream.close();
                }
                table.setParameter(new DescribedValue(URL_INFO, (Object)url));
                table.setParameter(new DescribedValue(SQL_INFO, (Object)sql));
                return table;
            }

            public String getTableID() {
                return id;
            }
        };
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlField_.setEnabled(enabled);
        this.userField_.setEnabled(enabled);
        this.passField_.setEnabled(enabled);
        this.sqlField_.setEnabled(enabled);
    }

    private static class Database {
        final String name_;
        final String url_;
        final boolean acceptsAuth_;

        Database(String name, String url, boolean acceptsAuth) {
            this.name_ = name;
            this.acceptsAuth_ = acceptsAuth;
            this.url_ = url;
        }

        public String toString() {
            return this.name_;
        }
    }
}

