/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.doc;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ButtonIcon {
    private static final int SIZE = 24;
    private final BufferedImage image_ = new BufferedImage(24, 24, 2);

    public Graphics2D createGraphics() {
        Graphics2D g2 = this.image_.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2;
    }

    public void writeGif(String fname) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fname));
        new GifEncoder((Image)this.image_, (OutputStream)out).encode();
        ((OutputStream)out).close();
        System.out.println("Output image: " + fname);
    }

    public static ButtonIcon createRadial() {
        ButtonIcon bi = new ButtonIcon();
        Graphics2D g2 = bi.createGraphics();
        g2.translate(12, 12);
        g2.setColor(new Color(190, 190, 190));
        g2.fillOval(-10, -10, 20, 20);
        g2.setColor(new Color(128, 128, 128));
        g2.drawOval(-10, -10, 20, 20);
        g2.setColor(Color.BLACK);
        g2.drawOval(-11, -11, 22, 22);
        g2.setColor(new Color(0, 0, 96));
        ButtonIcon.drawArrow(g2, Math.toRadians(45.0), 9);
        ButtonIcon.drawArrow(g2, Math.toRadians(270.0), 7);
        ButtonIcon.drawArrow(g2, Math.toRadians(135.0), 5);
        return bi;
    }

    private static void drawArrow(Graphics2D g2, double theta, int leng) {
        int head = 2;
        g2.rotate(theta);
        g2.drawLine(0, 0, 0, leng);
        g2.drawLine(0, leng, -2, leng - 2);
        g2.drawLine(0, leng, 2, leng - 2);
        g2.rotate(-theta);
    }

    public static void main(String[] args) throws IOException {
        ButtonIcon.createRadial().writeGif("clock1.gif");
    }
}

