/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.doc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import uk.ac.starlink.topcat.TopcatJELUtils;
import uk.ac.starlink.ttools.build.XmlDoclet;

public class SummaryXmlDoclet
extends XmlDoclet {
    private boolean discardOutput_;
    private Class[] classes_;
    private boolean headOnly_;
    private boolean skipMembers_;

    public static boolean start(RootDoc root) throws IOException {
        return new SummaryXmlDoclet(root).process();
    }

    public static int optionLength(String option) {
        if (option.equals("-gen")) {
            return 1;
        }
        if (option.equals("-act")) {
            return 1;
        }
        if (option.equals("-headonly")) {
            return 1;
        }
        return XmlDoclet.optionLength((String)option);
    }

    protected SummaryXmlDoclet(RootDoc root) throws IOException {
        super(root);
        String[][] options = root.options();
        for (int i = 0; i < options.length; ++i) {
            String opt = options[i][0];
            if (opt.equals("-gen")) {
                this.classes_ = TopcatJELUtils.getStaticClasses().toArray(new Class[0]);
                continue;
            }
            if (opt.equals("-act")) {
                this.classes_ = TopcatJELUtils.getActivationStaticClasses().toArray(new Class[0]);
                continue;
            }
            if (!opt.equals("-headonly")) continue;
            this.headOnly_ = true;
        }
    }

    protected boolean process() throws IOException {
        if (this.headOnly_) {
            this.out("<dl>");
        }
        boolean ret = super.process();
        if (this.headOnly_) {
            this.out("</dl>");
        }
        this.flush();
        return ret;
    }

    protected void startClass(ClassDoc clazz) throws IOException {
        boolean bl = this.discardOutput_ = !this.useClass(clazz);
        if (this.headOnly_) {
            this.out("<dt>" + clazz.name() + "</dt>");
            this.out("<dd>");
        } else {
            this.out("<subsubsect id=\"" + clazz.name() + "\">");
            this.out("<subhead><title>" + clazz.name() + "</title></subhead>");
        }
        String comment = clazz.commentText();
        if (comment != null) {
            this.out(SummaryXmlDoclet.doctorText((String)comment));
        }
        if (this.headOnly_ && !this.discardOutput_) {
            this.skipMembers_ = true;
            this.discardOutput_ = true;
        }
        this.out("<p><dl>");
    }

    protected void endClass() throws IOException {
        this.out("</dl></p>");
        if (this.skipMembers_) {
            this.discardOutput_ = false;
            this.skipMembers_ = false;
        }
        if (this.headOnly_) {
            this.out("</dd>");
        } else {
            this.out("</subsubsect>");
        }
        this.discardOutput_ = false;
    }

    protected void startMember(MemberDoc mem, String memType, String memName) throws IOException {
        this.out("<dt>" + memName + "</dt>");
        String comment = mem.commentText();
        if (comment != null) {
            this.out("<dd>" + SummaryXmlDoclet.doctorText((String)comment) + "</dd>");
        }
    }

    protected void endMember() {
    }

    private boolean useClass(ClassDoc classDoc) {
        if (this.classes_ == null) {
            return true;
        }
        String cname = classDoc.qualifiedName();
        for (int i = 0; i < this.classes_.length; ++i) {
            if (!this.classes_[i].getName().equals(cname)) continue;
            return true;
        }
        return false;
    }

    public void out(String line) throws IOException {
        if (!this.discardOutput_) {
            super.out(line);
        }
    }
}

