/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.topcat.HtmlWindow;
import uk.ac.starlink.topcat.func.Executor;
import uk.ac.starlink.topcat.func.System;

public class Browsers {
    private static HtmlWindow htmlWindow_;
    private static BrowserLauncher browserLauncher_;

    private Browsers() {
    }

    public static String basicBrowser(String url) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        URL url1 = null;
        try {
            File f = new File(url);
            if (f.exists()) {
                url1 = f.toURI().toURL();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (url1 == null) {
            try {
                url1 = new URL(url);
            }
            catch (MalformedURLException e) {
                return "Bad URL: " + url;
            }
        }
        try {
            Browsers.getHtmlWindow().setURL(url1);
            return url;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (e == null) {
                msg = e.toString();
            }
            return msg + ": " + url;
        }
    }

    public static String systemBrowser(String url) {
        try {
            if (browserLauncher_ == null) {
                browserLauncher_ = new BrowserLauncher();
                browserLauncher_.setNewWindowPolicy(false);
            }
            browserLauncher_.openURLinBrowser(url);
            return url;
        }
        catch (UnsupportedOperatingSystemException e) {
            String msg = e.getMessage();
            if (e == null) {
                msg = e.toString();
            }
            return msg + ": " + url;
        }
        catch (BrowserLaunchingInitializingException e) {
            String msg = e.getMessage();
            if (e == null) {
                msg = e.toString();
            }
            return msg + ": " + url;
        }
    }

    public static String mozilla(String url) {
        return Browsers.mozalike("mozilla", url);
    }

    public static String firefox(String url) {
        return Browsers.mozalike("firefox", url);
    }

    public static String netscape(String url) {
        return Browsers.mozalike("netscape", url);
    }

    public static String mozalike(String cmd, String url) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        String[] argv = new String[]{cmd, "-remote", "openURL(" + url + ")"};
        return System.execute(Executor.createExecutor(argv));
    }

    private static HtmlWindow getHtmlWindow() {
        if (htmlWindow_ == null) {
            htmlWindow_ = new HtmlWindow(null);
        }
        if (!htmlWindow_.isShowing()) {
            htmlWindow_.setVisible(true);
        }
        return htmlWindow_;
    }
}

