/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import java.io.IOException;
import java.io.InputStream;

abstract class Executor {
    private boolean done_;
    private String out_;
    private String err_;

    Executor() {
    }

    abstract Process getProcess() throws IOException;

    abstract String getLine();

    public String getOut() {
        return this.out_;
    }

    public String getErr() {
        return this.err_;
    }

    public int executeSynchronously() throws IOException, InterruptedException {
        if (this.done_) {
            throw new IllegalStateException();
        }
        this.done_ = true;
        Process proc = this.getProcess();
        ReaderThread outReader = new ReaderThread(proc.getInputStream());
        ReaderThread errReader = new ReaderThread(proc.getErrorStream());
        outReader.start();
        errReader.start();
        int status = proc.waitFor();
        outReader.join(500L);
        errReader.join(500L);
        outReader.interrupt();
        errReader.interrupt();
        this.out_ = outReader.getData();
        this.err_ = errReader.getData();
        return status;
    }

    public String toString() {
        return this.getLine();
    }

    public static Executor createExecutor(final String line) {
        return new Executor(){

            public Process getProcess() throws IOException {
                return Runtime.getRuntime().exec(line);
            }

            public String getLine() {
                return line;
            }
        };
    }

    public static Executor createExecutor(final String[] argv) {
        return new Executor(){

            public Process getProcess() throws IOException {
                return Runtime.getRuntime().exec(argv);
            }

            public String getLine() {
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < argv.length; ++i) {
                    if (i > 0) {
                        sbuf.append(' ');
                    }
                    sbuf.append(argv[i]);
                }
                return sbuf.toString();
            }
        };
    }

    private static class ReaderThread
    extends Thread {
        final InputStream strm_;
        final StringBuffer buf_;

        ReaderThread(InputStream strm) {
            this.strm_ = strm;
            this.buf_ = new StringBuffer();
        }

        public String getData() {
            return this.buf_.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int c;
                while ((c = this.strm_.read()) >= 0 && !this.isInterrupted()) {
                    this.buf_.append((char)c);
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.strm_.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

