/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.splat.data.SpecData;
import uk.ac.starlink.splat.data.SpecDataComp;
import uk.ac.starlink.splat.data.SpecDataFactory;
import uk.ac.starlink.splat.iface.PlotControlFrame;
import uk.ac.starlink.splat.iface.SplatBrowser;
import uk.ac.starlink.splat.iface.SplatBrowserMain;
import uk.ac.starlink.splat.plot.PlotControl;
import uk.ac.starlink.splat.util.SplatException;
import uk.ac.starlink.topcat.TopcatUtils;

public class Splat {
    private static SplatBrowser splat_;
    private static Map splatSpectra_;
    private static Map splatPlotFrames_;

    private Splat() {
    }

    public static String splat(String label, String loc) {
        return Splat.splatMulti(label, new String[]{loc});
    }

    public static String splat2(String label, String loc1, String loc2) {
        return Splat.splatMulti(label, new String[]{loc1, loc2});
    }

    public static String splatMulti(String label, String[] locs) {
        if (!TopcatUtils.canSplat()) {
            return "Error: SPLAT classes not available";
        }
        SplatBrowser splat = Splat.getSplat();
        int nsplat = locs.length;
        String[] msgs = new String[nsplat];
        SpecDataFactory splatFac = SpecDataFactory.getInstance();
        SpecDataComp specGroup = new SpecDataComp();
        for (int i = 0; i < nsplat; ++i) {
            SpecData spec;
            String loc = locs[i];
            if (loc == null || loc.trim().length() == 0) {
                msgs[i] = null;
                continue;
            }
            if (!splatSpectra_.containsKey(loc = loc.trim())) {
                try {
                    spec = splatFac.get(loc);
                    splat.addSpectrum(spec);
                    splatSpectra_.put(loc, spec);
                    specGroup.add(spec);
                    msgs[i] = loc;
                }
                catch (Exception e) {
                    splatSpectra_.put(loc, null);
                    msgs[i] = "<Error: " + e.getMessage() + ">";
                }
                continue;
            }
            if (loc != null) {
                spec = (SpecData)splatSpectra_.get(loc);
                if (spec != null) {
                    msgs[i] = loc;
                    try {
                        specGroup.add(spec);
                    }
                    catch (SplatException e) {
                        splatSpectra_.put(loc, null);
                        msgs[i] = "<Error: " + e.getMessage() + ">";
                    }
                    continue;
                }
                msgs[i] = "<No data>";
                continue;
            }
            msgs[i] = "<No data>";
        }
        StringBuffer sbuf = new StringBuffer().append("splat(");
        for (int i = 0; i < nsplat; ++i) {
            if (i > 0) {
                sbuf.append(',');
            }
            sbuf.append(msgs[i]);
        }
        sbuf.append(")");
        String msg = sbuf.toString();
        if (specGroup.count() > 0) {
            PlotControlFrame plotFrame = Splat.getPlotFrame(label, specGroup);
            PlotControl splatPlot = plotFrame.getPlot();
            if (splatPlot != null) {
                try {
                    splatPlot.setSpecDataComp(specGroup);
                    splatPlot.updateThePlot(null);
                }
                catch (SplatException e) {
                    return "<SPLAT Error: " + e.getMessage() + ">";
                }
            }
            if (!plotFrame.isShowing()) {
                plotFrame.show();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplatBrowser getSplat() {
        if (splat_ == null) {
            Class clazz = Splat.class;
            synchronized (clazz) {
                SplatBrowserMain.guessProperties((boolean)false);
                splat_ = new SplatBrowser(true);
                splat_.setExtendedState(1);
            }
        }
        splat_.setVisible(true);
        return splat_;
    }

    private static PlotControlFrame getPlotFrame(String label, SpecDataComp specGroup) {
        if (!splatPlotFrames_.containsKey(label)) {
            PlotControlFrame frame = Splat.getSplat().displaySpectrum(specGroup.get(0));
            splatPlotFrames_.put(label, frame);
        }
        return (PlotControlFrame)splatPlotFrames_.get(label);
    }

    static {
        splatSpectra_ = new HashMap();
        splatPlotFrames_ = new HashMap();
    }
}

