/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.func;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.topcat.func.Image;
import uk.ac.starlink.topcat.func.TopcatCgiQuery;
import uk.ac.starlink.ttools.func.Coords;
import uk.ac.starlink.util.FileDataSource;

public class SuperCosmos {
    public static final String SSS_BASE_URL = "http://www-wfau.roe.ac.uk/~sss/cgi-bin/sss_topcat_pix.cgi";
    private static final Band UKST_B = new Band(1, "UK Schmidt Blue");
    private static final Band UKST_R = new Band(2, "UK Schmidt Red");
    private static final Band UKST_I = new Band(3, "UK Schmidt Infrared");
    private static final Band ESO_R = new Band(4, "ESO Red");
    private static final Band POSS_E = new Band(5, "Palomar E");
    private static final Band BLUE = new Band("blue", "Blue");
    private static final Band RED = new Band("red", "Red");
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.topcat.func");

    private SuperCosmos() {
    }

    public static String sssCutout(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, null);
    }

    public static String sssCutout(double ra, double dec) {
        return SuperCosmos.sssCutout(ra, dec, 128);
    }

    public static String sssCutoutBlue(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, BLUE);
    }

    public static String sssCutoutRed(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, RED);
    }

    public static String displayUkstB(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, UKST_B);
    }

    public static String displayUkstR(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, UKST_R);
    }

    public static String displayUkstI(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, UKST_I);
    }

    public static String displayEsoR(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, ESO_R);
    }

    public static String displayPossE(double ra, double dec, int pixels) {
        return SuperCosmos.sssCutout(ra, dec, pixels, POSS_E);
    }

    private static String sssCutout(double ra, double dec, int pixels, Band waveband) {
        int irange = (int)((double)pixels * 100.0 / 90.0);
        double range = (double)irange / 100.0;
        return SuperCosmos.sssCutout(ra, dec, "image/x-gfits", range, range, waveband);
    }

    private static String sssCutout(double ra, double dec, String mimeType, double x, double y, Band waveband) {
        final TopcatCgiQuery query = (TopcatCgiQuery)new TopcatCgiQuery(SSS_BASE_URL).addArgument("ra", Coords.radiansToHms((double)ra, (int)5).trim()).addArgument("dec", Coords.radiansToDms((double)dec, (int)4).trim()).addArgument("mime-type", mimeType).addArgument("x", x).addArgument("y", y);
        if (waveband != null) {
            query.addArgument("waveband", waveband.id_);
        }
        final String label = waveband == null ? "SuperCOSMOS Sky Surveys" : "SuperCOSMOS Sky Surveys (" + waveband.name_ + ")";
        new Thread(){

            public void run() {
                try {
                    File file = query.executeAsLocalFile(".fits.gz");
                    FileDataSource datsrc = new FileDataSource(file);
                    if (FitsConstants.isMagic((byte[])datsrc.getIntro())) {
                        SwingUtilities.invokeLater(new Runnable(this, file){
                            private final /* synthetic */ File val$file;
                            private final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = this$0;
                                this.val$file = val$file;
                            }

                            public void run() {
                                Image.displayImage(1.access$000(this.this$0), this.val$file.toString());
                            }
                        });
                    } else {
                        String msg = new String(datsrc.getIntro());
                        msg = msg.replaceAll("\\s+", " ").replaceFirst("<br>.*", "");
                        logger.warning(msg);
                    }
                }
                catch (IOException e) {
                    logger.warning(e.toString());
                }
            }

            static /* synthetic */ String access$000(1 x0) {
                return x0.label;
            }
        }.start();
        return query.toString();
    }

    private static class Band {
        final String id_;
        final String name_;

        Band(int id, String name) {
            this.id_ = Integer.toString(id);
            this.name_ = name;
        }

        Band(String id, String name) {
            this.id_ = id;
            this.name_ = name;
        }
    }
}

