/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.event.ChangeListener;
import nom.tam.fits.FitsException;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.HubManager;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.PlasticHub;
import uk.ac.starlink.plastic.PlasticListWindow;
import uk.ac.starlink.plastic.PlasticTransmitter;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.HelpAction;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SubsetWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.interop.ImageActivity;
import uk.ac.starlink.topcat.interop.PlasticImageActivity;
import uk.ac.starlink.topcat.interop.RowActivity;
import uk.ac.starlink.topcat.interop.SkyPointActivity;
import uk.ac.starlink.topcat.interop.SubsetActivity;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.topcat.interop.TopcatPlasticListener;
import uk.ac.starlink.topcat.interop.TopcatTransmitter;
import uk.ac.starlink.topcat.interop.Transmitter;
import uk.ac.starlink.topcat.plot.DensityWindow;
import uk.ac.starlink.util.URLUtils;

public class PlasticCommunicator
implements TopcatCommunicator {
    private final ControlWindow control_;
    private final TopcatPlasticListener plasticServer_;
    private final Transmitter tableTransmitter_;

    public PlasticCommunicator(ControlWindow control) {
        this.control_ = control;
        this.plasticServer_ = new TopcatPlasticListener(control);
        this.tableTransmitter_ = PlasticCommunicator.adaptTransmitter(this.plasticServer_.createTableTransmitter());
    }

    public String getProtocolName() {
        return "PLASTIC";
    }

    public boolean setActive() {
        boolean isReg;
        try {
            this.plasticServer_.register();
            isReg = true;
        }
        catch (IOException e) {
            isReg = false;
        }
        this.plasticServer_.setAutoRegister(5000);
        return isReg;
    }

    public Action[] getInteropActions() {
        HelpAction helpAct = new HelpAction("interop", this.control_);
        helpAct.putValue("Name", "Help on interoperability");
        helpAct.putValue("ShortDescription", "Show help on PLASTIC with details of supported messages");
        return new Action[]{this.plasticServer_.getRegisterAction(true), this.plasticServer_.getRegisterAction(false), new HubWatchAction(this.control_, this.plasticServer_), this.plasticServer_.getHubStartAction(true), this.plasticServer_.getHubStartAction(false), helpAct};
    }

    public Transmitter getTableTransmitter() {
        return this.tableTransmitter_;
    }

    public Transmitter createImageTransmitter(final DensityWindow densWin) {
        TopcatTransmitter ptrans = new TopcatTransmitter(this.plasticServer_, MessageId.FITS_LOADIMAGE, "FITS image"){

            protected void transmit(PlasticHubListener hub, URI clientId, ApplicationItem app) throws IOException {
                URI[] uRIArray;
                if (app == null) {
                    uRIArray = null;
                } else {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = app.getId();
                }
                URI[] recipients = uRIArray;
                PlasticCommunicator.transmitDensityFits(densWin, hub, clientId, recipients);
            }
        };
        return PlasticCommunicator.adaptTransmitter(ptrans);
    }

    public Transmitter createSubsetTransmitter(TopcatModel tcModel, SubsetWindow subSelector) {
        return PlasticCommunicator.adaptTransmitter(this.plasticServer_.createSubsetTransmitter(tcModel, subSelector));
    }

    public void startHub(boolean external) throws IOException {
        if (external) {
            PlasticUtils.startExternalHub((boolean)true);
        } else {
            PlasticHub.startHub(null, null);
        }
    }

    public SkyPointActivity createSkyPointActivity() {
        final ComboBoxModel selector = this.plasticServer_.createPlasticComboBoxModel(MessageId.SKY_POINT);
        return new SkyPointActivity(){

            public ComboBoxModel getTargetSelector() {
                return selector;
            }

            public void pointAtSky(double ra, double dec) throws IOException {
                URI[] uRIArray;
                Object item = selector.getSelectedItem();
                if (item instanceof ApplicationItem) {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = ((ApplicationItem)item).getId();
                } else {
                    uRIArray = null;
                }
                URI[] recipients = uRIArray;
                PlasticCommunicator.this.plasticServer_.pointAt(ra, dec, recipients);
            }
        };
    }

    public RowActivity createRowActivity() {
        final ComboBoxModel selector = this.plasticServer_.createPlasticComboBoxModel(MessageId.VOT_HIGHLIGHTOBJECT);
        return new RowActivity(){

            public ComboBoxModel getTargetSelector() {
                return selector;
            }

            public void highlightRow(TopcatModel tcModel, long lrow) throws IOException {
                URI[] uRIArray;
                Object item = selector.getSelectedItem();
                if (item instanceof ApplicationItem) {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = ((ApplicationItem)item).getId();
                } else {
                    uRIArray = null;
                }
                URI[] recipients = uRIArray;
                PlasticCommunicator.this.plasticServer_.highlightRow(tcModel, lrow, recipients);
            }
        };
    }

    public SubsetActivity createSubsetActivity() {
        final ComboBoxModel selector = this.plasticServer_.createPlasticComboBoxModel(MessageId.VOT_SHOWOBJECTS);
        return new SubsetActivity(){

            public ComboBoxModel getTargetSelector() {
                return selector;
            }

            public void selectSubset(TopcatModel tcModel, RowSubset rset) throws IOException {
                URI[] uRIArray;
                Object item = selector.getSelectedItem();
                if (item instanceof ApplicationItem) {
                    URI[] uRIArray2 = new URI[1];
                    uRIArray = uRIArray2;
                    uRIArray2[0] = ((ApplicationItem)item).getId();
                } else {
                    uRIArray = null;
                }
                URI[] recipients = uRIArray;
                PlasticCommunicator.this.plasticServer_.transmitSubset(tcModel, rset, recipients);
            }
        };
    }

    public ImageActivity createImageActivity() {
        return new PlasticImageActivity(this.plasticServer_);
    }

    public JComponent createInfoPanel() {
        return null;
    }

    public Action createWindowAction(Component parent) {
        return null;
    }

    public boolean isConnected() {
        return this.plasticServer_.getRegisteredId() != null;
    }

    public void addConnectionListener(ChangeListener listener) {
        this.plasticServer_.getRegisterToggle().addChangeListener(listener);
    }

    private static Transmitter adaptTransmitter(final PlasticTransmitter plasTrans) {
        return new Transmitter(){

            public Action getBroadcastAction() {
                return plasTrans.getBroadcastAction();
            }

            public JMenu createSendMenu() {
                return plasTrans.createSendMenu();
            }

            public void setEnabled(boolean isEnabled) {
                plasTrans.setEnabled(isEnabled);
            }
        };
    }

    private static void transmitDensityFits(DensityWindow densWin, final PlasticHubListener hub, final URI plasticId, final URI[] recipients) throws IOException {
        final File tmpfile = File.createTempFile("plastic", ".fits");
        final String tmpUrl = URLUtils.makeFileURL((File)tmpfile).toString();
        tmpfile.deleteOnExit();
        BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(tmpfile));
        try {
            densWin.exportFits(ostrm);
        }
        catch (IOException e) {
            tmpfile.delete();
            throw e;
        }
        catch (FitsException e) {
            tmpfile.delete();
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            ((OutputStream)ostrm).close();
        }
        new Thread("FITS broadcast"){

            public void run() {
                List<Object> argList = Arrays.asList(tmpUrl, tmpUrl);
                URI msgId = MessageId.FITS_LOADIMAGE;
                Map responses = recipients == null ? hub.request(plasticId, msgId, argList) : hub.requestToSubset(plasticId, msgId, argList, Arrays.asList(recipients));
                tmpfile.delete();
            }
        }.start();
    }

    private static class HubWatchAction
    extends BasicAction {
        private final Component parent_;
        private final HubManager hubManager_;
        private JFrame hubWindow_;

        HubWatchAction(Component parent, HubManager hubManager) {
            super("Show Registered Applications", null, "Display applications registered with the PLASTIC hub");
            this.parent_ = parent;
            this.hubManager_ = hubManager;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.hubWindow_ == null) {
                this.hubWindow_ = new PlasticListWindow(this.hubManager_.getApplicationListModel());
                this.hubWindow_.setTitle("PLASTIC apps");
                AuxWindow.positionAfter(this.parent_, this.hubWindow_);
                this.hubWindow_.pack();
            }
            this.hubWindow_.setVisible(true);
        }
    }
}

