/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.func.BasicImageDisplay;
import uk.ac.starlink.topcat.func.Sog;
import uk.ac.starlink.topcat.interop.ImageActivity;
import uk.ac.starlink.topcat.interop.ImageViewer;
import uk.ac.starlink.topcat.interop.TopcatPlasticListener;

public class PlasticImageActivity
implements ImageActivity {
    private final TopcatPlasticListener plasticServer_;
    private final JComboBox formatSelector_;
    private final ViewerComboBoxModel viewerModel_;
    private final ComboBoxModel fitsAppModel_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlasticImageActivity(TopcatPlasticListener plasticServer) {
        this.plasticServer_ = plasticServer;
        this.formatSelector_ = new JComboBox<String>(KNOWN_FORMATS);
        this.formatSelector_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PlasticImageActivity.this.setFormat(String.valueOf(PlasticImageActivity.this.formatSelector_.getSelectedItem()));
            }
        });
        this.fitsAppModel_ = plasticServer.createPlasticComboBoxModel(MessageId.FITS_LOADIMAGE);
        this.viewerModel_ = new ViewerComboBoxModel();
        String format = "FITS";
        this.formatSelector_.setSelectedItem(format);
        this.setFormat(format);
    }

    public ComboBoxModel getTargetSelector() {
        return this.viewerModel_;
    }

    public JComboBox getFormatSelector() {
        return this.formatSelector_;
    }

    public void displayImage(String location, String label) {
        Object item = this.viewerModel_.getSelectedItem();
        if (item instanceof ImageViewer) {
            ((ImageViewer)item).viewImage(label, location);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void setFormat(String format) {
        this.viewerModel_.setFits("FITS".equals(format));
    }

    static {
        $assertionsDisabled = !PlasticImageActivity.class.desiredAssertionStatus();
    }

    private class PlasticViewer
    implements ImageViewer {
        private final URI recipient_;
        private final String name_;
        private final String id_;

        PlasticViewer(URI recipient, String name) {
            this.recipient_ = recipient;
            this.name_ = name;
            this.id_ = this.recipient_ == null ? "" : this.recipient_.toString();
        }

        public boolean viewImage(String label, String location) {
            try {
                List<Object> argList = Arrays.asList(location, label);
                URI msgId = MessageId.FITS_LOADIMAGE;
                PlasticImageActivity.this.plasticServer_.register();
                PlasticHubListener hub = PlasticImageActivity.this.plasticServer_.getHub();
                URI plasticId = PlasticImageActivity.this.plasticServer_.getRegisteredId();
                Map responses = this.recipient_ == null ? hub.request(plasticId, msgId, argList) : hub.requestToSubset(plasticId, msgId, argList, Collections.singletonList(this.recipient_));
                Iterator it = responses.values().iterator();
                while (it.hasNext()) {
                    Object response = it.next();
                    if (!(response instanceof Boolean) || !((Boolean)response).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean equals(Object other) {
            return other instanceof PlasticViewer && ((PlasticViewer)other).id_.equals(this.id_);
        }

        public int hashCode() {
            return this.id_.hashCode();
        }

        public String toString() {
            return this.name_;
        }
    }

    private class ViewerComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private ImageViewer[] baseViewers_;
        private boolean isFits_;
        private Object selectedItem_;
        private final ImageViewer basicViewer_ = new ImageViewer(this){
            private final /* synthetic */ ViewerComboBoxModel this$1;
            {
                this.this$1 = this$1;
            }

            public boolean viewImage(String label, String location) {
                BasicImageDisplay.displayBasicImage(label, location);
                return true;
            }

            public String toString() {
                return "Basic Viewer (internal)";
            }
        };
        private final ImageViewer sogViewer_ = new ImageViewer(this){
            private final /* synthetic */ ViewerComboBoxModel this$1;
            {
                this.this$1 = this$1;
            }

            public boolean viewImage(String label, String location) {
                Sog.sog(label, location);
                return true;
            }

            public String toString() {
                return "SoG (internal)";
            }
        };

        ViewerComboBoxModel() {
            this.setFits(false);
        }

        void setFits(boolean isFits) {
            this.isFits_ = isFits;
            ArrayList<ImageViewer> vList = new ArrayList<ImageViewer>();
            vList.add(this.basicViewer_);
            if (TopcatUtils.canSog()) {
                vList.add(this.sogViewer_);
            }
            this.baseViewers_ = vList.toArray(new ImageViewer[0]);
            int nv = this.getSize();
            boolean selectionLegal = false;
            for (int iv = 0; iv < nv; ++iv) {
                selectionLegal = selectionLegal || this.getElementAt(iv).equals(this.selectedItem_);
            }
            if (!selectionLegal) {
                this.selectedItem_ = nv > 0 ? this.getElementAt(0) : null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.baseViewers_.length + (this.isFits_ ? PlasticImageActivity.this.fitsAppModel_.getSize() : 0);
        }

        public Object getElementAt(int index) {
            if (index < this.baseViewers_.length) {
                return this.baseViewers_[index];
            }
            if (this.isFits_) {
                Object item = PlasticImageActivity.this.fitsAppModel_.getElementAt(index - this.baseViewers_.length);
                if (item instanceof ApplicationItem) {
                    ApplicationItem app = (ApplicationItem)item;
                    return new PlasticViewer(app.getId(), app + " (PLASTIC)");
                }
                return new PlasticViewer(null, "All Listeners (PLASTIC)");
            }
            return null;
        }

        public void setSelectedItem(Object item) {
            this.selectedItem_ = item;
        }

        public Object getSelectedItem() {
            return this.selectedItem_;
        }
    }
}

