/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nom.tam.fits.FitsException;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.MessageTrackerHubConnector;
import org.astrogrid.samp.gui.UniformCallActionManager;
import org.astrogrid.samp.xmlrpc.HubMode;
import org.astrogrid.samp.xmlrpc.HubRunner;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SubsetWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.interop.ImageActivity;
import uk.ac.starlink.topcat.interop.RowActivity;
import uk.ac.starlink.topcat.interop.SampImageActivity;
import uk.ac.starlink.topcat.interop.SampWindow;
import uk.ac.starlink.topcat.interop.SendManager;
import uk.ac.starlink.topcat.interop.ServerResource;
import uk.ac.starlink.topcat.interop.SkyPointActivity;
import uk.ac.starlink.topcat.interop.SubsetActivity;
import uk.ac.starlink.topcat.interop.TableSendActionManager;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.topcat.interop.TopcatSampControl;
import uk.ac.starlink.topcat.interop.TopcatServer;
import uk.ac.starlink.topcat.interop.Transmitter;
import uk.ac.starlink.topcat.plot.DensityWindow;

public class SampCommunicator
implements TopcatCommunicator {
    private final GuiHubConnector hubConnector_ = new MessageTrackerHubConnector(TopcatServer.getInstance().getProfile());
    private final TopcatSampControl sampControl_;
    private final Transmitter tableTransmitter_;
    private int imageCount_;
    private static final Logger logger_ = Logger.getLogger(SampCommunicator.class.getName());
    private static final HubMode INTERNAL_HUB_MODE = HubMode.NO_GUI;
    private static final HubMode EXTERNAL_HUB_MODE = HubMode.MESSAGE_GUI;

    public SampCommunicator(ControlWindow controlWindow) throws IOException {
        this.sampControl_ = new TopcatSampControl((HubConnector)this.hubConnector_, controlWindow);
        this.tableTransmitter_ = new TableSendActionManager(this.hubConnector_, this.sampControl_);
    }

    public String getProtocolName() {
        return "SAMP";
    }

    public boolean setActive() {
        this.hubConnector_.setActive(true);
        this.hubConnector_.setAutoconnect(5);
        try {
            return this.hubConnector_.getConnection() != null;
        }
        catch (IOException e) {
            logger_.warning("SAMP connection attempt failed: " + e);
            return false;
        }
    }

    public Transmitter getTableTransmitter() {
        return this.tableTransmitter_;
    }

    public Transmitter createImageTransmitter(DensityWindow densWin) {
        return SampCommunicator.adaptTransmitter(new DensityImageSendActionManager(densWin));
    }

    public Transmitter createSubsetTransmitter(TopcatModel tcModel, SubsetWindow subWin) {
        return SampCommunicator.adaptTransmitter(new SubsetSendActionManager(tcModel, subWin));
    }

    public SkyPointActivity createSkyPointActivity() {
        final SendManager pointSender = new SendManager(this.hubConnector_, "coord.pointAt.sky");
        return new SkyPointActivity(){

            public ComboBoxModel getTargetSelector() {
                return pointSender.getComboBoxModel();
            }

            public void pointAtSky(double ra, double dec) throws IOException {
                Message msg = new Message("coord.pointAt.sky");
                msg.addParam("ra", (Object)SampUtils.encodeFloat((double)ra));
                msg.addParam("dec", (Object)SampUtils.encodeFloat((double)dec));
                pointSender.notify((Map)msg);
            }
        };
    }

    public RowActivity createRowActivity() {
        final SendManager rowSender = new SendManager(this.hubConnector_, "table.highlight.row");
        return new RowActivity(){

            public ComboBoxModel getTargetSelector() {
                return rowSender.getComboBoxModel();
            }

            public void highlightRow(TopcatModel tcModel, long lrow) throws IOException {
                Map msg = SampCommunicator.this.sampControl_.createRowMessage(tcModel, lrow);
                if (msg != null) {
                    rowSender.notify(msg);
                }
            }
        };
    }

    public SubsetActivity createSubsetActivity() {
        final SendManager subsetSender = new SendManager(this.hubConnector_, "table.select.rowList");
        return new SubsetActivity(){

            public ComboBoxModel getTargetSelector() {
                return subsetSender.getComboBoxModel();
            }

            public void selectSubset(TopcatModel tcModel, RowSubset rset) throws IOException {
                Map msg = SampCommunicator.this.sampControl_.createSubsetMessage(tcModel, rset);
                if (msg != null) {
                    subsetSender.call(msg);
                }
            }
        };
    }

    public ImageActivity createImageActivity() {
        return new SampImageActivity(this.hubConnector_);
    }

    public Action[] getInteropActions() {
        return new Action[0];
    }

    public void startHub(boolean external) throws IOException {
        if (external) {
            HubRunner.runExternalHub((HubMode)EXTERNAL_HUB_MODE);
        } else {
            HubRunner.runHub((HubMode)INTERNAL_HUB_MODE, (XmlRpcKit)XmlRpcKit.INTERNAL);
        }
    }

    public Action createWindowAction(final Component parent) {
        return new BasicAction("SAMP Status", ResourceIcon.SAMP, "Show window displaying SAMP inter-tool messaging status and configuration"){
            private SampWindow sampWindow_;

            public void actionPerformed(ActionEvent evt) {
                if (this.sampWindow_ == null) {
                    this.sampWindow_ = new SampWindow(parent, SampCommunicator.this.hubConnector_);
                }
                this.sampWindow_.makeVisible();
            }
        };
    }

    public boolean isConnected() {
        return this.hubConnector_.isConnected();
    }

    public void addConnectionListener(ChangeListener listener) {
        this.hubConnector_.addConnectionListener(listener);
    }

    private static Transmitter adaptTransmitter(final UniformCallActionManager sender) {
        return new Transmitter(){

            public Action getBroadcastAction() {
                return sender.getBroadcastAction();
            }

            public JMenu createSendMenu() {
                return sender.createSendMenu();
            }

            public void setEnabled(boolean isEnabled) {
                sender.setEnabled(isEnabled);
            }
        };
    }

    public JComponent createInfoPanel() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        int boxHeight = 20;
        if (this.hubConnector_ instanceof MessageTrackerHubConnector) {
            JComponent mBox = ((MessageTrackerHubConnector)this.hubConnector_).createMessageBox(boxHeight);
            JLabel mLabel = new JLabel("Messages: ");
            mLabel.setLabelFor(mBox);
            box.add(mLabel);
            box.add(mBox);
            box.add(Box.createHorizontalStrut(10));
        }
        JComponent cBox = this.hubConnector_.createClientBox(false, boxHeight);
        JLabel cLabel = new JLabel("Clients: ");
        cLabel.setLabelFor(cBox);
        box.add(cLabel);
        box.add(cBox);
        box.add(Box.createHorizontalStrut(10));
        final JButton regButton = new JButton(this.hubConnector_.createToggleRegisterAction());
        this.hubConnector_.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                regButton.setText(null);
                regButton.setIcon(SampCommunicator.this.hubConnector_.isConnected() ? ResourceIcon.CONNECT : ResourceIcon.DISCONNECT);
            }
        });
        regButton.setText(null);
        regButton.setBorder(BorderFactory.createEmptyBorder());
        box.add(regButton);
        box.add(Box.createHorizontalStrut(5));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(AuxWindow.makeTitledBorder(this.getProtocolName()));
        panel.add((Component)box, "Center");
        return panel;
    }

    private class DensityImageSendActionManager
    extends UniformCallActionManager {
        private final DensityWindow densWin_;

        DensityImageSendActionManager(DensityWindow densWin) {
            super((Component)densWin, SampCommunicator.this.hubConnector_, "image.load.fits", "FITS Image");
            this.densWin_ = densWin;
        }

        protected Map createMessage() throws IOException, FitsException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedOutputStream bufout = new BufferedOutputStream(bout);
            this.densWin_.exportFits(bufout);
            bufout.flush();
            byte[] fitsdata = bout.toByteArray();
            ServerResource resource = new ServerResource(this, fitsdata){
                private final /* synthetic */ byte[] val$fitsdata;
                private final /* synthetic */ DensityImageSendActionManager this$1;
                {
                    this.this$1 = this$1;
                    this.val$fitsdata = val$fitsdata;
                }

                public String getContentType() {
                    return "image/fits";
                }

                public long getContentLength() {
                    return this.val$fitsdata.length;
                }

                public void writeBody(OutputStream out) throws IOException {
                    out.write(this.val$fitsdata);
                }
            };
            TopcatServer server = TopcatServer.getInstance();
            URL iurl = server.addResource("density.fits", resource);
            new Timer(true).schedule(new TimerTask(this, server, iurl){
                private final /* synthetic */ TopcatServer val$server;
                private final /* synthetic */ URL val$iurl;
                private final /* synthetic */ DensityImageSendActionManager this$1;
                {
                    this.this$1 = this$1;
                    this.val$server = val$server;
                    this.val$iurl = val$iurl;
                }

                public void run() {
                    this.val$server.expireResource(this.val$iurl);
                }
            }, 60000L);
            String iid = "density-" + ++SampCommunicator.this.imageCount_;
            return new Message("image.load.fits").addParam("url", (Object)iurl.toString()).addParam("image-id", (Object)iid);
        }
    }

    private class SubsetSendActionManager
    extends UniformCallActionManager {
        private final TopcatModel tcModel_;
        private final SubsetWindow subWin_;

        SubsetSendActionManager(TopcatModel tcModel, SubsetWindow subWin) {
            super((Component)subWin, SampCommunicator.this.hubConnector_, "table.select.rowList", "Row Subset");
            this.tcModel_ = tcModel;
            this.subWin_ = subWin;
        }

        protected Map createMessage() throws IOException {
            RowSubset rset = this.subWin_.getSelectedSubset();
            return SampCommunicator.this.sampControl_.createSubsetMessage(this.tcModel_, rset);
        }
    }
}

