/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SubscribedClientListModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.func.BasicImageDisplay;
import uk.ac.starlink.topcat.func.Sog;
import uk.ac.starlink.topcat.interop.ImageActivity;
import uk.ac.starlink.topcat.interop.ImageViewer;
import uk.ac.starlink.util.URLUtils;

public class SampImageActivity
implements ImageActivity {
    private final GuiHubConnector connector_;
    private final SubscribedClientListModel clientModel_;
    private final JComboBox formatSelector_;
    private final ViewerComboBoxModel viewerModel_;
    private static final Map mfactMap_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SampImageActivity(GuiHubConnector connector) {
        this.connector_ = connector;
        this.formatSelector_ = new JComboBox<String>(KNOWN_FORMATS);
        this.formatSelector_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SampImageActivity.this.setFormat(String.valueOf(SampImageActivity.this.formatSelector_.getSelectedItem()));
            }
        });
        this.clientModel_ = new SubscribedClientListModel(connector, new String[0]);
        this.viewerModel_ = new ViewerComboBoxModel();
        String format = "FITS";
        this.formatSelector_.setSelectedItem(format);
        this.setFormat(format);
    }

    public ComboBoxModel getTargetSelector() {
        return this.viewerModel_;
    }

    public JComboBox getFormatSelector() {
        return this.formatSelector_;
    }

    public void displayImage(String location, String label) {
        Object item = this.viewerModel_.getSelectedItem();
        if (item instanceof ImageViewer) {
            ((ImageViewer)item).viewImage(label, location);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private void setFormat(String format) {
        String[] stringArray;
        MessageFactory mfact = (MessageFactory)mfactMap_.get(format);
        if (mfact == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = mfact.mtype_;
        }
        this.clientModel_.setMTypes(stringArray);
        this.viewerModel_.setFormat(format);
    }

    private static Map createMessageFactoryMap() {
        HashMap<String, MessageFactory> map = new HashMap<String, MessageFactory>();
        map.put("FITS", new MessageFactory("image.load.fits"){

            public Map createMessage(String location, String label) {
                URL url = URLUtils.makeURL((String)location);
                return url == null ? null : new Message("image.load.fits").addParam("url", (Object)url.toString());
            }
        });
        map.put("JPEG", new MessageFactory("image.load.jpeg"){

            public Map createMessage(String location, String label) {
                URL url = URLUtils.makeURL((String)location);
                return url == null ? null : new Message("image.load.jpeg").addParam("url", (Object)url.toString());
            }
        });
        return map;
    }

    static {
        $assertionsDisabled = !SampImageActivity.class.desiredAssertionStatus();
        mfactMap_ = SampImageActivity.createMessageFactoryMap();
    }

    private static abstract class MessageFactory {
        final String mtype_;

        MessageFactory(String mtype) {
            this.mtype_ = mtype;
        }

        abstract Map createMessage(String var1, String var2);
    }

    private class ClientImageViewer
    implements ImageViewer {
        private final Client client_;
        private final MessageFactory mfact_;

        ClientImageViewer(Client client, MessageFactory mfact) {
            this.client_ = client;
            this.mfact_ = mfact;
        }

        public boolean viewImage(String label, String location) {
            try {
                HubConnection connection = SampImageActivity.this.connector_.getConnection();
                if (connection != null) {
                    Map msg = this.mfact_.createMessage(location, label);
                    if (msg != null) {
                        connection.notify(this.client_.getId(), msg);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.client_.getId().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ClientImageViewer && ((ClientImageViewer)other).client_.getId().equals(this.client_.getId());
        }

        public String toString() {
            return this.client_.toString();
        }
    }

    private static abstract class DefaultImageViewer
    implements ImageViewer {
        private final String label_;

        DefaultImageViewer(String label) {
            this.label_ = label;
        }

        public boolean equals(Object other) {
            return other instanceof DefaultImageViewer && ((DefaultImageViewer)other).label_.equals(this.label_);
        }

        public int hashCode() {
            return this.label_.hashCode();
        }

        public String toString() {
            return this.label_;
        }
    }

    private class ViewerComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private ImageViewer[] baseViewers_ = new ImageViewer[0];
        private Object selectedItem_;

        ViewerComboBoxModel() {
        }

        public void setFormat(String format) {
            MessageFactory mfact;
            ArrayList<DefaultImageViewer> viewerList = new ArrayList<DefaultImageViewer>();
            if ("FITS".equals(format) || "JPEG".equals(format) || "GIF".equals(format) || "PNG".equals(format)) {
                viewerList.add(new DefaultImageViewer(this, "Basic viewer (internal)"){
                    private final /* synthetic */ ViewerComboBoxModel this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public boolean viewImage(String label, String location) {
                        BasicImageDisplay.displayBasicImage(label, location);
                        return true;
                    }
                });
                if (TopcatUtils.canSog()) {
                    viewerList.add(new DefaultImageViewer(this, "SoG (internal)"){
                        private final /* synthetic */ ViewerComboBoxModel this$1;
                        {
                            this.this$1 = this$1;
                            super(x0);
                        }

                        public boolean viewImage(String label, String loc) {
                            Sog.sog(label, loc);
                            return true;
                        }
                    });
                }
            }
            if ((mfact = (MessageFactory)mfactMap_.get(format)) != null) {
                viewerList.add(new DefaultImageViewer(this, "All Clients (SAMP)", mfact){
                    private final /* synthetic */ MessageFactory val$mfact;
                    private final /* synthetic */ ViewerComboBoxModel this$1;
                    {
                        this.this$1 = this$1;
                        this.val$mfact = val$mfact;
                        super(x0);
                    }

                    public boolean viewImage(String label, String location) {
                        try {
                            HubConnection connection = SampImageActivity.access$400(ViewerComboBoxModel.access$300(this.this$1)).getConnection();
                            if (connection != null) {
                                Map msg = this.val$mfact.createMessage(location, label);
                                if (msg != null) {
                                    connection.notifyAll(msg);
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                });
            }
            this.baseViewers_ = viewerList.toArray(new ImageViewer[0]);
            int nv = this.getSize();
            boolean selectionLegal = false;
            for (int iv = 0; iv < nv; ++iv) {
                selectionLegal = selectionLegal || this.getElementAt(iv).equals(this.selectedItem_);
            }
            if (!selectionLegal) {
                this.selectedItem_ = nv > 0 ? this.getElementAt(0) : null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            return this.baseViewers_.length + SampImageActivity.this.clientModel_.getSize();
        }

        public Object getElementAt(int index) {
            int nb = this.baseViewers_.length;
            if (index < nb) {
                return this.baseViewers_[index];
            }
            Client client = (Client)SampImageActivity.this.clientModel_.getElementAt(index - nb);
            MessageFactory mfact = (MessageFactory)mfactMap_.get(SampImageActivity.this.formatSelector_.getSelectedItem());
            return new ClientImageViewer(client, mfact);
        }

        public void setSelectedItem(Object item) {
            this.selectedItem_ = item;
        }

        public Object getSelectedItem() {
            return this.selectedItem_;
        }

        static /* synthetic */ SampImageActivity access$300(ViewerComboBoxModel x0) {
            return x0.SampImageActivity.this;
        }
    }
}

