/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.ListModel;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.IndividualCallActionManager;
import org.astrogrid.samp.gui.SubscribedClientListModel;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.interop.ServerResource;
import uk.ac.starlink.topcat.interop.TopcatSampControl;
import uk.ac.starlink.topcat.interop.TopcatServer;
import uk.ac.starlink.topcat.interop.Transmitter;
import uk.ac.starlink.votable.VOTableWriter;

public class TableSendActionManager
extends IndividualCallActionManager
implements Transmitter {
    private final TopcatSampControl sampControl_;
    private final ControlWindow controlWindow_;
    private static final Sender[] SENDERS = new Sender[]{new Sender("table.load.votable", (StarTableWriter)new VOTableWriter(), ".vot"), new Sender("table.load.fits", (StarTableWriter)new FitsTableWriter(), ".fits")};

    public TableSendActionManager(GuiHubConnector connector, TopcatSampControl sampControl) {
        super((Component)sampControl.getControlWindow(), connector, (ListModel)new SubscribedClientListModel(connector, TableSendActionManager.getSendMtypes()));
        this.sampControl_ = sampControl;
        this.controlWindow_ = sampControl.getControlWindow();
    }

    protected Map createMessage(Client client) throws IOException {
        Sender sender = TableSendActionManager.getSender(client);
        TopcatModel tcModel = this.controlWindow_.getCurrentModel();
        if (sender != null && tcModel != null) {
            StarTable table = tcModel.getApparentStarTable();
            String label = Integer.toString(tcModel.getID());
            String sampId = this.sampControl_.getTableId(tcModel);
            return sender.createMessage(table, label, sampId);
        }
        return null;
    }

    public Action createBroadcastAction() {
        Action action = super.createBroadcastAction();
        action.putValue("Name", "Broadcast table");
        action.putValue("ShortDescription", "Transmit table to all applications using SAMP");
        action.putValue("SmallIcon", ResourceIcon.BROADCAST);
        return action;
    }

    public Action getSendAction(Client client) {
        Action action = super.getSendAction(client);
        action.putValue("ShortDescription", "Send table to " + SampUtils.toString((Client)client));
        return action;
    }

    public JMenu createSendMenu() {
        JMenu menu = super.createSendMenu("Send table to...");
        menu.setToolTipText("Send table to a single other registered client using SAMP");
        menu.setIcon(ResourceIcon.SEND);
        return menu;
    }

    private static Sender getSender(Client client) {
        Subscriptions subs = client.getSubscriptions();
        for (int i = 0; i < SENDERS.length; ++i) {
            Sender sender = SENDERS[i];
            if (!subs.isSubscribed(sender.getMtype())) continue;
            return sender;
        }
        return null;
    }

    private static String[] getSendMtypes() {
        String[] mtypes = new String[SENDERS.length];
        for (int i = 0; i < SENDERS.length; ++i) {
            mtypes[i] = SENDERS[i].getMtype();
        }
        return mtypes;
    }

    private static class Sender {
        private final String mtype_;
        private final StarTableWriter writer_;
        private final String extension_;

        Sender(String mtype, StarTableWriter writer, String extension) {
            this.mtype_ = mtype;
            this.writer_ = writer;
            this.extension_ = extension;
        }

        public String getMtype() {
            return this.mtype_;
        }

        public Message createMessage(StarTable table, String label, String sampId) throws IOException {
            String name = "t" + label + this.extension_;
            URL turl = TopcatServer.getInstance().addResource(name, this.createResource(table));
            return new Message(this.getMtype()).addParam("url", (Object)turl.toString()).addParam("table-id", (Object)sampId);
        }

        private ServerResource createResource(StarTable table) {
            return new ServerResource(this, table){
                private final /* synthetic */ StarTable val$table;
                private final /* synthetic */ Sender this$0;
                {
                    this.this$0 = this$0;
                    this.val$table = val$table;
                }

                public long getContentLength() {
                    return -1L;
                }

                public String getContentType() {
                    return Sender.access$000(this.this$0).getMimeType();
                }

                public void writeBody(OutputStream out) throws IOException {
                    Sender.access$000(this.this$0).writeStarTable(this.val$table, out);
                }
            };
        }

        public String toString() {
            return this.mtype_;
        }

        static /* synthetic */ StarTableWriter access$000(Sender x0) {
            return x0.writer_;
        }
    }
}

