/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.votech.plastic.PlasticHubListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.HubManager;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.NoHubException;
import uk.ac.starlink.plastic.PlasticTransmitter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SubsetWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.interop.SelectivePlasticListModel;
import uk.ac.starlink.topcat.interop.TopcatTransmitter;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableWriter;

public class TopcatPlasticListener
extends HubManager {
    private final ControlWindow controlWindow_;
    private final Map idMap_;
    private final Map highlightMap_;
    private static final URI[] SUPPORTED_MESSAGES = new URI[]{MessageId.VOT_LOAD, MessageId.VOT_LOADURL, MessageId.VOT_SHOWOBJECTS, MessageId.VOT_HIGHLIGHTOBJECT, MessageId.INFO_GETDESCRIPTION, MessageId.INFO_GETICONURL};

    public TopcatPlasticListener(ControlWindow controlWindow) {
        super("topcat", SUPPORTED_MESSAGES);
        this.controlWindow_ = controlWindow;
        this.idMap_ = Collections.synchronizedMap(new HashMap());
        this.highlightMap_ = new HashMap();
    }

    public Object doPerform(URI sender, URI message, List args) throws IOException {
        if (MessageId.VOT_LOAD.equals(message)) {
            Class[] classArray = new Class[1];
            Class clazz = classArray[0] = String.class;
            if (TopcatPlasticListener.checkArgs((List)args, (Class[])classArray)) {
                String text = (String)args.get(0);
                String id = args.size() > 1 ? String.valueOf(args.get(1)) : null;
                this.votableLoad(sender, text, id);
                return Boolean.TRUE;
            }
        }
        if (MessageId.VOT_LOADURL.equals(message)) {
            Class[] classArray = new Class[1];
            Class clazz = classArray[0] = Object.class;
            if (TopcatPlasticListener.checkArgs((List)args, (Class[])classArray)) {
                String url;
                String id = url = args.get(0) instanceof String ? (String)args.get(0) : args.get(0).toString();
                if (args.size() > 1) {
                    id = args.get(1) instanceof String ? (String)args.get(1) : args.get(0).toString();
                }
                this.votableLoadFromURL(sender, url, id);
                return Boolean.TRUE;
            }
        }
        if (MessageId.VOT_SHOWOBJECTS.equals(message) && args.size() >= 2 && args.get(1) instanceof List) {
            String tableId = args.get(0).toString();
            List objList = (List)args.get(1);
            return this.showObjects(sender, tableId, objList);
        }
        if (MessageId.VOT_HIGHLIGHTOBJECT.equals(message) && args.size() >= 2 && args.get(1) instanceof Number) {
            String tableId = args.get(0).toString();
            int irow = ((Number)args.get(1)).intValue();
            return this.highlightObject(sender, tableId, irow);
        }
        if (MessageId.INFO_GETICONURL.equals(message)) {
            return "http://eurovotech.org/wfau/tc3.gif";
        }
        if (MessageId.INFO_GETDESCRIPTION.equals(message)) {
            return "TOol for Processing Catalogues And Tables";
        }
        throw new UnsupportedOperationException();
    }

    public ComboBoxModel createPlasticComboBoxModel(URI messageId) {
        return new SelectivePlasticListModel(this.getApplicationListModel(), messageId, true, this);
    }

    public PlasticTransmitter createTableTransmitter() {
        return new TopcatTransmitter(this, MessageId.VOT_LOADURL, "table"){

            protected void transmit(PlasticHubListener hub, URI clientId, ApplicationItem app) throws IOException {
                TopcatModel tcModel = TopcatPlasticListener.this.controlWindow_.getCurrentModel();
                if (tcModel != null) {
                    URI[] uRIArray;
                    if (app == null) {
                        uRIArray = null;
                    } else {
                        URI[] uRIArray2 = new URI[1];
                        uRIArray = uRIArray2;
                        uRIArray2[0] = app.getId();
                    }
                    URI[] recipients = uRIArray;
                    TopcatPlasticListener.this.transmitTable(tcModel, hub, clientId, recipients);
                }
            }
        };
    }

    private void transmitTable(TopcatModel tcModel, final PlasticHubListener hub, final URI plasticId, final URI[] recipients) throws IOException {
        final File tmpfile = File.createTempFile("plastic", ".vot");
        final String tmpUrl = URLUtils.makeFileURL((File)tmpfile).toString();
        tmpfile.deleteOnExit();
        BufferedOutputStream ostrm = new BufferedOutputStream(new FileOutputStream(tmpfile));
        try {
            new VOTableWriter(DataFormat.TABLEDATA, true).writeStarTable(tcModel.getApparentStarTable(), (OutputStream)ostrm);
        }
        catch (IOException e) {
            tmpfile.delete();
            throw e;
        }
        finally {
            ((OutputStream)ostrm).close();
        }
        int[] rowMap = tcModel.getViewModel().getRowMap();
        this.idMap_.put(tmpUrl, new TableWithRows(tcModel, rowMap));
        new Thread("PLASTIC table broadcast"){

            public void run() {
                List<Object> argList = Arrays.asList(tmpUrl, tmpUrl);
                Map responses = recipients == null ? hub.request(plasticId, MessageId.VOT_LOADURL, argList) : hub.requestToSubset(plasticId, MessageId.VOT_LOADURL, argList, Arrays.asList(recipients));
                tmpfile.delete();
            }
        }.start();
    }

    public PlasticTransmitter createSubsetTransmitter(final TopcatModel tcModel, final SubsetWindow subSelector) {
        return new TopcatTransmitter(this, MessageId.VOT_SHOWOBJECTS, "subset"){

            protected void transmit(PlasticHubListener hub, URI clientId, ApplicationItem app) throws IOException {
                RowSubset rset = subSelector.getSelectedSubset();
                if (rset != null) {
                    URI[] uRIArray;
                    if (app == null) {
                        uRIArray = null;
                    } else {
                        URI[] uRIArray2 = new URI[1];
                        uRIArray = uRIArray2;
                        uRIArray2[0] = app.getId();
                    }
                    URI[] recipients = uRIArray;
                    TopcatPlasticListener.this.transmitSubset(tcModel, rset, hub, clientId, recipients);
                }
            }
        };
    }

    public void transmitSubset(TopcatModel tcModel, RowSubset rset, URI[] recipients) throws IOException {
        this.register();
        PlasticHubListener hub = this.getHub();
        URI plasticId = this.getRegisteredId();
        if (plasticId == null) {
            throw new NoHubException("No hub");
        }
        this.transmitSubset(tcModel, rset, hub, plasticId, recipients);
    }

    private void transmitSubset(TopcatModel tcModel, RowSubset rset, PlasticHubListener hub, URI plasticId, URI[] recipients) throws IOException {
        URL url;
        boolean done = false;
        Iterator it = this.idMap_.entrySet().iterator();
        while (it.hasNext()) {
            int i;
            int nrow;
            Map.Entry entry = it.next();
            String tableId = entry.getKey().toString();
            TableWithRows tr = (TableWithRows)entry.getValue();
            TopcatModel tcm = (TopcatModel)tr.tcModelRef_.get();
            if (tcm == null || tcm != tcModel) continue;
            ArrayList<Integer> rowList = new ArrayList<Integer>();
            int[] rowMap = tr.rowMap_;
            if (rowMap == null) {
                nrow = (int)Math.min(Integer.MAX_VALUE, tcModel.getDataModel().getRowCount());
                for (i = 0; i < nrow; ++i) {
                    if (!rset.isIncluded(i)) continue;
                    rowList.add(new Integer(i));
                }
            } else {
                nrow = rowMap.length;
                for (i = 0; i < nrow; ++i) {
                    if (!rset.isIncluded(rowMap[i])) continue;
                    rowList.add(new Integer(i));
                }
            }
            List<Object> argList = Arrays.asList(tableId, rowList);
            if (recipients == null) {
                hub.requestAsynch(plasticId, MessageId.VOT_SHOWOBJECTS, argList);
            } else {
                hub.requestToSubsetAsynch(plasticId, MessageId.VOT_SHOWOBJECTS, argList, Arrays.asList(recipients));
            }
            done = true;
        }
        if (!done && (url = URLUtils.fixURL((URL)tcModel.getDataModel().getBaseTable().getURL())) != null) {
            ArrayList<Integer> rowList = new ArrayList<Integer>();
            int nrow = (int)Math.min(Integer.MAX_VALUE, tcModel.getDataModel().getRowCount());
            for (int i = 0; i < nrow; ++i) {
                if (!rset.isIncluded(i)) continue;
                rowList.add(new Integer(i));
            }
            List<Object> argList = Arrays.asList(url.toString(), rowList);
            if (recipients == null) {
                hub.requestAsynch(plasticId, MessageId.VOT_SHOWOBJECTS, argList);
            } else {
                hub.requestToSubsetAsynch(plasticId, MessageId.VOT_SHOWOBJECTS, argList, Arrays.asList(recipients));
            }
        }
    }

    public boolean highlightRow(TopcatModel tcModel, long lrow, URI[] recipients) throws IOException {
        URL url;
        this.register();
        PlasticHubListener hub = this.getHub();
        URI plasticId = this.getRegisteredId();
        int irow = Tables.checkedLongToInt((long)lrow);
        boolean done = false;
        int sendRow = -1;
        String tableId = null;
        Iterator it = this.idMap_.entrySet().iterator();
        while (!done && it.hasNext()) {
            Map.Entry entry = it.next();
            TableWithRows tr = (TableWithRows)entry.getValue();
            TopcatModel tcm = (TopcatModel)tr.tcModelRef_.get();
            if (tcm == null || tcm != tcModel) continue;
            int[] rowMap = tr.rowMap_;
            if (rowMap == null) {
                sendRow = irow;
            } else {
                for (int j = 0; j < rowMap.length; ++j) {
                    if (irow != rowMap[j]) continue;
                    sendRow = j;
                    break;
                }
            }
            tableId = entry.getKey().toString();
            done = true;
        }
        if (!done && (url = URLUtils.fixURL((URL)tcModel.getDataModel().getBaseTable().getURL())) != null) {
            sendRow = irow;
            tableId = url.toString();
            done = true;
        }
        if (done && sendRow >= 0) {
            List<Object> args = Arrays.asList(tableId, new Integer(sendRow));
            if (recipients == null) {
                hub.requestAsynch(plasticId, MessageId.VOT_HIGHLIGHTOBJECT, args);
            } else {
                hub.requestToSubsetAsynch(plasticId, MessageId.VOT_HIGHLIGHTOBJECT, args, Arrays.asList(recipients));
            }
            return true;
        }
        return false;
    }

    public void pointAt(double ra2000, double dec2000, URI[] recipients) throws IOException {
        this.register();
        PlasticHubListener hub = this.getHub();
        URI plasticId = this.getRegisteredId();
        List<Object> args = Arrays.asList(new Double(ra2000), new Double(dec2000));
        if (recipients == null) {
            hub.requestAsynch(plasticId, MessageId.SKY_POINT, args);
        } else {
            hub.requestToSubsetAsynch(plasticId, MessageId.SKY_POINT, args, Arrays.asList(recipients));
        }
    }

    private void votableLoad(URI sender, String votText, String votId) throws IOException {
        byte[] votBytes;
        try {
            votBytes = votText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"JVMs are required to support UTF-8"))).initCause(e));
        }
        votText = null;
        DataSource datsrc = new DataSource(){

            public InputStream getRawInputStream() {
                return new ByteArrayInputStream(votBytes);
            }
        };
        this.loadTable(this.controlWindow_.getTableFactory().makeStarTable(datsrc, "votable"), sender, votId);
    }

    private void votableLoadFromURL(URI sender, String url, String key) throws IOException {
        this.loadTable(this.controlWindow_.getTableFactory().makeStarTable(url, "votable"), sender, key);
    }

    private void loadTable(final StarTable table, URI sender, final String key) {
        String name = table.getName();
        if (name == null || name.trim().length() == 0) {
            name = sender.toString();
        }
        final String title = name;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopcatModel tcModel = TopcatPlasticListener.this.controlWindow_.addTable(table, title, true);
                if (key != null && key.trim().length() > 0) {
                    TopcatPlasticListener.this.idMap_.put(key, new TableWithRows(tcModel, null));
                }
            }
        });
    }

    private boolean highlightObject(URI sender, String tableId, int irow) {
        TopcatModel tcModel;
        TableWithRows tr = this.lookupTable(tableId);
        TopcatModel topcatModel = tcModel = tr == null ? null : (TopcatModel)tr.tcModelRef_.get();
        if (tcModel != null) {
            final long lrow = tr.rowMap_ == null ? (long)irow : (long)tr.rowMap_[irow];
            Long lastHigh = (Long)this.highlightMap_.get(tcModel);
            if (lastHigh == null || lastHigh != lrow) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        tcModel.highlightRow(lrow);
                    }
                });
            }
            this.highlightMap_.put(tcModel, new Long(lrow));
            return true;
        }
        return false;
    }

    private boolean showObjects(URI sender, String tableId, List objList) {
        TopcatModel tcModel;
        TableWithRows tr = this.lookupTable(tableId);
        TopcatModel topcatModel = tcModel = tr == null ? null : (TopcatModel)tr.tcModelRef_.get();
        if (tcModel != null) {
            int[] rowMap = tr.rowMap_;
            BitSet mask = new BitSet();
            Iterator it = objList.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (!(val instanceof Number)) continue;
                int index = ((Number)val).intValue();
                mask.set(rowMap == null ? index : rowMap[index]);
            }
            String appname = this.getAppName(sender).replaceAll("\\s+", "_");
            this.showSubset(tcModel, mask, appname);
            return true;
        }
        return false;
    }

    private void showSubset(final TopcatModel tcModel, BitSet mask, String appName) {
        final BitsRowSubset rset = new BitsRowSubset(appName, mask);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tcModel.addSubset(rset);
            }
        });
    }

    private void applyNewSubset(final TopcatModel tcModel, BitSet mask, String appName) {
        RowSubset matching = null;
        Iterator it = tcModel.getSubsets().iterator();
        while (matching == null && it.hasNext()) {
            int nrow;
            RowSubset rset = (RowSubset)it.next();
            if (!TopcatPlasticListener.matches(mask, rset, nrow = Tables.checkedLongToInt((long)tcModel.getDataModel().getRowCount()))) continue;
            matching = rset;
        }
        if (matching != null) {
            final RowSubset rset = matching;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tcModel.applySubset(rset);
                }
            });
        } else {
            int ipset = 0;
            Iterator it2 = tcModel.getSubsets().iterator();
            while (it2.hasNext()) {
                String setName = ((RowSubset)it2.next()).getName();
                if (!setName.matches(appName + "-[0-9]+")) continue;
                String digits = setName.substring(appName.length() + 1);
                ipset = Math.max(ipset, Integer.parseInt(digits));
            }
            String setName = appName + '-' + (ipset + 1);
            final BitsRowSubset rset = new BitsRowSubset(setName, mask);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tcModel.addSubset(rset);
                    tcModel.applySubset(rset);
                }
            });
        }
    }

    private TableWithRows lookupTable(String tableId) {
        TableWithRows tr = (TableWithRows)this.idMap_.get(tableId);
        if (tr != null) {
            return tr;
        }
        ListModel tablesList = ControlWindow.getInstance().getTablesListModel();
        for (int i = 0; i < tablesList.getSize(); ++i) {
            TopcatModel tcModel = (TopcatModel)tablesList.getElementAt(i);
            URL url = tcModel.getDataModel().getBaseTable().getURL();
            if (!URLUtils.sameResource((URL)url, (URL)URLUtils.makeURL((String)tableId))) continue;
            return new TableWithRows(tcModel, null);
        }
        return null;
    }

    private String getAppName(URI id) {
        Object name = null;
        ListModel appList = this.getApplicationListModel();
        for (int i = 0; i < appList.getSize(); ++i) {
            ApplicationItem app = (ApplicationItem)appList.getElementAt(i);
            if (!app.getId().equals(id)) continue;
            return app.getName();
        }
        return "plastic";
    }

    private static boolean matches(BitSet mask, RowSubset rset, int nrow) {
        for (int i = 0; i < nrow; ++i) {
            if (mask.get(i) == rset.isIncluded(i)) continue;
            return false;
        }
        return true;
    }

    private static class TableWithRows {
        final Reference tcModelRef_;
        final int[] rowMap_;

        TableWithRows(TopcatModel tcModel, int[] rowMap) {
            this.tcModelRef_ = new WeakReference<TopcatModel>(tcModel);
            this.rowMap_ = rowMap;
        }
    }
}

