/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.AbstractMessageHandler;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.MessageHandler;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.interop.TopcatServer;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.URLDataSource;
import uk.ac.starlink.util.URLUtils;

public class TopcatSampControl {
    private final HubConnector hubConnector_;
    private final ControlWindow controlWindow_;
    private final Map idMap_;
    private final Map highlightMap_;
    private int idCount_;

    public TopcatSampControl(HubConnector hubConnector, ControlWindow controlWindow) throws IOException {
        this.hubConnector_ = hubConnector;
        this.controlWindow_ = controlWindow;
        this.idMap_ = Collections.synchronizedMap(new HashMap());
        this.highlightMap_ = Collections.synchronizedMap(new WeakHashMap());
        Metadata meta = new Metadata();
        TopcatServer tcServer = TopcatServer.getInstance();
        URL tcPkgUrl = tcServer.getTopcatPackageUrl();
        String homepage = "http://www.starlink.ac.uk/topcat/";
        meta.setName("topcat");
        meta.setDescriptionText("Tool for OPerations on Catalogues And Tables");
        URL docUrl = new URL(tcPkgUrl, "sun253/index.html");
        meta.setDocumentationUrl(tcServer.isFound(docUrl) ? docUrl.toString() : homepage);
        URL logoUrl = new URL(tcPkgUrl, "images/tc3.gif");
        meta.setIconUrl(tcServer.isFound(logoUrl) ? logoUrl.toString() : homepage + "images/tc3.gif");
        meta.put((Object)"home.page", (Object)homepage);
        meta.put((Object)"author.name", (Object)"Mark Taylor");
        meta.put((Object)"author.affiliation", (Object)"Astrophysics Group, Bristol University");
        meta.put((Object)"author.email", (Object)"m.b.taylor@bristol.ac.uk");
        meta.put((Object)"topcat.version", (Object)TopcatUtils.getVersion());
        this.hubConnector_.declareMetadata((Map)meta);
        MessageHandler[] handlers = this.createMessageHandlers();
        for (int ih = 0; ih < handlers.length; ++ih) {
            this.hubConnector_.addMessageHandler(handlers[ih]);
        }
        this.hubConnector_.declareSubscriptions((Map)this.hubConnector_.computeSubscriptions());
    }

    public ControlWindow getControlWindow() {
        return this.controlWindow_;
    }

    public String getTableId(TopcatModel tcModel) {
        int[] rowMap = tcModel.getViewModel().getRowMap();
        Iterator it = this.idMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            TableWithRows tr = (TableWithRows)entry.getValue();
            if (tr.getTable() != tcModel || !Arrays.equals(tr.rowMap_, rowMap)) continue;
            return id;
        }
        URL url = tcModel.getDataModel().getBaseTable().getURL();
        String id = rowMap == null && url != null ? url.toString() : this.createId();
        this.idMap_.put(id, new TableWithRows(tcModel, rowMap));
        return id;
    }

    public Map createSubsetMessage(TopcatModel tcModel, RowSubset rset) {
        int nrow;
        URL uurl;
        TableWithRows tr = new TableWithRows(tcModel, null);
        String tableId = null;
        Iterator it = this.idMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            TableWithRows twr = (TableWithRows)entry.getValue();
            if (twr.getTable() != tcModel) continue;
            tableId = id;
            tr = twr;
            break;
        }
        String url = null;
        if (tr.getRowMap() == null && (uurl = tcModel.getDataModel().getBaseTable().getURL()) != null) {
            url = uurl.toString();
        }
        int[] rowMap = tr.getRowMap();
        ArrayList<String> rowList = new ArrayList<String>();
        if (rowMap == null) {
            nrow = (int)tcModel.getDataModel().getRowCount();
            for (int ir = 0; ir < nrow; ++ir) {
                if (!rset.isIncluded(ir)) continue;
                rowList.add(SampUtils.encodeInt((int)ir));
            }
        } else {
            nrow = rowMap.length;
            for (int ir = 0; ir < nrow; ++ir) {
                if (!rset.isIncluded(rowMap[ir])) continue;
                rowList.add(SampUtils.encodeInt((int)ir));
            }
        }
        Message msg = new Message("table.select.rowList");
        if (tableId != null) {
            msg.addParam("table-id", (Object)tableId);
        }
        if (url != null) {
            msg.addParam("url", (Object)url);
        }
        if (url == null && tableId == null) {
            msg.addParam("table-id", (Object)this.createId());
        }
        msg.addParam("row-list", rowList);
        msg.check();
        return msg;
    }

    public Map createRowMessage(TopcatModel tcModel, long lrow) {
        long row;
        URL uurl;
        TableWithRows tr = new TableWithRows(tcModel, null);
        String tableId = null;
        Iterator it = this.idMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            TableWithRows twr = (TableWithRows)entry.getValue();
            if (twr.getTable() != tcModel) continue;
            tableId = id;
            tr = twr;
            break;
        }
        String url = null;
        if (tr.getRowMap() == null && (uurl = tcModel.getDataModel().getBaseTable().getURL()) != null) {
            url = uurl.toString();
        }
        if (tableId == null && url == null) {
            return null;
        }
        int[] rowMap = tr.getRowMap();
        if (rowMap == null) {
            row = lrow;
        } else {
            long r = -1L;
            int nrow = rowMap.length;
            for (int ir = 0; ir < nrow && r < 0L; ++ir) {
                if ((long)rowMap[ir] != lrow) continue;
                r = ir;
            }
            row = r;
        }
        if (row < 0L) {
            return null;
        }
        Message msg = new Message("table.highlight.row");
        if (tableId != null) {
            msg.addParam("table-id", (Object)tableId);
        }
        if (url != null) {
            msg.addParam("url", (Object)url);
        }
        msg.addParam("row", (Object)SampUtils.encodeLong((long)row));
        msg.check();
        return msg;
    }

    private final MessageHandler[] createMessageHandlers() {
        return new MessageHandler[]{new AbstractMessageHandler("table.load.votable"){

            public Map processCall(HubConnection conn, String senderId, Message msg) throws IOException {
                StarTable table = TopcatSampControl.this.createTable("votable", (String)msg.getRequiredParam("url"));
                TopcatSampControl.this.loadTable(table, (String)msg.getParam("table-id"), senderId);
                return null;
            }
        }, new AbstractMessageHandler("table.load.fits"){

            public Map processCall(HubConnection conn, String senderId, Message msg) throws IOException {
                StarTable table = TopcatSampControl.this.createTable("fits", (String)msg.getRequiredParam("url"));
                TopcatSampControl.this.loadTable(table, (String)msg.getParam("table-id"), senderId);
                return null;
            }
        }, new AbstractMessageHandler("table.highlight.row"){

            public Map processCall(HubConnection conn, String senderId, Message msg) throws MalformedURLException {
                TableWithRows tr = TopcatSampControl.this.lookupTable((String)msg.getParam("table-id"), (String)msg.getParam("url"));
                int irow = SampUtils.decodeInt((String)((String)msg.getRequiredParam("row")));
                TopcatSampControl.this.highlightRow(tr, irow);
                return null;
            }
        }, new AbstractMessageHandler("table.select.rowList"){

            public Map processCall(HubConnection conn, String senderId, Message msg) throws MalformedURLException {
                TableWithRows tr = TopcatSampControl.this.lookupTable((String)msg.getParam("table-id"), (String)msg.getParam("url"));
                List rowList = (List)msg.getRequiredParam("row-list");
                int[] irows = new int[rowList.size()];
                for (int i = 0; i < irows.length; ++i) {
                    irows[i] = SampUtils.decodeInt((String)((String)rowList.get(i)));
                }
                TopcatSampControl.this.selectRows(tr, irows, senderId);
                return null;
            }
        }};
    }

    private void loadTable(final StarTable table, final String key, String senderId) {
        String name = table.getName();
        final String title = name == null ? this.getClientName(senderId) : name;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopcatModel tcModel = TopcatSampControl.this.controlWindow_.addTable(table, title, true);
                if (key != null && key.trim().length() > 0) {
                    TopcatSampControl.this.idMap_.put(key, new TableWithRows(tcModel, null));
                }
            }
        });
    }

    private void highlightRow(TableWithRows tr, int irow) {
        long maxRow;
        final TopcatModel tcModel = tr.getTable();
        int[] rowMap = tr.getRowMap();
        long l = maxRow = rowMap == null ? tcModel.getDataModel().getRowCount() : (long)rowMap.length;
        if (irow < 0 || (long)irow >= maxRow) {
            throw new IllegalArgumentException("Row index " + irow + " out of range");
        }
        final long lrow = rowMap == null ? (long)irow : (long)rowMap[irow];
        Long lastHigh = (Long)this.highlightMap_.get(tcModel);
        if (lastHigh == null || lastHigh != lrow) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tcModel.highlightRow(lrow);
                }
            });
        }
        this.highlightMap_.put(tcModel, new Long(lrow));
    }

    private void selectRows(TableWithRows tr, int[] irows, String senderId) {
        final TopcatModel tcModel = tr.getTable();
        int[] rowMap = tr.getRowMap();
        BitSet mask = new BitSet();
        for (int i = 0; i < irows.length; ++i) {
            int irow = irows[i];
            mask.set(rowMap == null ? irow : rowMap[irow]);
        }
        String subName = this.getClientName(senderId);
        final BitsRowSubset rset = new BitsRowSubset(subName, mask);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tcModel.addSubset(rset);
            }
        });
    }

    private String getClientName(String clientId) {
        String name;
        Metadata meta;
        Client client = (Client)this.hubConnector_.getClientMap().get(clientId);
        if (client != null && (meta = client.getMetadata()) != null && (name = meta.getName()) != null && name.trim().length() > 0) {
            return name;
        }
        return "samp";
    }

    private StarTable createTable(String format, String url) throws IOException {
        File file = URLUtils.urlToFile((String)url);
        FileDataSource datsrc = file != null ? new FileDataSource(file) : new URLDataSource(new URL(url));
        return this.controlWindow_.getTableFactory().makeStarTable((DataSource)datsrc, format);
    }

    private TableWithRows lookupTable(String tableId, String url) throws MalformedURLException {
        if (tableId != null && this.idMap_.containsKey(tableId)) {
            return (TableWithRows)this.idMap_.get(tableId);
        }
        ListModel tablesList = ControlWindow.getInstance().getTablesListModel();
        URL u = new URL(url);
        for (int i = 0; i < tablesList.getSize(); ++i) {
            TopcatModel tcModel = (TopcatModel)tablesList.getElementAt(i);
            if (!URLUtils.sameResource((URL)u, (URL)tcModel.getDataModel().getBaseTable().getURL())) continue;
            return new TableWithRows(tcModel, null);
        }
        throw new RuntimeException("No table " + "table-id=" + tableId + '/' + "url=" + url + " is loaded");
    }

    private synchronized String createId() {
        return "topcat" + Integer.toString(System.identityHashCode(this) & 0xFFFF, 16) + "-" + ++this.idCount_;
    }

    private static class TableWithRows {
        private final Reference tcModelRef_;
        private final int[] rowMap_;

        TableWithRows(TopcatModel tcModel, int[] rowMap) {
            this.tcModelRef_ = new WeakReference<TopcatModel>(tcModel);
            this.rowMap_ = rowMap;
        }

        TopcatModel getTable() {
            TopcatModel tcModel = (TopcatModel)this.tcModelRef_.get();
            if (tcModel != null) {
                return tcModel;
            }
            throw new RuntimeException("Table no longer loaded");
        }

        int[] getRowMap() {
            return this.rowMap_;
        }
    }
}

