/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.interop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.internal.HttpServer;
import org.astrogrid.samp.xmlrpc.internal.InternalClientFactory;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;
import uk.ac.starlink.topcat.Driver;
import uk.ac.starlink.topcat.interop.ServerResource;

public class TopcatServer {
    private final HttpServer httpServer_ = new HttpServer();
    private final ResourceHandler resourceHandler_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private final SampXmlRpcClientFactory xClientFactory_;
    private final ClientProfile profile_;
    private final URL tcPkgUrl_;
    private boolean started_;
    private static TopcatServer instance_;
    private static Logger logger_;
    private static final int BUFSIZ = 16384;

    private TopcatServer() throws IOException {
        this.httpServer_.setDaemon(true);
        this.resourceHandler_ = new ResourceHandler(this.httpServer_, "/dynamic");
        this.httpServer_.addHandler((HttpServer.Handler)this.resourceHandler_);
        URL docResource = TopcatServer.getDocResource();
        this.httpServer_.addHandler((HttpServer.Handler)new ClassLoaderHandler(docResource, "/doc/"));
        this.tcPkgUrl_ = new URL(this.httpServer_.getBaseUrl(), "doc/");
        this.xClientFactory_ = new InternalClientFactory();
        InternalServer xServer = new InternalServer(this.httpServer_, "/xmlrpc");
        this.xServerFactory_ = new SampXmlRpcServerFactory((SampXmlRpcServer)xServer){
            private final /* synthetic */ SampXmlRpcServer val$xServer;
            {
                this.val$xServer = val$xServer;
            }

            public SampXmlRpcServer getServer() {
                TopcatServer.this.checkStarted();
                return this.val$xServer;
            }
        };
        this.profile_ = new StandardClientProfile(this.xClientFactory_, this.xServerFactory_);
    }

    public ClientProfile getProfile() {
        return this.profile_;
    }

    public SampXmlRpcClientFactory getSampClientFactory() {
        return this.xClientFactory_;
    }

    public SampXmlRpcServerFactory getSampServerFactory() {
        return this.xServerFactory_;
    }

    public URL addResource(String name, ServerResource resource) {
        this.checkStarted();
        return this.resourceHandler_.addResource(name == null ? "" : name, resource);
    }

    public void expireResource(URL url) {
        this.resourceHandler_.expireResource(url);
    }

    public URL getTopcatPackageUrl() {
        return this.tcPkgUrl_;
    }

    public boolean isFound(URL url) {
        this.checkStarted();
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)connection;
                hconn.setRequestMethod("HEAD");
                hconn.setDoOutput(false);
                hconn.connect();
                InputStream in = connection.getInputStream();
                byte[] buf = new byte[16384];
                while (in.read(buf) >= 0) {
                }
                in.close();
                return hconn.getResponseCode() == 200;
            }
            connection.connect();
            InputStream in = connection.getInputStream();
            byte[] buf = new byte[16384];
            while (in.read(buf) >= 0) {
            }
            in.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() {
        if (!this.started_) {
            HttpServer httpServer = this.httpServer_;
            synchronized (httpServer) {
                if (!this.started_) {
                    this.started_ = true;
                    this.httpServer_.start();
                }
            }
        }
    }

    private static URL getDocResource() throws MalformedURLException {
        Class clazz = Driver.class;
        String cname = clazz.getName().replaceFirst(".*\\.", "") + ".class";
        URL cUrl = clazz.getResource(cname);
        String cRes = cUrl.toString();
        cRes = cRes.substring(0, cRes.length() - cname.length());
        return new URL(cRes);
    }

    public static TopcatServer getInstance() throws IOException {
        if (instance_ == null) {
            instance_ = new TopcatServer();
        }
        return instance_;
    }

    static {
        logger_ = Logger.getLogger(TopcatServer.class.getName());
    }

    private static class ClassLoaderHandler
    implements HttpServer.Handler {
        private final URL baseResource_;
        private final String basePath_;

        ClassLoaderHandler(URL baseResource, String basePath) {
            this.baseResource_ = baseResource;
            this.basePath_ = basePath;
        }

        public HttpServer.Response serveRequest(HttpServer.Request request) {
            URLConnection conn;
            String path = request.getUrl();
            if (!path.startsWith(this.basePath_)) {
                return null;
            }
            String method = request.getMethod();
            String relPath = path.substring(this.basePath_.length());
            try {
                URL resource = new URL(this.baseResource_, relPath);
                conn = resource.openConnection();
                conn.connect();
            }
            catch (IOException e) {
                return HttpServer.createErrorResponse((int)404, (String)"Not found", (Throwable)e);
            }
            try {
                String contentEncoding;
                int contentLength;
                HashMap<String, String> hdrMap = new HashMap<String, String>();
                String contentType = conn.getContentType();
                if (contentType != null) {
                    hdrMap.put("Content-Type", contentType);
                }
                if ((contentLength = conn.getContentLength()) >= 0) {
                    hdrMap.put("Content-Length", Integer.toString(contentLength));
                }
                if ((contentEncoding = conn.getContentEncoding()) != null) {
                    hdrMap.put("Content-Encoding", contentEncoding);
                }
                if ("GET".equals(method)) {
                    return new HttpServer.Response(this, 200, "OK", hdrMap, conn){
                        private final /* synthetic */ URLConnection val$conn;
                        private final /* synthetic */ ClassLoaderHandler this$0;
                        {
                            this.this$0 = this$0;
                            this.val$conn = val$conn;
                            super(x0, x1, x2);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void writeBody(OutputStream out) throws IOException {
                            InputStream in = this.val$conn.getInputStream();
                            byte[] buf = new byte[16384];
                            try {
                                int nb;
                                while ((nb = in.read(buf)) >= 0) {
                                    out.write(buf, 0, nb);
                                }
                                out.flush();
                            }
                            finally {
                                in.close();
                            }
                        }
                    };
                }
                if ("HEAD".equals(method)) {
                    return new HttpServer.Response(this, 200, "OK", hdrMap){
                        private final /* synthetic */ ClassLoaderHandler this$0;
                        {
                            this.this$0 = this$0;
                            super(x0, x1, x2);
                        }

                        protected void writeBody(OutputStream out) {
                        }
                    };
                }
                return HttpServer.createErrorResponse((int)405, (String)"Unsupported method");
            }
            catch (Exception e) {
                return HttpServer.createErrorResponse((int)500, (String)"Internal server error", (Throwable)e);
            }
        }
    }

    private static class ResourceHandler
    implements HttpServer.Handler {
        private final String basePath_;
        private final URL serverUrl_;
        private final Map resourceMap_;
        private int iRes_;
        private static final ServerResource EXPIRED = new ServerResource(){

            public String getContentType() {
                throw new AssertionError();
            }

            public long getContentLength() {
                throw new AssertionError();
            }

            public void writeBody(OutputStream out) {
                throw new AssertionError();
            }
        };

        public ResourceHandler(HttpServer server, String basePath) {
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            this.basePath_ = basePath;
            this.serverUrl_ = server.getBaseUrl();
            this.resourceMap_ = new HashMap();
        }

        public synchronized URL addResource(String name, ServerResource resource) {
            String path = this.basePath_ + Integer.toString(++this.iRes_) + "/";
            if (name != null) {
                path = path + name;
            }
            this.resourceMap_.put(path, resource);
            try {
                URL url = new URL(this.serverUrl_, path);
                logger_.info("Resource added: " + url);
                return new URL(this.serverUrl_, path);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)"Unknown protocol http??");
            }
        }

        public synchronized void expireResource(URL url) {
            String path = url.getPath();
            if (!this.resourceMap_.containsKey(path)) {
                throw new IllegalArgumentException("Unknown URL to expire: " + url);
            }
            logger_.info("Resource expired: " + url);
            this.resourceMap_.put(path, EXPIRED);
        }

        public HttpServer.Response serveRequest(HttpServer.Request request) {
            String path = request.getUrl();
            if (!path.startsWith(this.basePath_)) {
                return null;
            }
            ServerResource resource = (ServerResource)this.resourceMap_.get(path);
            if (resource == EXPIRED) {
                return HttpServer.createErrorResponse((int)410, (String)"Gone");
            }
            if (resource != null) {
                String method;
                HashMap<String, String> hdrMap = new HashMap<String, String>();
                hdrMap.put("Content-Type", resource.getContentType());
                long contentLength = resource.getContentLength();
                if (contentLength >= 0L) {
                    hdrMap.put("Content-Length", Long.toString(contentLength));
                }
                if ((method = request.getMethod()).equals("HEAD")) {
                    return new HttpServer.Response(this, 200, "OK", hdrMap){
                        private final /* synthetic */ ResourceHandler this$0;
                        {
                            this.this$0 = this$0;
                            super(x0, x1, x2);
                        }

                        protected void writeBody(OutputStream out) {
                        }
                    };
                }
                if (method.equals("GET")) {
                    return new HttpServer.Response(this, 200, "OK", hdrMap, resource){
                        private final /* synthetic */ ServerResource val$resource;
                        private final /* synthetic */ ResourceHandler this$0;
                        {
                            this.this$0 = this$0;
                            this.val$resource = val$resource;
                            super(x0, x1, x2);
                        }

                        public void writeBody(OutputStream out) throws IOException {
                            this.val$resource.writeBody(out);
                        }
                    };
                }
                return HttpServer.createErrorResponse((int)405, (String)"Unsupported method");
            }
            return HttpServer.createErrorResponse((int)404, (String)"Not found");
        }
    }
}

