/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.MultiJoinType;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.OutputRequirements;
import uk.ac.starlink.topcat.join.TupleSelector;

public class InterMatchSpec
extends MatchSpec {
    private final int nTable;
    private final MatchEngine engine;
    private final TupleSelector[] tupleSelectors;
    private final OutputRequirements[] outReqs;
    private StarTable result;
    private int matchCount;
    private RowSubset[] matchSubsets;
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public InterMatchSpec(MatchEngine engine, int nTable) {
        int i;
        this.nTable = nTable;
        this.engine = engine;
        Box main = Box.createVerticalBox();
        this.add(main);
        this.tupleSelectors = new TupleSelector[nTable];
        for (i = 0; i < nTable; ++i) {
            TupleSelector selector = new TupleSelector(engine);
            selector.setBorder(AuxWindow.makeTitledBorder("Table " + (i + 1)));
            this.tupleSelectors[i] = selector;
            main.add(selector);
        }
        this.outReqs = new OutputRequirements[nTable];
        for (i = 0; i < nTable; ++i) {
            this.outReqs[i] = new OutputRequirements();
        }
        Box rowBox = Box.createVerticalBox();
        for (int i2 = 0; i2 < nTable; ++i2) {
            Box line = Box.createHorizontalBox();
            line.add(new JLabel("Table " + (i2 + 1) + ": "));
            line.add(this.outReqs[i2].getRowLine());
            rowBox.add(line);
        }
        rowBox.setBorder(AuxWindow.makeTitledBorder("Output Rows"));
        main.add(rowBox);
    }

    public void checkArguments() {
        for (int i = 0; i < this.nTable; ++i) {
            TupleSelector ts = this.tupleSelectors[i];
            try {
                StarTable st = ts.getEffectiveTable();
                continue;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " for table " + (i + 1));
            }
        }
    }

    public void calculate(ProgressIndicator indicator) throws IOException, InterruptedException {
        this.matchSubsets = null;
        this.result = null;
        TopcatModel[] tcModels = new TopcatModel[this.nTable];
        StarTable[] tables = new StarTable[this.nTable];
        StarTable[] bases = new StarTable[this.nTable];
        for (int i = 0; i < this.nTable; ++i) {
            tcModels[i] = this.tupleSelectors[i].getTable();
            tables[i] = this.tupleSelectors[i].getEffectiveTable();
            bases[i] = tcModels[i].getApparentStarTable();
        }
        MultiJoinType[] joinTypes = this.getJoinTypes();
        RowMatcher matcher = new RowMatcher(this.engine, tables);
        matcher.setIndicator(indicator);
        LinkSet matches = matcher.findGroupMatches(joinTypes);
        if (!matches.sort()) {
            logger.warning("Can't sort matches - matched table rows may be in an unhelpful order");
        }
        int nrow = matches.size();
        this.result = MatchStarTables.makeJoinTable((StarTable[])bases, (LinkSet)matches, (boolean)false, (JoinFixAction[])this.getDefaultFixActions(this.nTable), null);
        InterMatchSpec.addMatchMetadata(this.result, this.getDescription(), this.engine, tables);
        BitSet[] bitsets = new BitSet[this.nTable];
        for (int i = 0; i < this.nTable; ++i) {
            bitsets[i] = new BitSet();
        }
        this.matchCount = 0;
        int irow = 0;
        Iterator it = matches.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                int iTable = link.getRef(i).getTableIndex();
                bitsets[iTable].set(irow);
            }
            if (nref > 1) {
                ++this.matchCount;
            }
            ++irow;
        }
        if (!$assertionsDisabled && irow != nrow) {
            throw new AssertionError();
        }
        ArrayList<BitsRowSubset> subsetList = new ArrayList<BitsRowSubset>();
        for (int i = 0; i < this.nTable; ++i) {
            BitSet bset = bitsets[i];
            int ntrue = bset.cardinality();
            if (ntrue <= 0 || ntrue >= nrow) continue;
            BitsRowSubset rset = new BitsRowSubset("match" + tcModels[i].getID(), bitsets[i]);
            subsetList.add(rset);
        }
        this.matchSubsets = subsetList.toArray(new RowSubset[0]);
    }

    public void matchSuccess(Component parent) {
        int msgType;
        String title;
        String[] msg;
        if (this.result.getRowCount() == 0L || this.matchCount == 0) {
            msg = "Matched table contains no rows";
            title = "Match Failed";
            msgType = 0;
        } else {
            StringBuffer sbuf = new StringBuffer("match");
            for (int i = 0; i < this.nTable; ++i) {
                sbuf.append(i == 0 ? (char)'(' : ',');
                sbuf.append(this.tupleSelectors[i].getTable().getID());
            }
            sbuf.append(')');
            TopcatModel tcModel = ControlWindow.getInstance().addTable(this.result, sbuf.toString(), true);
            for (int i = 0; i < this.matchSubsets.length; ++i) {
                tcModel.addSubset(this.matchSubsets[i]);
            }
            msg = new String[]{this.matchCount + (this.nTable == 2 ? " pairs" : " match groups") + " found", "New table created by match: " + tcModel};
            title = "Match Successful";
            msgType = 1;
        }
        JOptionPane.showMessageDialog(parent, msg, title, msgType);
    }

    public String getDescription() {
        return "Multi-table match performed by TOPCAT";
    }

    private MultiJoinType[] getJoinTypes() {
        MultiJoinType[] joinTypes = new MultiJoinType[this.nTable];
        for (int i = 0; i < this.nTable; ++i) {
            joinTypes[i] = this.outReqs[i].getJoinType();
        }
        return joinTypes;
    }

    private static void addMatchMetadata(StarTable table, String matchType, MatchEngine engine, StarTable[] effTables) {
        int i;
        List params = table.getParameters();
        params.add(new DescribedValue(MATCHTYPE_INFO, (Object)matchType));
        params.add(new DescribedValue(ENGINE_INFO, (Object)engine.toString()));
        DescribedValue[] matchParams = engine.getMatchParameters();
        for (i = 0; i < matchParams.length; ++i) {
            params.add(matchParams[i]);
        }
        for (i = 0; i < effTables.length; ++i) {
            URL url;
            int i1 = i + 1;
            String id = null;
            if (id == null && (url = effTables[i].getURL()) != null) {
                id = url.toString();
            }
            if (id == null) {
                id = table.getName();
            }
            if (id == null) {
                id = "(virtual)";
            }
            DefaultValueInfo idInfo = new DefaultValueInfo("Matched table " + i1, class$java$lang$String == null ? InterMatchSpec.class$("java.lang.String") : class$java$lang$String, "Table on which the match was done");
            params.add(new DescribedValue((ValueInfo)idInfo, (Object)id));
        }
    }

    static {
        $assertionsDisabled = !InterMatchSpec.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.topcat.join");
    }
}

