/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JOptionPane;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.join.Match1TypeSelector;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.TupleSelector;

public class IntraMatchSpec
extends MatchSpec {
    private final TupleSelector tupleSelector_;
    private final Match1TypeSelector type1Selector_;
    private final MatchEngine engine_;
    private StarTable result_;
    private int matchCount_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.topcat.join");

    public IntraMatchSpec(MatchEngine engine) {
        this.engine_ = engine;
        Box main = Box.createVerticalBox();
        this.add(main);
        this.tupleSelector_ = new TupleSelector(this.engine_);
        this.tupleSelector_.setBorder(AuxWindow.makeTitledBorder("Table"));
        main.add(this.tupleSelector_);
        this.type1Selector_ = new Match1TypeSelector();
        this.type1Selector_.setBorder(AuxWindow.makeTitledBorder("Action"));
        main.add(this.type1Selector_);
    }

    public void checkArguments() {
        this.tupleSelector_.getEffectiveTable();
    }

    public void calculate(ProgressIndicator indicator) throws IOException, InterruptedException {
        this.result_ = null;
        StarTable effTable = this.tupleSelector_.getEffectiveTable();
        StarTable appTable = this.tupleSelector_.getTable().getApparentStarTable();
        RowMatcher matcher = new RowMatcher(this.engine_, new StarTable[]{effTable});
        matcher.setIndicator(indicator);
        LinkSet matches = matcher.findInternalMatches(false);
        if (!matches.sort()) {
            logger.warning("Can't sort matches - matched table rows may be in an unhelpful order");
        }
        this.matchCount_ = matches.size();
        this.result_ = this.matchCount_ == 0 ? null : this.type1Selector_.getType1().createMatchTable(appTable, matches);
    }

    public void matchSuccess(Component parent) {
        String[] msg;
        String title = "Match Successful";
        int msgType = 1;
        if (this.result_ == null || this.result_.getRowCount() == 0L) {
            msg = "No internal matches were found";
            title = "Match Failed";
            msgType = 2;
        } else {
            TopcatModel tcModel = ControlWindow.getInstance().addTable(this.result_, "matched", true);
            msg = new String[]{this.matchCount_ + " match groups located", "New table created by match: " + tcModel};
            title = "Match Successful";
            msgType = 1;
        }
        JOptionPane.showMessageDialog(parent, msg, title, msgType);
    }
}

