/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import uk.ac.starlink.table.join.Match1Type;

public class Match1TypeSelector
extends JPanel {
    private TypeOption option_;
    private static final TypeOption IDENTIFY = new FixedTypeOption("Mark Groups of Rows", Match1Type.createIdentifyType());
    private static final TypeOption ELIMINATE_0 = new FixedTypeOption("Eliminate All Grouped Rows", Match1Type.createEliminateMatchesType((int)0));
    private static final TypeOption ELIMINATE_1 = new FixedTypeOption("Eliminate All But First of Each Group", Match1Type.createEliminateMatchesType((int)1));
    private static final TypeOption WIDE = new WideTypeOption("New Table With Groups of Size ");
    private static final TypeOption[] OPTIONS = new TypeOption[]{IDENTIFY, ELIMINATE_0, ELIMINATE_1, WIDE};

    public Match1TypeSelector() {
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup buttGrp = new ButtonGroup();
        for (int i = 0; i < OPTIONS.length; ++i) {
            final TypeOption opt = OPTIONS[i];
            AbstractAction buttAct = new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    Match1TypeSelector.this.option_ = opt;
                }
            };
            JRadioButton butt = new JRadioButton(buttAct);
            buttGrp.add(butt);
            Box line = Box.createHorizontalBox();
            line.add(butt);
            line.add(new JLabel(" " + opt.getDescription()));
            Component[] extras = opt.getExtras();
            for (int j = 0; j < extras.length; ++j) {
                line.add(extras[j]);
            }
            line.add(Box.createHorizontalGlue());
            this.add(line);
            if (i != 0) continue;
            butt.doClick();
        }
    }

    public Match1Type getType1() {
        return this.option_.getType1();
    }

    private static class WideTypeOption
    extends TypeOption {
        private final JSpinner widthSelector_;

        WideTypeOption(String description) {
            super(description);
            SpinnerNumberModel widthModel = new SpinnerNumberModel();
            widthModel.setValue(new Integer(2));
            widthModel.setMinimum(new Integer(2));
            this.widthSelector_ = new JSpinner(widthModel);
        }

        public Match1Type getType1() {
            int wideness = ((Number)this.widthSelector_.getValue()).intValue();
            return Match1Type.createWideType((int)wideness);
        }

        public Component[] getExtras() {
            return new Component[]{this.widthSelector_};
        }
    }

    private static class FixedTypeOption
    extends TypeOption {
        private final Match1Type type1_;

        FixedTypeOption(String description, Match1Type type1) {
            super(description);
            this.type1_ = type1;
        }

        public Match1Type getType1() {
            return this.type1_;
        }

        public Component[] getExtras() {
            return new Component[0];
        }
    }

    private static abstract class TypeOption {
        private final String description_;

        TypeOption(String description) {
            this.description_ = description;
        }

        public String getDescription() {
            return this.description_;
        }

        public abstract Component[] getExtras();

        public abstract Match1Type getType1();
    }
}

