/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.join.AnisotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.CombinedMatchEngine;
import uk.ac.starlink.table.join.EqualsMatchEngine;
import uk.ac.starlink.table.join.HEALPixMatchEngine;
import uk.ac.starlink.table.join.HTMMatchEngine;
import uk.ac.starlink.table.join.IsotropicCartesianMatchEngine;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RangeModelProgressIndicator;
import uk.ac.starlink.table.join.SphericalPolarMatchEngine;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.join.InterMatchSpec;
import uk.ac.starlink.topcat.join.IntraMatchSpec;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.PairMatchSpec;
import uk.ac.starlink.topcat.join.ParameterPanel;

public class MatchWindow
extends AuxWindow
implements ItemListener {
    private final int nTable;
    private final JComboBox engineSelector;
    private final Map matchSpecs = new HashMap();
    private final CardLayout paramCards;
    private final JComponent paramContainer;
    private final JTextArea logArea;
    private final JScrollPane logScroller;
    private final JScrollPane specScroller;
    private final Action startAct;
    private final Action stopAct;
    private final JProgressBar progBar;
    private MatchProgressIndicator currentIndicator;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$join$MatchWindow;

    public MatchWindow(Component parent, int nTable) {
        super("Match Tables", parent);
        this.nTable = nTable;
        MatchEngine[] engines = MatchWindow.getEngines();
        int nEngine = engines.length;
        this.paramCards = new CardLayout();
        this.paramContainer = new JPanel(this.paramCards);
        for (int i = 0; i < nEngine; ++i) {
            MatchEngine engine = engines[i];
            this.paramContainer.add((Component)new ParameterPanel(engine), MatchWindow.labelFor(engine));
        }
        this.engineSelector = new JComboBox<MatchEngine>(engines);
        this.engineSelector.addItemListener(this);
        this.startAct = new MatchAction("Go", null, "Perform the match");
        this.stopAct = new MatchAction("Stop", null, "Cancel the calculation");
        this.stopAct.setEnabled(false);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(new JButton(this.startAct));
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(new JButton(this.stopAct));
        buttonBox.add(Box.createHorizontalGlue());
        this.getControlPanel().add(buttonBox);
        JPanel main = this.getMainArea();
        main.setLayout(new BorderLayout());
        Box common = Box.createVerticalBox();
        main.add((Component)common, "North");
        this.specScroller = new JScrollPane();
        main.add((Component)this.specScroller, "Center");
        Box engineBox = Box.createVerticalBox();
        Box line = Box.createHorizontalBox();
        line.add(new JLabel("Algorithm: "));
        line.add(this.engineSelector);
        line.add(Box.createHorizontalGlue());
        engineBox.add(line);
        line = Box.createHorizontalBox();
        line.add(this.paramContainer);
        line.add(Box.createHorizontalGlue());
        engineBox.add(line);
        engineBox.setBorder(MatchWindow.makeTitledBorder("Match Criteria"));
        common.add(engineBox);
        this.addHelp(nTable == 1 ? "MatchWindow1" : "MatchWindow");
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setRows(5);
        this.progBar = this.placeProgressBar();
        this.logScroller = new JScrollPane(this.logArea);
        main.add((Component)this.logScroller, "South");
        this.engineSelector.setSelectedIndex(0);
        this.updateDisplay();
    }

    private MatchSpec getMatchSpec() {
        MatchEngine engine = this.getMatchEngine();
        MatchEngine key = engine;
        if (!this.matchSpecs.containsKey(key)) {
            this.matchSpecs.put(key, this.makeMatchSpec(engine));
        }
        return (MatchSpec)this.matchSpecs.get(key);
    }

    private MatchEngine getMatchEngine() {
        return (MatchEngine)this.engineSelector.getSelectedItem();
    }

    private MatchSpec makeMatchSpec(MatchEngine engine) {
        switch (this.nTable) {
            case 1: {
                return new IntraMatchSpec(engine);
            }
            case 2: {
                return new PairMatchSpec(engine);
            }
        }
        return new InterMatchSpec(engine, this.nTable);
    }

    private void updateDisplay() {
        MatchEngine engine = this.getMatchEngine();
        if (engine != null) {
            this.paramCards.show(this.paramContainer, MatchWindow.labelFor(engine));
            this.specScroller.setViewportView(this.getMatchSpec().getPanel());
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.updateDisplay();
    }

    public void setBusy(boolean busy) {
        MatchWindow.recursiveSetEnabled(this.getMainArea(), !busy);
        this.logScroller.setEnabled(true);
        this.logArea.setEnabled(true);
        this.stopAct.setEnabled(busy);
        this.startAct.setEnabled(!busy);
        super.setBusy(busy);
    }

    private void appendLogLine(String line) {
        this.logArea.append(line);
        this.logArea.append("\n");
        this.logArea.setCaretPosition(this.logArea.getDocument().getLength());
    }

    public void dispose() {
        this.stopAct.actionPerformed(null);
        super.dispose();
    }

    private static String labelFor(MatchEngine engine) {
        return engine.getClass() + ":" + engine.toString() + "@" + System.identityHashCode(engine);
    }

    private static MatchEngine[] getEngines() {
        double someAngle = 4.84813681109536E-6;
        double someLength = 1.0;
        double[] someLengths1 = new double[1];
        double[] someLengths2 = new double[2];
        double[] someLengths3 = new double[3];
        double[] someLengths4 = new double[4];
        Arrays.fill(someLengths1, someLength);
        Arrays.fill(someLengths2, someLength);
        Arrays.fill(someLengths3, someLength);
        Arrays.fill(someLengths4, someLength);
        CombinedMatchEngine skyPlus1Engine = new CombinedMatchEngine(new MatchEngine[]{new HEALPixMatchEngine(someAngle, false), new AnisotropicCartesianMatchEngine(someLengths1)});
        skyPlus1Engine.setName("Sky + X");
        CombinedMatchEngine skyPlus2Engine = new CombinedMatchEngine(new MatchEngine[]{new HEALPixMatchEngine(someAngle, false), new AnisotropicCartesianMatchEngine(someLengths2)});
        skyPlus2Engine.setName("Sky + XY");
        HTMMatchEngine htmEngine = new HTMMatchEngine(someAngle, false){

            public String toString() {
                return "HTM";
            }
        };
        return new MatchEngine[]{new HEALPixMatchEngine(someAngle, false), new HEALPixMatchEngine(someAngle, true), new SphericalPolarMatchEngine(someLength), new EqualsMatchEngine(), new IsotropicCartesianMatchEngine(1, someLength, false), new IsotropicCartesianMatchEngine(2, someLength, false), new AnisotropicCartesianMatchEngine(someLengths2), new IsotropicCartesianMatchEngine(3, someLength, false), new AnisotropicCartesianMatchEngine(someLengths3), new AnisotropicCartesianMatchEngine(someLengths4), skyPlus1Engine, skyPlus2Engine, htmEngine};
    }

    static /* synthetic */ JTextArea access$300(MatchWindow x0) {
        return x0.logArea;
    }

    private class MatchAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        MatchAction(String name, Icon icon, String description) {
            super(name, icon, description);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == MatchWindow.this.startAct) {
                MatchSpec spec = MatchWindow.this.getMatchSpec();
                MatchEngine engine = MatchWindow.this.getMatchEngine();
                try {
                    spec.checkArguments();
                    new MatchWorker(spec, engine).start();
                }
                catch (IllegalStateException e) {
                    JOptionPane.showMessageDialog(MatchWindow.this, e.getMessage(), "Invalid Match Arguments", 2);
                }
            } else if (this == MatchWindow.this.stopAct) {
                if (MatchWindow.this.currentIndicator != null) {
                    MatchWindow.this.appendLogLine("Calculation interrupted");
                    MatchWindow.this.progBar.setValue(0);
                }
                MatchWindow.this.currentIndicator = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$join$MatchWindow == null ? (class$uk$ac$starlink$topcat$join$MatchWindow = MatchWindow.class$("uk.ac.starlink.topcat.join.MatchWindow")) : class$uk$ac$starlink$topcat$join$MatchWindow).desiredAssertionStatus();
        }
    }

    private class MatchProgressIndicator
    extends RangeModelProgressIndicator {
        private MatchProgressIndicator() {
        }

        public void startStage(String stage) {
            if (MatchWindow.this.currentIndicator == this) {
                MatchWindow.this.appendLogLine(stage + "...");
            }
            super.startStage(stage);
        }

        public void logMessage(String msg) {
            if (MatchWindow.this.currentIndicator == this) {
                MatchWindow.this.appendLogLine(msg);
            }
            super.logMessage(msg);
        }

        public void setLevel(double level) throws InterruptedException {
            if (MatchWindow.this.currentIndicator != this) {
                throw new InterruptedException("Interrupted by user");
            }
            super.setLevel(level);
        }
    }

    private class MatchWorker
    extends Thread {
        final MatchSpec spec;
        final MatchEngine engine;

        MatchWorker(MatchSpec spec, MatchEngine engine) {
            super("Row Matcher");
            this.spec = spec;
            this.engine = engine;
        }

        public void run() {
            MatchWindow.this.currentIndicator = new MatchProgressIndicator();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ MatchWorker this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    MatchWorker.access$200(this.this$1).setBusy(true);
                    MatchWindow.access$300(MatchWorker.access$200(this.this$1)).setText("");
                    MatchWindow.access$400(MatchWorker.access$200(this.this$1)).setModel((BoundedRangeModel)((Object)MatchWindow.access$000(MatchWorker.access$200(this.this$1))));
                }
            });
            try {
                this.spec.calculate((ProgressIndicator)MatchWindow.this.currentIndicator);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ MatchWorker this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        MatchWorker.access$200(this.this$1).setBusy(false);
                        this.this$1.spec.matchSuccess(MatchWorker.access$200(this.this$1));
                        MatchWindow.access$500(MatchWorker.access$200(this.this$1), "Match succeeded");
                        MatchWindow.access$400(MatchWorker.access$200(this.this$1)).setValue(0);
                        MatchWindow.access$002(MatchWorker.access$200(this.this$1), null);
                    }
                });
            }
            catch (Throwable e) {
                SwingUtilities.invokeLater(new Runnable(this, e){
                    private final /* synthetic */ Throwable val$e;
                    private final /* synthetic */ MatchWorker this$1;
                    {
                        this.this$1 = this$1;
                        this.val$e = val$e;
                    }

                    public void run() {
                        if (!(this.val$e instanceof InterruptedException)) {
                            MatchWindow.access$500(MatchWorker.access$200(this.this$1), "Match failed: " + this.val$e.getMessage());
                            this.this$1.spec.matchFailure(this.val$e, MatchWorker.access$200(this.this$1));
                        }
                        MatchWorker.access$200(this.this$1).setBusy(false);
                    }
                });
            }
        }

        static /* synthetic */ MatchWindow access$200(MatchWorker x0) {
            return x0.MatchWindow.this;
        }
    }
}

