/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.join;

import java.awt.Component;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BitsRowSubset;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.join.MatchSpec;
import uk.ac.starlink.topcat.join.TupleSelector;

public class PairMatchSpec
extends MatchSpec {
    private final MatchEngine engine_;
    private final TupleSelector[] tupleSelectors_;
    private final BestSelector bestSelector_;
    private final JoinSelector joinSelector_;
    private StarTable result_;
    private RowSubset matchSubset_;
    private int pairCount_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PairMatchSpec(MatchEngine engine) {
        this.engine_ = engine;
        Box main = Box.createVerticalBox();
        this.add(main);
        this.tupleSelectors_ = new TupleSelector[2];
        for (int i = 0; i < 2; ++i) {
            TupleSelector selector = new TupleSelector(engine);
            selector.setBorder(AuxWindow.makeTitledBorder("Table " + (i + 1)));
            this.tupleSelectors_[i] = selector;
            main.add(selector);
        }
        Box rowBox = Box.createVerticalBox();
        this.bestSelector_ = new BestSelector();
        rowBox.add(this.bestSelector_);
        rowBox.add(Box.createVerticalStrut(5));
        this.joinSelector_ = new JoinSelector();
        rowBox.add(this.joinSelector_);
        rowBox.add(Box.createVerticalStrut(5));
        rowBox.setBorder(AuxWindow.makeTitledBorder("Output Rows"));
        main.add(rowBox);
    }

    public void checkArguments() {
        for (int i = 0; i < 2; ++i) {
            try {
                this.tupleSelectors_[i].getEffectiveTable();
                continue;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + " for table " + (i + 1));
            }
        }
    }

    public void calculate(ProgressIndicator indicator) throws IOException, InterruptedException {
        this.result_ = null;
        this.matchSubset_ = null;
        this.pairCount_ = 0;
        TopcatModel[] tcModels = new TopcatModel[2];
        StarTable[] tables = new StarTable[2];
        StarTable[] bases = new StarTable[2];
        int[] rowCounts = new int[2];
        for (int i = 0; i < 2; ++i) {
            tcModels[i] = this.tupleSelectors_[i].getTable();
            tables[i] = this.tupleSelectors_[i].getEffectiveTable();
            bases[i] = tcModels[i].getApparentStarTable();
            rowCounts[i] = Tables.checkedLongToInt((long)tables[i].getRowCount());
        }
        JoinType joinType = this.joinSelector_.getJoinType();
        boolean bestOnly = this.bestSelector_.isBest();
        RowMatcher matcher = new RowMatcher(this.engine_, tables);
        matcher.setIndicator(indicator);
        LinkSet pairs = matcher.findPairMatches(bestOnly);
        this.pairCount_ = pairs.size();
        if (!pairs.sort()) {
            logger_.warning("Can't sort matches - matched table rows may be in an unhelpful order");
        }
        LinkSet links = joinType.processLinks(pairs, rowCounts);
        ValueInfo scoreInfo = joinType.getUsedMatchFlag() ? this.engine_.getMatchScoreInfo() : null;
        boolean addGroups = !bestOnly;
        JoinFixAction[] fixActs = this.getDefaultFixActions(2);
        StarTable[] useBases = (StarTable[])bases.clone();
        for (int i = 0; i < 2; ++i) {
            if (joinType.getUsedTableFlags()[i]) continue;
            useBases[i] = null;
            fixActs[i] = null;
        }
        this.result_ = MatchStarTables.makeJoinTable((StarTable[])useBases, (LinkSet)links, (boolean)addGroups, (JoinFixAction[])fixActs, (ValueInfo)scoreInfo);
        PairMatchSpec.addMatchMetadata(this.result_, this.engine_, bestOnly, joinType, tcModels);
        if (joinType.getUsedMatchFlag()) {
            BitSet matched = new BitSet();
            int iLink = 0;
            Iterator it = links.iterator();
            while (it.hasNext()) {
                RowLink link = (RowLink)it.next();
                matched.set(iLink++, link.size() == 2);
            }
            if (!$assertionsDisabled && iLink != links.size()) {
                throw new AssertionError();
            }
            int nMatch = matched.cardinality();
            if (nMatch > 0 && nMatch < links.size()) {
                this.matchSubset_ = new BitsRowSubset("matched", matched);
            }
        }
    }

    public void matchSuccess(Component parent) {
        String[] msg;
        int msgType;
        String title;
        if (this.result_.getRowCount() == 0L) {
            title = "Match failed";
            msgType = 0;
            msg = "Result of match contains no rows";
        } else if (this.pairCount_ == 0) {
            title = "Match failed";
            msgType = 0;
            msg = "No pairs were found when matching";
        } else {
            title = "Match Successful";
            msgType = 1;
            String tname = "match(" + this.tupleSelectors_[0].getTable().getID() + "," + this.tupleSelectors_[1].getTable().getID() + ")";
            TopcatModel tcModel = ControlWindow.getInstance().addTable(this.result_, tname, true);
            if (this.matchSubset_ != null) {
                tcModel.addSubset(this.matchSubset_);
            }
            msg = new String[]{this.pairCount_ + " pairs found", "New table created by match: " + tcModel + " (" + this.result_.getRowCount() + " rows)"};
        }
        JOptionPane.showMessageDialog(parent, msg, title, msgType);
    }

    public String getDescription() {
        return this.toString();
    }

    private static void addMatchMetadata(StarTable table, MatchEngine engine, boolean bestOnly, JoinType joinType, TopcatModel[] tcModels) {
        List params = table.getParameters();
        String type = "Pair match" + (bestOnly ? ", best matched pairs only" : ", all matched pairs included");
        params.add(new DescribedValue(MATCHTYPE_INFO, (Object)type));
        params.add(new DescribedValue(ENGINE_INFO, (Object)engine.toString()));
        DefaultValueInfo joinInfo = new DefaultValueInfo("Join Type", String.class, "Determines which rows appear in output table");
        String joinValue = joinType.toString() + " (" + joinType.getDescription() + ")";
        params.add(new DescribedValue((ValueInfo)joinInfo, (Object)joinValue));
        params.add(new DescribedValue((ValueInfo)new DefaultValueInfo("First input table", String.class), (Object)tcModels[0].toString()));
        params.add(new DescribedValue((ValueInfo)new DefaultValueInfo("Second input table", String.class), (Object)tcModels[1].toString()));
    }

    static {
        $assertionsDisabled = !PairMatchSpec.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat.join");
    }

    private static class JoinSelector
    extends Box {
        final JComboBox jCombo_ = new JComboBox<JoinType>(JoinType.getPairTypes());

        JoinSelector() {
            super(0);
            this.jCombo_.setSelectedItem(JoinType._1AND2);
            this.add(new JLabel("Join Type: "));
            this.add(this.jCombo_);
        }

        JoinType getJoinType() {
            return (JoinType)this.jCombo_.getSelectedItem();
        }
    }

    private static class BestSelector
    extends Box {
        final JRadioButton bestButton_ = new JRadioButton("Best Match Only");
        final JRadioButton allButton_ = new JRadioButton("All Matches");

        BestSelector() {
            super(0);
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.bestButton_);
            grp.add(this.allButton_);
            this.bestButton_.setSelected(true);
            this.add(new JLabel("Match Selection: "));
            this.add(this.bestButton_);
            this.add(this.allButton_);
        }

        boolean isBest() {
            return this.bestButton_.isSelected();
        }
    }
}

